/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.trace;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.FloatDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.FloatDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.ICompositeDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.ISimpleDatatypeDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.SimpleDatatypeDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StringDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StructDefinition;
import org.eclipse.tracecompass.ctf.core.trace.CTFStreamInput;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.core.trace.ICTFPacketDescriptor;
import org.eclipse.tracecompass.ctf.core.trace.ICTFStream;
import org.eclipse.tracecompass.internal.ctf.core.Activator;
import org.eclipse.tracecompass.internal.ctf.core.SafeMappedByteBuffer;
import org.eclipse.tracecompass.internal.ctf.core.event.EventDefinition;
import org.eclipse.tracecompass.internal.ctf.core.trace.CTFPacketReader;
import org.eclipse.tracecompass.internal.ctf.core.trace.StreamInputPacketIndexEntry;

public class CTFStreamPacketOutputWriter {
    private CTFStreamInput fStreamInput;

    public CTFStreamPacketOutputWriter() {
        throw new UnsupportedOperationException();
    }

    public CTFStreamPacketOutputWriter(@NonNull CTFStreamInput streamInput) {
        this.fStreamInput = streamInput;
    }

    public void writePacket(ByteBuffer byteBuffer, FileChannel output) throws IOException {
        output.write(byteBuffer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writePacket(ICTFPacketDescriptor entry, FileChannel output, long initialLost) throws IOException, CTFException {
        long startOffsetBits = entry.getPayloadStartBits();
        long endOffsetBits = entry.getContentSizeBits();
        StructDefinition context = null;
        File file = this.fStreamInput.getFile();
        Throwable throwable = null;
        Object var12_10 = null;
        try {
            FileChannel fc = FileChannel.open(file.toPath(), StandardOpenOption.READ);
            try {
                ByteBuffer bb = SafeMappedByteBuffer.map(fc, FileChannel.MapMode.READ_ONLY, entry.getOffsetBytes(), (long)Math.ceil((double)entry.getContentSizeBits() / 8.0));
                BitBuffer bbInput = new BitBuffer(bb);
                bbInput.position(entry.getPayloadStartBits());
                ICTFStream stream = this.fStreamInput.getStream();
                CTFTrace trace = stream.getTrace();
                CTFPacketReader currentPacketReader = new CTFPacketReader(bbInput, entry, stream.getEventDeclarations(), stream.getEventHeaderDeclaration(), stream.getEventContextDecl(), trace.getPacketHeaderDef(), trace);
                if (entry instanceof StreamInputPacketIndexEntry) {
                    context = ((StreamInputPacketIndexEntry)entry).getStreamPacketContextDef();
                }
                if (context == null) {
                    return;
                }
                ICompositeDefinition tracePacketHeader = currentPacketReader.getTracePacketHeader();
                CTFStreamPacketOutputWriter.writeCustomPacket(entry, fc, output, startOffsetBits, endOffsetBits, context, tracePacketHeader, entry.getTimestampBegin(), initialLost);
                return;
            }
            finally {
                if (fc == null) return;
                fc.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writePacket(ICTFPacketDescriptor entry, long startTime, long endTime, long initialLost, FileChannel output) throws IOException, CTFException {
        if (entry.getTimestampBegin() > endTime) throw new IllegalStateException();
        if (entry.getTimestampEnd() < startTime) throw new IllegalStateException();
        if (startTime > endTime) {
            throw new IllegalStateException();
        }
        long startOffsetBits = entry.getPayloadStartBits();
        long endOffsetBits = entry.getContentSizeBits();
        StructDefinition context = null;
        File file = this.fStreamInput.getFile();
        Throwable throwable = null;
        Object var16_12 = null;
        try {
            FileChannel fc = FileChannel.open(file.toPath(), StandardOpenOption.READ);
            try {
                ByteBuffer bb = SafeMappedByteBuffer.map(fc, FileChannel.MapMode.READ_ONLY, entry.getOffsetBytes(), CTFStreamPacketOutputWriter.bitsToBytes(entry.getContentSizeBits()));
                BitBuffer bbInput = new BitBuffer(bb);
                bbInput.position(entry.getPayloadStartBits());
                ICTFStream stream = this.fStreamInput.getStream();
                CTFTrace trace = stream.getTrace();
                CTFPacketReader currentPacketReader = new CTFPacketReader(bbInput, entry, stream.getEventDeclarations(), stream.getEventHeaderDeclaration(), stream.getEventContextDecl(), trace.getPacketHeaderDef(), trace);
                long lastLargeTimestamp = entry.getTimestampBegin();
                if (entry instanceof StreamInputPacketIndexEntry) {
                    context = ((StreamInputPacketIndexEntry)entry).getStreamPacketContextDef();
                }
                if (context == null) {
                    return;
                }
                boolean startIsSet = false;
                while (currentPacketReader.hasMoreEvents()) {
                    EventDefinition event = currentPacketReader.readNextEvent();
                    long timestampInCycles = event.getTimestamp();
                    if (!startIsSet) {
                        Definition definition;
                        ICompositeDefinition eventHeader = event.getEventHeader();
                        Definition def = null;
                        if (eventHeader != null) {
                            def = eventHeader.getDefinition("timestamp");
                        }
                        if (def == null && eventHeader instanceof StructDefinition) {
                            StructDefinition structDefinition = (StructDefinition)eventHeader;
                            def = structDefinition.lookupDefinition("timestamp");
                        }
                        if ((definition = ((StreamInputPacketIndexEntry)entry).getStreamPacketContextDef().getDefinition("timestamp_begin")) != null && def != null && def.size() == definition.size()) {
                            lastLargeTimestamp = timestampInCycles;
                        }
                    }
                    if (timestampInCycles >= startTime && !startIsSet) {
                        startOffsetBits = currentPacketReader.getLocation();
                        startIsSet = true;
                    }
                    if (timestampInCycles <= endTime) continue;
                    endOffsetBits = currentPacketReader.getLocation();
                    break;
                }
                if (startOffsetBits >= endOffsetBits) {
                    return;
                }
                ICompositeDefinition tracePacketHeader = currentPacketReader.getTracePacketHeader();
                CTFStreamPacketOutputWriter.writeCustomPacket(entry, fc, output, startOffsetBits, endOffsetBits, context, tracePacketHeader, lastLargeTimestamp, initialLost);
                return;
            }
            finally {
                if (fc == null) return;
                fc.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private static void writeCustomPacket(ICTFPacketDescriptor entry, FileChannel source, FileChannel output, long startOffsetBits, long endOffsetBits, StructDefinition packetContext, ICompositeDefinition tracePacketHeader, long startTime, long initialLost) throws IOException, CTFException {
        ByteBuffer inBuffer = SafeMappedByteBuffer.map(source, FileChannel.MapMode.READ_ONLY, entry.getOffsetBytes(), CTFStreamPacketOutputWriter.bitsToBytes(entry.getContentSizeBits()));
        int headerSize = (int)(tracePacketHeader == null ? 0L : tracePacketHeader.size());
        int packetSize = (int)((long)headerSize + packetContext.size() + endOffsetBits - startOffsetBits);
        byte[] toWrite = new byte[(int)CTFStreamPacketOutputWriter.bitsToBytes(packetSize)];
        ByteBuffer buffer = ByteBuffer.wrap(toWrite);
        byte[] header = new byte[(int)CTFStreamPacketOutputWriter.bitsToBytes(headerSize)];
        byte[] body = new byte[(int)CTFStreamPacketOutputWriter.bitsToBytes(endOffsetBits - startOffsetBits)];
        inBuffer.get(header);
        inBuffer.position((int)CTFStreamPacketOutputWriter.bitsToBytes(startOffsetBits));
        inBuffer.get(body);
        buffer.put(header);
        CTFStreamPacketOutputWriter.writeContext(startTime, packetContext, packetSize, initialLost, buffer);
        buffer.position((int)CTFStreamPacketOutputWriter.bitsToBytes((long)headerSize + packetContext.size()));
        buffer.put(body);
        output.write(ByteBuffer.wrap(toWrite));
    }

    private static long bitsToBytes(long bits) {
        return (long)Math.ceil((double)bits / 8.0);
    }

    private static void writeContext(long startTime, StructDefinition context, int newPacketSize, long initialLost, @NonNull ByteBuffer buffer) throws CTFException {
        BitBuffer bb = new BitBuffer(buffer);
        bb.position(buffer.position() * 8);
        for (String field : context.getFieldNames()) {
            Definition def = context.getDefinition(field);
            IDeclaration declaration = def.getDeclaration();
            CTFStreamPacketOutputWriter.align(declaration.getAlignment(), bb);
            if (declaration instanceof ISimpleDatatypeDeclaration) {
                bb.setByteOrder(((ISimpleDatatypeDeclaration)((Object)declaration)).getByteOrder());
            }
            if (def instanceof SimpleDatatypeDefinition) {
                SimpleDatatypeDefinition simpleDef = (SimpleDatatypeDefinition)def;
                int size = (int)simpleDef.size();
                if (field.equals("packet_size") || field.equals("content_size")) {
                    bb.putLong(size, newPacketSize);
                    continue;
                }
                if (field.equals("timestamp_begin")) {
                    bb.putLong(size, startTime);
                    continue;
                }
                if (field.equals("events_discarded")) {
                    bb.putLong(size, simpleDef.getIntegerValue() - initialLost);
                    continue;
                }
                bb.putLong(size, simpleDef.getIntegerValue());
                continue;
            }
            if (def instanceof StringDefinition) {
                CTFStreamPacketOutputWriter.writeString(bb, def);
                continue;
            }
            if (def instanceof FloatDefinition) {
                CTFStreamPacketOutputWriter.writeFloat(bb, def);
                continue;
            }
            buffer.put(new byte[(int)CTFStreamPacketOutputWriter.bitsToBytes(def.size())]);
            bb.position((long)buffer.position() * 8L);
        }
        buffer.position((int)CTFStreamPacketOutputWriter.bitsToBytes(bb.position()));
    }

    private static void align(long align, BitBuffer input) throws CTFException {
        long mask = align - 1L;
        long pos = input.position();
        if ((pos & mask) == 0L) {
            return;
        }
        pos = pos + mask & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        input.position(pos);
    }

    private static void writeFloat(BitBuffer bb, Definition def) throws CTFException {
        FloatDefinition floatDefinition = (FloatDefinition)def;
        double value = floatDefinition.getValue();
        FloatDeclaration declaration = floatDefinition.getDeclaration();
        int exponent = declaration.getExponent();
        int mantissa = declaration.getMantissa();
        if (mantissa == 23 && exponent == 8) {
            bb.putInt(32, Float.floatToIntBits((float)value));
        } else if (mantissa == 52 && exponent == 11) {
            bb.putLong(64, Double.doubleToLongBits(value));
        } else {
            bb.putLong((int)floatDefinition.size(), Double.doubleToRawLongBits(value));
        }
    }

    private static void writeString(BitBuffer bb, Definition def) throws CTFException {
        StringDefinition stringDefinition = (StringDefinition)def;
        byte[] bytes = stringDefinition.toString().getBytes();
        try {
            bytes = stringDefinition.toString().getBytes(stringDefinition.getDeclaration().getEncoding().toString());
        }
        catch (UnsupportedEncodingException e) {
            Activator.log("Writing packet made an encoding error! " + e.getMessage());
        }
        bb.put(bytes);
        bb.put((byte)0);
    }
}

