/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.preferences;

import com.google.common.collect.Iterables;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlAnalysisModuleSource;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.preferences.Messages;
import org.eclipse.tracecompass.tmf.ui.dialog.TmfFileDialogFactory;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfOpenTraceHelper;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class XMLAnalysesManagerPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int BUTTON_CHECK_SELECTED_ID = 1024;
    private static final int BUTTON_UNCHECK_SELECTED_ID = 1025;
    private static final String XML_FILTER_EXTENSION = "*.xml";
    private Table fAnalysesTable;
    private Button fDeleteButton;
    private Button fExportButton;
    private Button fEditButton;
    private Label fInvalidFileLabel;
    private Label fEnabledFileLabel;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.getShell().setText(Messages.ManageXMLAnalysisDialog_ManageXmlAnalysesFiles);
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayout((Layout)new GridLayout(2, false));
        Composite tableContainer = new Composite(mainComposite, 0);
        tableContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayoutFactory.fillDefaults().applyTo(tableContainer);
        this.createTable(tableContainer);
        this.createLabels(tableContainer);
        this.createImportButtons(mainComposite);
        this.createSelectionButtons(mainComposite);
        this.fillAnalysesTable();
        this.getShell().setMinimumSize(300, 275);
        return mainComposite;
    }

    public boolean performOk() {
        this.handleChecks();
        return super.performOk();
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    private void createTable(Composite composite) {
        this.fAnalysesTable = new Table(composite, 2850);
        this.fAnalysesTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fAnalysesTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (XMLAnalysesManagerPreferencePage.this.fAnalysesTable.getSelectionCount() == 0) {
                    XMLAnalysesManagerPreferencePage.this.setButtonsEnabled(false);
                } else {
                    XMLAnalysesManagerPreferencePage.this.setButtonsEnabled(true);
                    XMLAnalysesManagerPreferencePage.this.handleSelection(XMLAnalysesManagerPreferencePage.this.fAnalysesTable.getSelection()[0]);
                }
            }
        });
    }

    private void createLabels(Composite composite) {
        this.fInvalidFileLabel = new Label(composite, 1);
        this.fInvalidFileLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fInvalidFileLabel.setForeground(this.getShell().getDisplay().getSystemColor(3));
        this.fInvalidFileLabel.setText(Messages.ManageXMLAnalysisDialog_FileValidationError);
        this.fInvalidFileLabel.setVisible(false);
        this.fEnabledFileLabel = new Label(composite, 16);
        this.fEnabledFileLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fEnabledFileLabel.setForeground(this.getShell().getDisplay().getSystemColor(6));
        this.fEnabledFileLabel.setText(Messages.ManageXMLAnalysisDialog_FileEnabled);
        this.fEnabledFileLabel.setVisible(false);
    }

    private void createImportButtons(Composite composite) {
        Composite buttonContainer = new Composite(composite, 0);
        buttonContainer.setLayout((Layout)new GridLayout());
        buttonContainer.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        Button importButton = new Button(buttonContainer, 8);
        importButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        importButton.setText(Messages.ManageXMLAnalysisDialog_Import);
        importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLAnalysesManagerPreferencePage.this.importAnalysis();
            }
        });
        this.fExportButton = new Button(buttonContainer, 8);
        this.fExportButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fExportButton.setText(Messages.ManageXMLAnalysisDialog_Export);
        this.fExportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLAnalysesManagerPreferencePage.this.exportAnalysis();
            }
        });
        this.fEditButton = new Button(buttonContainer, 8);
        this.fEditButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fEditButton.setText(Messages.ManageXMLAnalysisDialog_Edit);
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLAnalysesManagerPreferencePage.this.editAnalysis();
            }
        });
        this.fDeleteButton = new Button(buttonContainer, 8);
        this.fDeleteButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fDeleteButton.setText(Messages.ManageXMLAnalysisDialog_Delete);
        this.fDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLAnalysesManagerPreferencePage.this.deleteAnalysis();
            }
        });
        this.setButtonsEnabled(false);
    }

    protected void createSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginWidth = 0;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setFont(composite.getFont());
        GridData data = new GridData(131072, 128, false, false);
        buttonComposite.setLayoutData((Object)data);
        Button checkSelectedButton = XMLAnalysesManagerPreferencePage.createButton(buttonComposite, 1024, Messages.ManageXMLAnalysisDialog_CHECK_SELECTED);
        Button checkAllButton = XMLAnalysesManagerPreferencePage.createButton(buttonComposite, 18, Messages.ManageXMLAnalysisDialog_CHECK_ALL);
        Button uncheckSelectedButton = XMLAnalysesManagerPreferencePage.createButton(buttonComposite, 1025, Messages.ManageXMLAnalysisDialog_UNCHECK_SELECTED);
        Button uncheckAllButton = XMLAnalysesManagerPreferencePage.createButton(buttonComposite, 19, Messages.ManageXMLAnalysisDialog_UNCHECK_ALL);
        checkSelectedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableItemArray = XMLAnalysesManagerPreferencePage.this.fAnalysesTable.getSelection();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem selectedItem = tableItemArray[n2];
                    selectedItem.setChecked(true);
                    ++n2;
                }
            }
        });
        checkAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableItemArray = XMLAnalysesManagerPreferencePage.this.fAnalysesTable.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem selectedItem = tableItemArray[n2];
                    selectedItem.setChecked(true);
                    ++n2;
                }
            }
        });
        uncheckSelectedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableItemArray = XMLAnalysesManagerPreferencePage.this.fAnalysesTable.getSelection();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem selectedItem = tableItemArray[n2];
                    selectedItem.setChecked(false);
                    ++n2;
                }
            }
        });
        uncheckAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableItemArray = XMLAnalysesManagerPreferencePage.this.fAnalysesTable.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem selectedItem = tableItemArray[n2];
                    selectedItem.setChecked(false);
                    ++n2;
                }
            }
        });
    }

    private static Button createButton(Composite parent, int id, String label) {
        Button button = new Button(parent, 8);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)id);
        GridData data = new GridData(4, 0x1000000, true, true);
        button.setLayoutData((Object)data);
        return button;
    }

    private void setButtonsEnabled(boolean enable) {
        this.fDeleteButton.setEnabled(enable);
        this.fExportButton.setEnabled(enable);
        this.fEditButton.setEnabled(enable);
    }

    private void handleSelection(TableItem selection) {
        String xmlName = XmlUtils.createXmlFileString((String)selection.getText());
        if (XMLAnalysesManagerPreferencePage.isFileValid(xmlName)) {
            this.fInvalidFileLabel.setVisible(false);
            this.fEnabledFileLabel.setVisible(XmlUtils.isAnalysisEnabled((String)xmlName));
        } else {
            this.fInvalidFileLabel.setVisible(true);
            this.fEnabledFileLabel.setVisible(false);
            if (XmlUtils.isAnalysisEnabled((String)xmlName)) {
                XMLAnalysesManagerPreferencePage.disableAnalysis(xmlName);
                selection.setChecked(false);
            }
        }
    }

    private void fillAnalysesTable() {
        this.fAnalysesTable.removeAll();
        Map files = XmlUtils.listFiles();
        for (String file : files.keySet()) {
            Path path = new Path(file);
            TableItem item = new TableItem(this.fAnalysesTable, 0);
            item.setText(path.removeFileExtension().toString());
            item.setChecked(XmlUtils.isAnalysisEnabled((String)path.toString()));
        }
        this.setButtonsEnabled(false);
    }

    private void handleChecks() {
        TableItem[] tableItemArray = this.fAnalysesTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            String xmlName = XmlUtils.createXmlFileString((String)item.getText());
            if (item.getChecked()) {
                if (!XmlUtils.isAnalysisEnabled((String)xmlName)) {
                    if (XMLAnalysesManagerPreferencePage.isFileValid(xmlName)) {
                        XMLAnalysesManagerPreferencePage.enableAnalysis(xmlName);
                    } else {
                        item.setChecked(false);
                    }
                }
            } else if (XmlUtils.isAnalysisEnabled((String)xmlName)) {
                XMLAnalysesManagerPreferencePage.disableAnalysis(xmlName);
            }
            if (this.fAnalysesTable.getSelectionCount() > 0) {
                this.handleSelection(this.fAnalysesTable.getSelection()[0]);
            }
            ++n2;
        }
    }

    private static void enableAnalysis(String xmlName) {
        List<TmfCommonProjectElement> elements = XMLAnalysesManagerPreferencePage.deleteSupplementaryFile(xmlName);
        XmlUtils.enableFile((String)xmlName);
        XmlAnalysisModuleSource.notifyModuleChange();
        XMLAnalysesManagerPreferencePage.refreshProject(elements);
    }

    private static void disableAnalysis(String xmlName) {
        List<TmfCommonProjectElement> elements = XMLAnalysesManagerPreferencePage.deleteSupplementaryFile(xmlName);
        XmlUtils.disableFile((String)xmlName);
        XmlAnalysisModuleSource.notifyModuleChange();
        XMLAnalysesManagerPreferencePage.refreshProject(elements);
    }

    private void importAnalysis() {
        FileDialog dialog = TmfFileDialogFactory.create((Shell)Display.getCurrent().getActiveShell(), (int)4098);
        dialog.setText(Messages.ManageXMLAnalysisDialog_SelectFileImport);
        dialog.setFilterNames(new String[]{String.valueOf(Messages.ManageXMLAnalysisDialog_ImportXmlFile) + " (" + XML_FILTER_EXTENSION + ")"});
        dialog.setFilterExtensions(new String[]{XML_FILTER_EXTENSION});
        dialog.open();
        String directoryPath = dialog.getFilterPath();
        if (!directoryPath.isEmpty()) {
            File directory = new File(directoryPath);
            String[] files = dialog.getFileNames();
            boolean isFileImported = false;
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                File file = new File(directory, fileName);
                if (XMLAnalysesManagerPreferencePage.loadXmlFile(file, true)) {
                    isFileImported |= true;
                }
                ++n2;
            }
            if (isFileImported) {
                this.fillAnalysesTable();
            }
        }
    }

    private static boolean loadXmlFile(File file, boolean addFile) {
        IStatus status = XmlUtils.xmlValidate((File)file);
        if (status.isOK()) {
            List<TmfCommonProjectElement> elements = XMLAnalysesManagerPreferencePage.deleteSupplementaryFile(file.getName());
            if (addFile) {
                status = XmlUtils.addXmlFile((File)file);
            } else {
                XmlUtils.updateXmlFile((File)file);
            }
            if (status.isOK()) {
                XmlAnalysisModuleSource.notifyModuleChange();
                XMLAnalysesManagerPreferencePage.refreshProject(elements);
                return true;
            }
            Activator.logError(Messages.ManageXMLAnalysisDialog_ImportFileFailed);
            TraceUtils.displayErrorMsg((String)Messages.ManageXMLAnalysisDialog_ImportFileFailed, (String)status.getMessage());
        } else {
            Activator.logError(Messages.ManageXMLAnalysisDialog_ImportFileFailed);
            TraceUtils.displayErrorMsg((String)Messages.ManageXMLAnalysisDialog_ImportFileFailed, (String)status.getMessage());
        }
        return false;
    }

    private void exportAnalysis() {
        TableItem[] selection;
        FileDialog dialog = TmfFileDialogFactory.create((Shell)Display.getCurrent().getActiveShell(), (int)8192);
        TableItem[] tableItemArray = selection = this.fAnalysesTable.getSelection();
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            String fileName = item.getText();
            dialog.setText(NLS.bind((String)Messages.ManageXMLAnalysisDialog_SelectFileExport, (Object)fileName));
            dialog.setFilterExtensions(new String[]{XML_FILTER_EXTENSION, "*"});
            String fileNameXml = XmlUtils.createXmlFileString((String)fileName);
            dialog.setFileName(fileNameXml);
            String path = dialog.open();
            if (path != null && !XmlUtils.exportXmlFile((String)fileNameXml, (String)path).isOK()) {
                Activator.logError(NLS.bind((String)Messages.ManageXMLAnalysisDialog_FailedToExport, (Object)fileNameXml));
            }
            ++n2;
        }
    }

    private void editAnalysis() {
        TableItem[] tableItemArray = this.fAnalysesTable.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            String selection = XmlUtils.createXmlFileString((String)item.getText());
            final @Nullable File file = (File)XmlUtils.listFiles().get(selection);
            if (file == null) {
                Activator.logError(NLS.bind((String)Messages.ManageXMLAnalysisDialog_FailedToEdit, (Object)selection));
                TraceUtils.displayErrorMsg((String)NLS.bind((String)Messages.ManageXMLAnalysisDialog_FailedToEdit, (Object)selection), (String)NLS.bind((String)Messages.ManageXMLAnalysisDialog_FailedToEdit, (Object)selection));
                return;
            }
            try {
                final IEditorPart editorPart = IDE.openEditorOnFileStore((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFileStore)EFS.getStore((URI)file.toURI()));
                editorPart.addPropertyListener(new IPropertyListener(){

                    public void propertyChanged(Object source, int propId) {
                        if (257 == propId && !editorPart.isDirty()) {
                            XMLAnalysesManagerPreferencePage.loadXmlFile(file, false);
                        }
                    }
                });
                this.performOk();
            }
            catch (CoreException e) {
                Activator.logError(NLS.bind((String)Messages.ManageXMLAnalysisDialog_FailedToEdit, (Object)selection));
                TraceUtils.displayErrorMsg((String)NLS.bind((String)Messages.ManageXMLAnalysisDialog_FailedToEdit, (Object)selection), (String)e.getMessage());
            }
            ++n2;
        }
    }

    private void deleteAnalysis() {
        boolean confirm = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.ManageXMLAnalysisDialog_DeleteFile, (String)Messages.ManageXMLAnalysisDialog_DeleteConfirmation);
        if (confirm) {
            Set<IEditorReference> editorReferences = XMLAnalysesManagerPreferencePage.getEditorReferences();
            ArrayList<TmfCommonProjectElement> elements = new ArrayList<TmfCommonProjectElement>();
            TableItem[] tableItemArray = this.fAnalysesTable.getSelection();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                String itemTitle = XmlUtils.createXmlFileString((String)item.getText());
                editorReferences.forEach(editorReference -> {
                    if (editorReference.getTitle().equals(itemTitle)) {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(editorReference.getEditor(false), false);
                    }
                });
                if (XmlUtils.isAnalysisEnabled((String)itemTitle)) {
                    elements.addAll(XMLAnalysesManagerPreferencePage.deleteSupplementaryFile(itemTitle));
                }
                XmlUtils.deleteFile((String)itemTitle);
                ++n2;
            }
            this.fillAnalysesTable();
            this.fInvalidFileLabel.setVisible(false);
            XmlAnalysisModuleSource.notifyModuleChange();
            XMLAnalysesManagerPreferencePage.refreshProject(elements);
        }
    }

    private static List<TmfCommonProjectElement> deleteSupplementaryFile(String xmlFile) {
        IProject[] projects;
        ArrayList<TmfCommonProjectElement> toReopen = new ArrayList<TmfCommonProjectElement>();
        ArrayList<IResource> resourceToDelete = new ArrayList<IResource>();
        List ids = XmlUtils.getAnalysisIdsFromFile((String)xmlFile);
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects(0);
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            TmfProjectElement pElement = TmfProjectRegistry.getProject((IProject)project);
            if (pElement != null) {
                TmfExperimentFolder experimentsFolder;
                ArrayList tElements = new ArrayList();
                TmfTraceFolder tracesFolder = pElement.getTracesFolder();
                if (tracesFolder != null) {
                    tElements.addAll(tracesFolder.getTraces());
                }
                if ((experimentsFolder = pElement.getExperimentsFolder()) != null) {
                    tElements.addAll(experimentsFolder.getExperiments());
                }
                Set<IEditorReference> editorReferences = XMLAnalysesManagerPreferencePage.getEditorReferences();
                for (TmfCommonProjectElement tElement : tElements) {
                    IResource[] iResourceArray = tElement.getSupplementaryResources();
                    int n3 = iResourceArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IResource resource = iResourceArray[n4];
                        for (String id : ids) {
                            if (!resource.getName().startsWith(id)) continue;
                            resourceToDelete.add(resource);
                        }
                        ++n4;
                    }
                    IFile file = tElement.getBookmarksFile();
                    FileEditorInput input = new FileEditorInput(file);
                    boolean open = Iterables.any(editorReferences, editorReference -> {
                        try {
                            return editorReference.getEditorInput().equals(input);
                        }
                        catch (PartInitException e) {
                            Activator.logError("Failed to test the " + tElement.getName() + " editor", e);
                            return false;
                        }
                    });
                    if (open) {
                        toReopen.add(tElement);
                    }
                    tElement.closeEditors();
                }
            }
            ++n2;
        }
        for (IResource resource : resourceToDelete) {
            try {
                resource.delete(false, null);
            }
            catch (CoreException e) {
                Activator.logError(NLS.bind((String)Messages.ManageXMLAnalysisDialog_DeleteFileError, (Object)resource.getName()));
            }
        }
        return toReopen;
    }

    private static void refreshProject(List<TmfCommonProjectElement> elements) {
        TreeSelection sel;
        Object element;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart part = page.getActivePart();
        if (part == null) {
            return;
        }
        ISelectionProvider selectionProvider = part.getSite().getSelectionProvider();
        if (selectionProvider == null) {
            return;
        }
        ISelection selection = selectionProvider.getSelection();
        if (selection instanceof TreeSelection && (element = (sel = (TreeSelection)selection).getFirstElement()) instanceof TmfProjectModelElement) {
            ((TmfProjectModelElement)element).getProject().refresh();
        }
        elements.forEach(TmfOpenTraceHelper::openTraceFromElement);
    }

    private static boolean isFileValid(String xmlName) {
        Map files = XmlUtils.listFiles();
        File file = (File)files.get(xmlName);
        return file != null && XmlUtils.xmlValidate((File)file).isOK();
    }

    private static Set<IEditorReference> getEditorReferences() {
        HashSet<IEditorReference> editorReferences = new HashSet<IEditorReference>();
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = wb.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow wbWindow = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = wbWindow.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage wbPage = iWorkbenchPageArray[n4];
                editorReferences.addAll(Arrays.asList(wbPage.getEditorReferences()));
                ++n4;
            }
            ++n2;
        }
        return editorReferences;
    }
}

