/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphColorListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.ITmfTimeGraphDrawingHelper;

public interface ITimeGraphPresentationProvider {
    public static final int INVISIBLE = -1;
    public static final int TRANSPARENT = -2;

    public String getStateTypeName();

    public String getStateTypeName(ITimeGraphEntry var1);

    public StateItem[] getStateTable();

    public int getStateTableIndex(ITimeEvent var1);

    public void postDrawControl(Rectangle var1, GC var2);

    public void postDrawEntry(ITimeGraphEntry var1, Rectangle var2, GC var3);

    public void postDrawEvent(ITimeEvent var1, Rectangle var2, GC var3);

    public int getItemHeight(ITimeGraphEntry var1);

    public Image getItemImage(ITimeGraphEntry var1);

    public String getEventName(ITimeEvent var1);

    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent var1);

    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent var1, long var2);

    default public String getLinkTypeName() {
        return Messages.TimeGraphLegend_Arrows;
    }

    public boolean displayTimesInTooltip();

    default public Map<String, Object> getEventStyle(ITimeEvent event) {
        StateItem stateItem = null;
        int index = this.getStateTableIndex(event);
        StateItem[] stateTable = this.getStateTable();
        if (index >= 0 && index < stateTable.length) {
            stateItem = stateTable[index];
        }
        Map<String, Object> styleMap = stateItem == null ? Collections.EMPTY_MAP : stateItem.getStyleMap();
        Map<String, Object> specificEventStyles = this.getSpecificEventStyle(event);
        if (specificEventStyles.isEmpty()) {
            return styleMap;
        }
        if (styleMap.isEmpty()) {
            return specificEventStyles;
        }
        styleMap = new HashMap<String, Object>(styleMap);
        styleMap.putAll(specificEventStyles);
        return styleMap;
    }

    default public Map<String, Object> getSpecificEventStyle(ITimeEvent event) {
        return Collections.emptyMap();
    }

    default public void refresh() {
    }

    public ITmfTimeGraphDrawingHelper getDrawingHelper();

    public void setDrawingHelper(ITmfTimeGraphDrawingHelper var1);

    public void addColorListener(ITimeGraphColorListener var1);

    public void removeColorListener(ITimeGraphColorListener var1);

    default public @NonNull Map<String, String> getFilterInput(ITimeEvent event) {
        String state;
        HashMap<String, String> inputs = new HashMap<String, String>();
        ITimeGraphEntry entry = event.getEntry();
        String stateTypeName = this.getStateTypeName(entry);
        String entryName = entry.getName();
        if (stateTypeName == null) {
            stateTypeName = this.getStateTypeName();
        }
        if (!entryName.isEmpty()) {
            inputs.put(stateTypeName, entry.getName());
        }
        if ((state = this.getEventName(event)) != null) {
            inputs.put(Messages.TmfTimeTipHandler_TRACE_STATE, state);
        }
        return inputs;
    }
}

