/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.ui.views.flamechart;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callstack.provider.CallStackEntryModel;
import org.eclipse.tracecompass.internal.analysis.profiling.ui.views.flamechart.Messages;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.presentation.IPaletteProvider;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.core.presentation.RotatingPaletteProvider;
import org.eclipse.tracecompass.tmf.ui.colors.RGBAUtil;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NamedTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;

public class CallStackPresentationProvider
extends TimeGraphPresentationProvider {
    public static final int NUM_COLORS = 360;
    private static final StateItem[] STATE_TABLE = new StateItem[361];
    private @Nullable Integer fMinimumBarWidth;
    private IPaletteProvider fPalette = new RotatingPaletteProvider.Builder().setNbColors(360).build();

    static {
        CallStackPresentationProvider.STATE_TABLE[0] = new StateItem(State.MULTIPLE.rgb, State.MULTIPLE.toString());
    }

    public @Nullable String getStateTypeName(@Nullable ITimeGraphEntry entry) {
        ITimeGraphEntryModel model;
        if (entry instanceof TimeGraphEntry && (model = ((TimeGraphEntry)entry).getModel()) instanceof CallStackEntryModel) {
            int type = ((CallStackEntryModel)model).getStackLevel();
            if (type >= 0) {
                return Messages.CallStackPresentationProvider_Thread;
            }
            if (type == -1) {
                return Messages.CallStackPresentationProvider_Process;
            }
        }
        return null;
    }

    public StateItem[] getStateTable() {
        if (STATE_TABLE[1] == null) {
            int i = 1;
            String exec = State.EXEC.toString();
            for (RGBAColor color : this.fPalette.get()) {
                CallStackPresentationProvider.STATE_TABLE[i] = new StateItem(RGBAUtil.fromRGBAColor((RGBAColor)color).rgb, exec);
                ++i;
            }
        }
        return STATE_TABLE;
    }

    public int getStateTableIndex(@Nullable ITimeEvent event) {
        if (event instanceof NamedTimeEvent) {
            NamedTimeEvent callStackEvent = (NamedTimeEvent)event;
            return Math.floorMod(callStackEvent.getValue(), this.fPalette.get().size()) + 1;
        }
        if (event instanceof NullTimeEvent) {
            return -1;
        }
        return State.MULTIPLE.ordinal();
    }

    public String getEventName(@Nullable ITimeEvent event) {
        if (event instanceof NamedTimeEvent) {
            return ((NamedTimeEvent)event).getLabel();
        }
        return State.MULTIPLE.toString();
    }

    public void postDrawEvent(@Nullable ITimeEvent event, @Nullable Rectangle bounds, @Nullable GC gc) {
        if (gc == null || bounds == null || !(event instanceof NamedTimeEvent)) {
            return;
        }
        Integer minimumBarWidth = this.fMinimumBarWidth;
        if (minimumBarWidth == null) {
            this.fMinimumBarWidth = minimumBarWidth = Integer.valueOf(gc.getFontMetrics().getAverageCharWidth() + gc.stringExtent((String)"\u2026").x);
        }
        if (bounds.width <= minimumBarWidth) {
            return;
        }
        String label = ((NamedTimeEvent)event).getLabel();
        gc.setForeground(gc.getDevice().getSystemColor(1));
        Utils.drawText((GC)gc, (String)label, (int)bounds.x, (int)bounds.y, (int)bounds.width, (int)bounds.height, (boolean)true, (boolean)true);
    }

    private static enum State {
        MULTIPLE(new RGB(100, 100, 100)),
        EXEC(new RGB(0, 200, 0));

        private final RGB rgb;

        private State(RGB rgb) {
            this.rgb = rgb;
        }
    }
}

