/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.profiling.core.callgraph.ICallGraphProvider;
import org.eclipse.tracecompass.analysis.profiling.core.callstack.CallStackAnalysis;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.IAnalysisProgressListener;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.AbstractCalledFunction;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.AggregatedCalledFunction;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.CalledFunctionFactory;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.CalledStringFunction;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.ICalledFunction;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.Messages;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.ThreadNode;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callstack.SymbolAspect;
import org.eclipse.tracecompass.internal.analysis.timing.core.Activator;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.segmentstore.core.SegmentStoreFactory;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.segment.ISegmentAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class CallGraphAnalysis
extends TmfAbstractAnalysisModule
implements ISegmentStoreProvider,
ICallGraphProvider {
    public static final String ID = "org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.callgraphanalysis";
    private final ISegmentStore<@NonNull ISegment> fStore;
    private @Nullable ISegmentStore<@NonNull ISegment> fCompletedStore = null;
    private final ListenerList fListeners = new ListenerList(1);
    private final List<ICalledFunction> fRootFunctions = new ArrayList<ICalledFunction>();
    private List<Integer> fCurrentQuarks = Collections.emptyList();
    private List<ThreadNode> fThreadNodes = new ArrayList<ThreadNode>();
    private final @Nullable CallStackAnalysis fCallStackAnalysis;

    protected CallGraphAnalysis() {
        this.fStore = SegmentStoreFactory.createSegmentStore((SegmentStoreFactory.SegmentStoreType[])new SegmentStoreFactory.SegmentStoreType[]{SegmentStoreFactory.SegmentStoreType.Fast});
        this.fCallStackAnalysis = null;
    }

    public CallGraphAnalysis(CallStackAnalysis callStackAnalysis) {
        this.fStore = SegmentStoreFactory.createSegmentStore((SegmentStoreFactory.SegmentStoreType[])new SegmentStoreFactory.SegmentStoreType[]{SegmentStoreFactory.SegmentStoreType.Fast});
        this.fCallStackAnalysis = callStackAnalysis;
    }

    public @NonNull String getHelpText() {
        String msg = Messages.CallGraphAnalysis_Description;
        return msg != null ? msg : super.getHelpText();
    }

    public @NonNull String getHelpText(@NonNull ITmfTrace trace) {
        return this.getHelpText();
    }

    public boolean canExecute(ITmfTrace trace) {
        return true;
    }

    public @NonNull Iterable<@NonNull ISegmentAspect> getSegmentAspects() {
        return Collections.singletonList(SymbolAspect.SYMBOL_ASPECT);
    }

    protected Iterable<IAnalysisModule> getDependentAnalyses() {
        CallStackAnalysis callStackAnalysis = this.fCallStackAnalysis;
        if (callStackAnalysis == null) {
            throw new NullPointerException("If the analysis is not set, this method should not be called");
        }
        return Collections.singleton(callStackAnalysis);
    }

    protected boolean executeAnalysis(@Nullable IProgressMonitor monitor) {
        ITmfTrace trace = this.getTrace();
        if (monitor == null || trace == null) {
            return false;
        }
        CallStackAnalysis callstackModule = this.fCallStackAnalysis;
        if (callstackModule == null) {
            return false;
        }
        callstackModule.schedule();
        callstackModule.waitForCompletion(monitor);
        String[] threadsPattern = callstackModule.getThreadsPattern();
        String[] processesPattern = callstackModule.getProcessesPattern();
        String[] callStackPath = callstackModule.getCallStackPath();
        ITmfStateSystem ss = callstackModule.getStateSystem();
        if (ss == null || !this.iterateOverStateSystem(ss, threadsPattern, processesPattern, callStackPath, monitor)) {
            return false;
        }
        monitor.worked(1);
        monitor.done();
        return true;
    }

    @VisibleForTesting
    protected boolean iterateOverStateSystem(ITmfStateSystem ss, String[] threadsPattern, String[] processesPattern, String[] callStackPath, IProgressMonitor monitor) {
        List processQuarks = ss.getQuarks(processesPattern);
        Iterator iterator = processQuarks.iterator();
        while (iterator.hasNext()) {
            int processQuark = (Integer)iterator.next();
            int processId = CallGraphAnalysis.getProcessId(ss, processQuark, ss.getCurrentEndTime());
            Iterator iterator2 = ss.getQuarks(processQuark, threadsPattern).iterator();
            while (iterator2.hasNext()) {
                int threadQuark = (Integer)iterator2.next();
                if (this.iterateOverQuark(ss, processId, threadQuark, callStackPath, monitor)) continue;
                return false;
            }
        }
        this.fCompletedStore = this.fStore;
        this.sendUpdate(this.fStore);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean iterateOverQuark(ITmfStateSystem stateSystem, int processId, int threadQuark, String[] subAttributePath, IProgressMonitor monitor) {
        String threadName = stateSystem.getAttributeName(threadQuark);
        long threadId = CallGraphAnalysis.getProcessId(stateSystem, threadQuark, stateSystem.getStartTime());
        try {
            long curTime = stateSystem.getStartTime();
            long limit = stateSystem.getCurrentEndTime();
            CalledStringFunction initSegment = CalledFunctionFactory.create(0L, 0L, 0, threadName, processId, null);
            ThreadNode init = new ThreadNode(initSegment, 0, threadId);
            while (true) {
                if (curTime >= limit) {
                    this.fThreadNodes.add(init);
                    return true;
                }
                if (monitor.isCanceled()) {
                    return false;
                }
                int callStackQuark = stateSystem.optQuarkRelative(threadQuark, subAttributePath);
                if (callStackQuark == -2) {
                    return false;
                }
                this.fCurrentQuarks = stateSystem.getSubAttributes(callStackQuark, false);
                if (this.fCurrentQuarks.isEmpty()) {
                    return false;
                }
                boolean depth = false;
                int quarkParent = this.fCurrentQuarks.get(0);
                ITmfStateInterval interval = stateSystem.querySingleState(curTime, quarkParent);
                Object stateValue = interval.getValue();
                if (stateValue != null) {
                    long intervalStart = interval.getStartTime();
                    long intervalEnd = interval.getEndTime();
                    AbstractCalledFunction rootFunction = CalledFunctionFactory.create(intervalStart, intervalEnd + 1L, 0, stateValue, processId, null);
                    this.fRootFunctions.add(rootFunction);
                    AggregatedCalledFunction firstNode = new AggregatedCalledFunction(rootFunction, this.fCurrentQuarks.size());
                    if (!this.findChildren(rootFunction, 0, stateSystem, this.fCurrentQuarks.size() + this.fCurrentQuarks.get(0), firstNode, processId, monitor)) {
                        return false;
                    }
                    init.addChild(rootFunction, firstNode);
                }
                curTime = interval.getEndTime() + 1L;
            }
        }
        catch (StateSystemDisposedException | TimeRangeException e) {
            Activator.getInstance().logError(Messages.QueringStateSystemError, e);
            return false;
        }
    }

    private boolean findChildren(AbstractCalledFunction parentFunction, int depth, ITmfStateSystem ss, int maxQuark, AggregatedCalledFunction parent, int processId, IProgressMonitor monitor) {
        this.fStore.add((Object)parentFunction);
        long curTime = parentFunction.getStart();
        long limit = parentFunction.getEnd();
        ITmfStateInterval interval = null;
        while (curTime < limit) {
            block7: {
                if (monitor.isCanceled()) {
                    return false;
                }
                try {
                    if (depth + 1 < this.fCurrentQuarks.size()) {
                        interval = ss.querySingleState(curTime, this.fCurrentQuarks.get(depth + 1).intValue());
                        break block7;
                    }
                    return true;
                }
                catch (StateSystemDisposedException e) {
                    Activator.getInstance().logError(Messages.QueringStateSystemError, (Throwable)e);
                    return false;
                }
            }
            Object stateValue = interval.getValue();
            if (stateValue != null) {
                long intervalStart = interval.getStartTime();
                long intervalEnd = interval.getEndTime();
                if (intervalStart < parentFunction.getStart() || intervalEnd > limit) {
                    return true;
                }
                AbstractCalledFunction function = CalledFunctionFactory.create(intervalStart, intervalEnd + 1L, parentFunction.getDepth() + 1, stateValue, processId, (ICalledFunction)parentFunction);
                AggregatedCalledFunction childNode = new AggregatedCalledFunction(function, parent);
                this.findChildren(function, depth + 1, ss, maxQuark, childNode, processId, monitor);
                parentFunction.addChild(function);
                parent.addChild(function, childNode);
            }
            curTime = interval.getEndTime() + 1L;
        }
        return true;
    }

    public void addListener(@NonNull IAnalysisProgressListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeListener(@NonNull IAnalysisProgressListener listener) {
        this.fListeners.remove((Object)listener);
    }

    protected void canceling() {
    }

    public @Nullable ISegmentStore<@NonNull ISegment> getSegmentStore() {
        return this.fCompletedStore;
    }

    protected void sendUpdate(ISegmentStore<@NonNull ISegment> store) {
        this.getListeners().forEach(listener -> listener.onComplete((ISegmentStoreProvider)this, store));
    }

    protected Iterable<IAnalysisProgressListener> getListeners() {
        return Lists.newArrayList((Iterator)this.fListeners.iterator());
    }

    public List<ICalledFunction> getRootFunctions() {
        return ImmutableList.copyOf(this.fRootFunctions);
    }

    public Collection<ThreadNode> getFlameGraph() {
        CalledStringFunction initSegment = CalledFunctionFactory.create(0L, 0L, 0, "", 0, null);
        ThreadNode init = new ThreadNode(initSegment, 0, 0L);
        this.fThreadNodes.forEach(tn -> tn.getChildren().forEach(child -> init.addChild(initSegment, child.clone())));
        return Collections.singleton(init);
    }

    public List<ThreadNode> getThreadNodes() {
        return ImmutableList.copyOf(this.fThreadNodes);
    }

    private static int getProcessId(ITmfStateSystem ss, int processQuark, long curTime) {
        if (processQuark != -1) {
            try {
                ITmfStateInterval interval = ss.querySingleState(curTime, processQuark);
                String processName = ss.getAttributeName(processQuark);
                Object processValue = interval.getValue();
                if (processValue != null && (processValue instanceof Integer || processValue instanceof Long)) {
                    return ((Number)processValue).intValue();
                }
                return Integer.parseInt(processName);
            }
            catch (NumberFormatException | StateSystemDisposedException throwable) {
                // empty catch block
            }
        }
        return -1;
    }
}

