/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.util.ArrayUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntsRef
implements Comparable<IntsRef> {
    public int[] ints;
    public int offset;
    public int length;

    public IntsRef() {
    }

    public IntsRef(int capacity) {
        this.ints = new int[capacity];
    }

    public IntsRef(int[] ints, int offset, int length) {
        this.ints = ints;
        this.offset = offset;
        this.length = length;
    }

    public IntsRef(IntsRef other) {
        this.copy(other);
    }

    public Object clone() {
        return new IntsRef(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 0;
        int end = this.offset + this.length;
        for (int i = this.offset; i < end; ++i) {
            result = 31 * result + this.ints[i];
        }
        return result;
    }

    public boolean equals(Object other) {
        return this.intsEquals((IntsRef)other);
    }

    public boolean intsEquals(IntsRef other) {
        if (this.length == other.length) {
            int otherUpto = other.offset;
            int[] otherInts = other.ints;
            int end = this.offset + this.length;
            int upto = this.offset;
            while (upto < end) {
                if (this.ints[upto] != otherInts[otherUpto]) {
                    return false;
                }
                ++upto;
                ++otherUpto;
            }
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(IntsRef other) {
        if (this == other) {
            return 0;
        }
        int[] aInts = this.ints;
        int aUpto = this.offset;
        int[] bInts = other.ints;
        int bUpto = other.offset;
        int aStop = aUpto + Math.min(this.length, other.length);
        while (aUpto < aStop) {
            int bInt;
            int aInt;
            if ((aInt = aInts[aUpto++]) > (bInt = bInts[bUpto++])) {
                return 1;
            }
            if (aInt >= bInt) continue;
            return -1;
        }
        return this.length - other.length;
    }

    public void copy(IntsRef other) {
        this.ints = this.ints == null ? new int[other.length] : ArrayUtil.grow(this.ints, other.length);
        System.arraycopy(other.ints, other.offset, this.ints, 0, other.length);
        this.length = other.length;
        this.offset = 0;
    }

    public void grow(int newLength) {
        if (this.ints.length < newLength) {
            this.ints = ArrayUtil.grow(this.ints, newLength);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int end = this.offset + this.length;
        for (int i = this.offset; i < end; ++i) {
            if (i > this.offset) {
                sb.append(' ');
            }
            sb.append(Integer.toHexString(this.ints[i]));
        }
        sb.append(']');
        return sb.toString();
    }
}

