/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.build;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.build.CBuildConfiguration;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class StandardBuildConfiguration
extends CBuildConfiguration {
    private String[] buildCommand = new String[]{"make", "all"};
    private String[] cleanCommand = new String[]{"make", "clean"};
    private IContainer buildContainer;

    public StandardBuildConfiguration(IBuildConfiguration config, String name) throws CoreException {
        super(config, name);
    }

    public StandardBuildConfiguration(IBuildConfiguration config, String name, IToolChain toolChain, String launchMode) {
        super(config, name, toolChain);
    }

    public void setBuildContainer(IContainer buildContainer) {
        this.buildContainer = buildContainer;
    }

    public void setBuildCommand(String[] buildCommand) {
        this.buildCommand = buildCommand;
    }

    public void setCleanCommand(String[] cleanCommand) {
        this.cleanCommand = cleanCommand;
    }

    @Override
    public IContainer getBuildContainer() throws CoreException {
        return this.buildContainer != null ? this.buildContainer : this.getProject();
    }

    @Override
    public IProject[] build(int kind, Map<String, String> args, IConsole console, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        try {
            project.deleteMarkers("org.eclipse.cdt.core.problem", false, 2);
            ConsoleOutputStream outStream = console.getOutputStream();
            Path buildDir = this.getBuildDirectory();
            outStream.write(String.format("Building in: %s\n", buildDir.toString()));
            CharSequence[] command = new String[this.buildCommand.length];
            Path make = this.findCommand(this.buildCommand[0]);
            command[0] = make.toString();
            System.arraycopy(this.buildCommand, 1, command, 1, this.buildCommand.length - 1);
            Throwable throwable = null;
            Object var11_13 = null;
            try (ErrorParserManager epm = new ErrorParserManager(project, this.getBuildDirectoryURI(), (IMarkerGenerator)this, this.getToolChain().getErrorParserIds());){
                console.getOutputStream().write(String.format("%s\n", String.join((CharSequence)" ", command)));
                ProcessBuilder processBuilder = new ProcessBuilder((String[])command).directory(this.getBuildDirectory().toFile());
                this.setBuildEnvironment(processBuilder.environment());
                Process process = processBuilder.start();
                IConsoleParser[] consoleParsers = new IConsoleParser[]{epm, this};
                this.watchProcess(process, consoleParsers, console);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            project.refreshLocal(2, monitor);
            return new IProject[]{project};
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", "Building " + project.getName(), (Throwable)e));
        }
    }

    @Override
    public void clean(IConsole console, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        try {
            project.deleteMarkers("org.eclipse.cdt.core.problem", false, 2);
            ConsoleOutputStream outStream = console.getOutputStream();
            CharSequence[] command = new String[this.cleanCommand.length];
            Path make = this.findCommand(this.cleanCommand[0]);
            command[0] = make.toString();
            System.arraycopy(this.cleanCommand, 1, command, 1, this.cleanCommand.length - 1);
            outStream.write(String.format("%s\n", String.join((CharSequence)" ", command)));
            ProcessBuilder processBuilder = new ProcessBuilder((String[])command).directory(this.getBuildDirectory().toFile());
            this.setBuildEnvironment(processBuilder.environment());
            Process process = processBuilder.start();
            this.watchProcess(process, new IConsoleParser[0], console);
            project.refreshLocal(2, monitor);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", "Building " + project.getName(), (Throwable)e));
        }
    }
}

