/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.core.callstack;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.profiling.core.callgraph.ICallGraphProvider;
import org.eclipse.tracecompass.analysis.profiling.core.callstack.IFlameChartProvider;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.IAnalysisProgressListener;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.CallGraphAnalysis;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.segment.ISegmentAspect;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public abstract class CallStackAnalysis
extends TmfStateSystemAnalysisModule
implements IFlameChartProvider {
    private static final String[] DEFAULT_PROCESSES_PATTERN = new String[]{"Processes", "*"};
    private static final String[] DEFAULT_THREADS_PATTERN = new String[]{"*"};
    private static final String[] DEFAULT_CALL_STACK_PATH = new String[]{"CallStack"};
    private final CallGraphAnalysis fCallGraphAnalysis = new CallGraphAnalysis(this);

    protected CallStackAnalysis() {
    }

    public String[] getProcessesPattern() {
        return DEFAULT_PROCESSES_PATTERN;
    }

    public String[] getThreadsPattern() {
        return DEFAULT_THREADS_PATTERN;
    }

    public String[] getCallStackPath() {
        return DEFAULT_CALL_STACK_PATH;
    }

    protected boolean executeAnalysis(@Nullable IProgressMonitor monitor) {
        boolean result = super.executeAnalysis(monitor);
        if (!result) {
            return false;
        }
        this.fCallGraphAnalysis.schedule();
        return result;
    }

    public boolean setTrace(@NonNull ITmfTrace trace) throws TmfAnalysisException {
        boolean ret = super.setTrace(trace);
        if (!ret) {
            return ret;
        }
        ret = this.fCallGraphAnalysis.setTrace(trace);
        return ret;
    }

    public void dispose() {
        this.fCallGraphAnalysis.dispose();
        super.dispose();
    }

    public void addListener(IAnalysisProgressListener listener) {
        this.fCallGraphAnalysis.addListener(listener);
    }

    public void removeListener(IAnalysisProgressListener listener) {
        this.fCallGraphAnalysis.removeListener(listener);
    }

    public Iterable<ISegmentAspect> getSegmentAspects() {
        return this.fCallGraphAnalysis.getSegmentAspects();
    }

    public @Nullable ISegmentStore<ISegment> getSegmentStore() {
        return this.fCallGraphAnalysis.getSegmentStore();
    }

    public ICallGraphProvider getCallGraph() {
        return this.fCallGraphAnalysis;
    }
}

