/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.ui.bindings.internal.BindingTableManager;
import org.eclipse.e4.ui.bindings.internal.ContextSet;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.window.Window;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.quickaccess.ActionProvider;
import org.eclipse.ui.internal.quickaccess.CommandProvider;
import org.eclipse.ui.internal.quickaccess.EditorProvider;
import org.eclipse.ui.internal.quickaccess.PerspectiveProvider;
import org.eclipse.ui.internal.quickaccess.PreferenceProvider;
import org.eclipse.ui.internal.quickaccess.PreviousPicksProvider;
import org.eclipse.ui.internal.quickaccess.PropertiesProvider;
import org.eclipse.ui.internal.quickaccess.QuickAccessContents;
import org.eclipse.ui.internal.quickaccess.QuickAccessElement;
import org.eclipse.ui.internal.quickaccess.QuickAccessMessages;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;
import org.eclipse.ui.internal.quickaccess.ViewProvider;
import org.eclipse.ui.internal.quickaccess.WizardProvider;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.swt.IFocusService;

public class SearchField {
    private static final String QUICK_ACCESS_COMMAND_ID = "org.eclipse.ui.window.quickAccess";
    private static final String TEXT_ARRAY = "textArray";
    private static final String TEXT_ENTRIES = "textEntries";
    private static final String ORDERED_PROVIDERS = "orderedProviders";
    private static final String ORDERED_ELEMENTS = "orderedElements";
    private static final int MAXIMUM_NUMBER_OF_ELEMENTS = 60;
    private static final int MAXIMUM_NUMBER_OF_TEXT_ENTRIES_PER_ELEMENT = 3;
    private static final String DIALOG_HEIGHT = "dialogHeight";
    private static final String DIALOG_WIDTH = "dialogWidth";
    Shell shell;
    private Text txtQuickAccess;
    private QuickAccessContents quickAccessContents;
    private MWindow window;
    private Map<String, QuickAccessProvider> providerMap = new HashMap<String, QuickAccessProvider>();
    private Map<String, QuickAccessElement> elementMap = new HashMap<String, QuickAccessElement>();
    private Map<QuickAccessElement, ArrayList<String>> textMap = new HashMap<QuickAccessElement, ArrayList<String>>();
    private LinkedList<QuickAccessElement> previousPicksList = new LinkedList();
    private int dialogHeight = -1;
    private int dialogWidth = -1;
    private Control previousFocusControl;
    boolean activated = false;
    @Inject
    private EPartService partService;
    private Table table;
    private String selectedString = "";
    private AccessibleAdapter accessibleListener;
    @Inject
    private IBindingService bindingService;
    private TriggerSequence triggerSequence = null;
    @Inject
    private BindingTableManager manager;
    @Inject
    private ECommandService eCommandService;
    @Inject
    private IContextService contextService;

    @PostConstruct
    void createControls(Composite parent, MApplication application, MWindow window) {
        this.window = window;
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        this.txtQuickAccess = this.createText(comp);
        this.updateQuickAccessText();
        parent.getShell().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                this.closeDropDown();
            }

            public void controlMoved(ControlEvent e) {
                this.closeDropDown();
            }

            private void closeDropDown() {
                if (SearchField.this.shell == null || SearchField.this.shell.isDisposed() || SearchField.this.txtQuickAccess.isDisposed() || !SearchField.this.shell.isVisible()) {
                    return;
                }
                SearchField.this.quickAccessContents.doClose();
            }
        });
        this.hookUpSelectAll();
        final CommandProvider commandProvider = new CommandProvider();
        QuickAccessProvider[] providers = new QuickAccessProvider[]{new PreviousPicksProvider(this.previousPicksList), new EditorProvider(), new ViewProvider(application, window), new PerspectiveProvider(), commandProvider, new ActionProvider(), new WizardProvider(), new PreferenceProvider(), new PropertiesProvider()};
        int i = 0;
        while (i < providers.length) {
            this.providerMap.put(providers[i].getId(), providers[i]);
            ++i;
        }
        this.restoreDialog();
        this.quickAccessContents = new QuickAccessContents(providers){

            @Override
            protected void updateFeedback(boolean filterTextEmpty, boolean showAllMatches) {
            }

            @Override
            protected void doClose() {
                SearchField.this.txtQuickAccess.setText("");
                this.resetProviders();
                SearchField.this.dialogHeight = SearchField.this.shell.getSize().y;
                SearchField.this.dialogWidth = SearchField.this.shell.getSize().x;
                SearchField.this.shell.setVisible(false);
                SearchField.this.removeAccessibleListener();
            }

            @Override
            protected QuickAccessElement getPerfectMatch(String filter) {
                return (QuickAccessElement)SearchField.this.elementMap.get(filter);
            }

            @Override
            protected void handleElementSelected(String string, Object selectedElement) {
                if (selectedElement instanceof QuickAccessElement) {
                    MPart activePart;
                    QuickAccessElement element = (QuickAccessElement)selectedElement;
                    SearchField.this.addPreviousPick(string, element);
                    SearchField.this.txtQuickAccess.setText("");
                    element.execute();
                    if (SearchField.this.txtQuickAccess.isFocusControl() && (activePart = SearchField.this.partService.getActivePart()) != null) {
                        IPresentationEngine pe = (IPresentationEngine)activePart.getContext().get(IPresentationEngine.class);
                        pe.focusGui((MUIElement)activePart);
                    }
                }
            }
        };
        this.quickAccessContents.hookFilterText(this.txtQuickAccess);
        this.shell = new Shell(parent.getShell(), 16400);
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setText(QuickAccessMessages.QuickAccess_EnterSearch);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.shell);
        this.quickAccessContents.createHintText((Composite)this.shell, Window.getDefaultOrientation());
        this.table = this.quickAccessContents.createTable((Composite)this.shell, Window.getDefaultOrientation());
        this.txtQuickAccess.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                SearchField.this.showList();
            }
        });
        this.txtQuickAccess.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                SearchField.this.table.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SearchField.this.checkFocusLost(SearchField.this.table, SearchField.this.txtQuickAccess);
                    }
                });
                SearchField.this.activated = false;
            }

            public void focusGained(FocusEvent e) {
                IHandlerService hs = (IHandlerService)SearchField.this.window.getContext().get(IHandlerService.class);
                if (commandProvider.getContextSnapshot() == null) {
                    commandProvider.setSnapshot(hs.createContextSnapshot(true));
                }
                SearchField.this.previousFocusControl = (Control)e.getSource();
                SearchField.this.activated = true;
            }
        });
        this.table.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SearchField.this.table.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SearchField.this.checkFocusLost(SearchField.this.table, SearchField.this.txtQuickAccess);
                    }
                });
            }
        });
        this.txtQuickAccess.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SearchField.this.showList();
            }
        });
        this.txtQuickAccess.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    SearchField.this.activated = false;
                    SearchField.this.txtQuickAccess.setText("");
                    if (SearchField.this.txtQuickAccess == SearchField.this.previousFocusControl) {
                        SearchField.this.txtQuickAccess.getShell().forceFocus();
                    } else if (SearchField.this.previousFocusControl != null && !SearchField.this.previousFocusControl.isDisposed()) {
                        SearchField.this.previousFocusControl.setFocus();
                    }
                } else if (e.keyCode == 0x1000001) {
                    e.doit = false;
                } else if (e.keyCode == 0x1000002) {
                    e.doit = false;
                }
                if (!e.doit) {
                    SearchField.this.notifyAccessibleTextChanged();
                }
            }
        });
        this.quickAccessContents.createInfoLabel((Composite)this.shell);
    }

    @Inject
    @Optional
    protected void keybindingPreferencesChanged(@Preference(nodePath="org.eclipse.ui.workbench", value="org.eclipse.ui.commands") String preferenceValue) {
        if (preferenceValue != null) {
            this.updateQuickAccessText();
        }
    }

    private void showList() {
        boolean nowVisible;
        boolean wasVisible = this.shell.getVisible();
        boolean bl = nowVisible = this.txtQuickAccess.getText().length() > 0 || this.activated;
        if (!wasVisible && nowVisible) {
            this.layoutShell();
            this.addAccessibleListener();
            this.quickAccessContents.preOpen();
        }
        if (wasVisible && !nowVisible) {
            this.removeAccessibleListener();
        }
        if (nowVisible) {
            this.notifyAccessibleTextChanged();
        }
        this.shell.setVisible(nowVisible);
    }

    protected void updateQuickAccessTriggerSequence() {
        this.triggerSequence = this.bindingService.getBestActiveBindingFor(QUICK_ACCESS_COMMAND_ID);
        if (this.triggerSequence == null) {
            ParameterizedCommand cmd = this.eCommandService.createCommand(QUICK_ACCESS_COMMAND_ID, null);
            ContextSet contextSet = this.manager.createContextSet(Arrays.asList(this.contextService.getDefinedContexts()));
            Binding binding = this.manager.getBestSequenceFor(contextSet, cmd);
            this.triggerSequence = binding == null ? null : binding.getTriggerSequence();
        }
    }

    private Text createText(Composite parent) {
        Text text = new Text(parent, 128);
        text.setMessage(QuickAccessMessages.QuickAccess_EnterSearch);
        return text;
    }

    private void updateQuickAccessText() {
        if (this.txtQuickAccess == null || this.txtQuickAccess.isDisposed()) {
            return;
        }
        this.updateQuickAccessTriggerSequence();
        if (this.triggerSequence != null) {
            this.txtQuickAccess.setToolTipText(NLS.bind((String)QuickAccessMessages.QuickAccess_TooltipDescription, (Object)this.triggerSequence.format()));
        } else {
            this.txtQuickAccess.setToolTipText(QuickAccessMessages.QuickAccess_TooltipDescription_Empty);
        }
        GC gc = new GC((Drawable)this.txtQuickAccess);
        if (Util.isWin32() || Util.isGtk()) {
            FontMetrics fm = gc.getFontMetrics();
            int wHint = QuickAccessMessages.QuickAccess_EnterSearch.length() * fm.getAverageCharWidth();
            int hHint = fm.getHeight();
            gc.dispose();
            this.txtQuickAccess.setSize(this.txtQuickAccess.computeSize(wHint, hHint));
        } else {
            Point p = gc.textExtent(QuickAccessMessages.QuickAccess_EnterSearch);
            Rectangle r = this.txtQuickAccess.computeTrim(0, 0, p.x, p.y);
            gc.dispose();
            GridDataFactory.fillDefaults().hint(r.width - r.x, -1).applyTo((Control)this.txtQuickAccess);
        }
        this.txtQuickAccess.requestLayout();
    }

    private void hookUpSelectAll() {
        IEclipseContext windowContext = this.window.getContext();
        IFocusService focus = (IFocusService)windowContext.get(IFocusService.class);
        focus.addFocusTracker((Control)this.txtQuickAccess, SearchField.class.getName());
        Expression focusExpr = new Expression(){

            public void collectExpressionInfo(ExpressionInfo info) {
                info.addVariableNameAccess("activeFocusControlId");
            }

            public EvaluationResult evaluate(IEvaluationContext context) {
                return EvaluationResult.valueOf((boolean)SearchField.class.getName().equals(context.getVariable("activeFocusControlId")));
            }
        };
        IHandlerService whService = (IHandlerService)windowContext.get(IHandlerService.class);
        whService.activateHandler("org.eclipse.ui.edit.selectAll", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) {
                SearchField.this.txtQuickAccess.selectAll();
                return null;
            }
        }, focusExpr);
        whService.activateHandler("org.eclipse.ui.edit.cut", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) {
                SearchField.this.txtQuickAccess.cut();
                return null;
            }
        }, focusExpr);
        whService.activateHandler("org.eclipse.ui.edit.copy", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) {
                SearchField.this.txtQuickAccess.copy();
                return null;
            }
        }, focusExpr);
        whService.activateHandler("org.eclipse.ui.edit.paste", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) {
                SearchField.this.txtQuickAccess.paste();
                return null;
            }
        }, focusExpr);
    }

    private static Monitor getClosestMonitor(Display toSearch, Point toFind) {
        int closest = Integer.MAX_VALUE;
        Monitor[] monitors = toSearch.getMonitors();
        Monitor result = monitors[0];
        int idx = 0;
        while (idx < monitors.length) {
            Monitor current = monitors[idx];
            Rectangle clientArea = current.getClientArea();
            if (clientArea.contains(toFind)) {
                return current;
            }
            int distance = Geometry.distanceSquared((Point)Geometry.centerPoint((Rectangle)clientArea), (Point)toFind);
            if (distance < closest) {
                closest = distance;
                result = current;
            }
            ++idx;
        }
        return result;
    }

    private Rectangle getConstrainedShellBounds(Display display, Rectangle preferredSize) {
        Rectangle result = new Rectangle(preferredSize.x, preferredSize.y, preferredSize.width, preferredSize.height);
        Point topLeft = new Point(preferredSize.x, preferredSize.y);
        Monitor mon = SearchField.getClosestMonitor(display, topLeft);
        Rectangle bounds = mon.getClientArea();
        if (result.height > bounds.height) {
            result.height = bounds.height;
        }
        if (result.width > bounds.width) {
            result.width = bounds.width;
        }
        result.x = Math.max(bounds.x, Math.min(result.x, bounds.x + bounds.width - result.width));
        result.y = Math.max(bounds.y, Math.min(result.y, bounds.y + bounds.height - result.height));
        return result;
    }

    void layoutShell() {
        Display display = this.txtQuickAccess.getDisplay();
        Rectangle tempBounds = this.txtQuickAccess.getBounds();
        Rectangle compBounds = display.map((Control)this.txtQuickAccess, null, tempBounds);
        int preferredWidth = this.dialogWidth == -1 ? 350 : this.dialogWidth;
        int width = Math.max(preferredWidth, compBounds.width);
        int height = this.dialogHeight == -1 ? 250 : this.dialogHeight;
        Rectangle shellBounds = this.txtQuickAccess.getShell().getBounds();
        if (compBounds.x + width > shellBounds.x + shellBounds.width) {
            compBounds.x = Math.max(shellBounds.x, compBounds.x + compBounds.width - width);
        }
        this.shell.setBounds(this.getConstrainedShellBounds(display, new Rectangle(compBounds.x, compBounds.y + compBounds.height, width, height)));
        this.shell.layout();
    }

    public void activate(Control previousFocusControl) {
        this.previousFocusControl = previousFocusControl;
        if (!this.shell.isVisible()) {
            this.layoutShell();
            this.quickAccessContents.preOpen();
            this.shell.setVisible(true);
            this.addAccessibleListener();
            this.quickAccessContents.refresh(this.txtQuickAccess.getText().toLowerCase());
        } else {
            this.quickAccessContents.setShowAllMatches(!this.quickAccessContents.getShowAllMatches());
        }
    }

    protected void checkFocusLost(Table table, Text text) {
        if (!(this.shell.isDisposed() || table.isDisposed() || text.isDisposed())) {
            if (table.getDisplay().getActiveShell() == table.getShell()) {
                text.setFocus();
                return;
            }
            if (!(this.shell.isFocusControl() || table.isFocusControl() || text.isFocusControl())) {
                this.quickAccessContents.doClose();
            }
        }
    }

    private void addAccessibleListener() {
        if (this.accessibleListener == null) {
            this.accessibleListener = new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = SearchField.this.selectedString;
                }
            };
            this.txtQuickAccess.getAccessible().addAccessibleListener((AccessibleListener)this.accessibleListener);
        }
    }

    private void removeAccessibleListener() {
        if (this.accessibleListener != null) {
            this.txtQuickAccess.getAccessible().removeAccessibleListener((AccessibleListener)this.accessibleListener);
            this.accessibleListener = null;
        }
        this.selectedString = "";
    }

    private void notifyAccessibleTextChanged() {
        if (this.table.getSelection().length == 0) {
            return;
        }
        TableItem item = this.table.getSelection()[0];
        this.selectedString = NLS.bind((String)QuickAccessMessages.QuickAccess_SelectedString, (Object)item.getText(0), (Object)item.getText(1));
        this.txtQuickAccess.getAccessible().sendEvent(32780, null);
    }

    private void restoreDialog() {
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null) {
            String[] orderedElements = dialogSettings.getArray(ORDERED_ELEMENTS);
            String[] orderedProviders = dialogSettings.getArray(ORDERED_PROVIDERS);
            String[] textEntries = dialogSettings.getArray(TEXT_ENTRIES);
            String[] textArray = dialogSettings.getArray(TEXT_ARRAY);
            try {
                this.dialogHeight = dialogSettings.getInt(DIALOG_HEIGHT);
                this.dialogWidth = dialogSettings.getInt(DIALOG_WIDTH);
            }
            catch (NumberFormatException numberFormatException) {
                this.dialogHeight = -1;
                this.dialogWidth = -1;
            }
            if (orderedElements != null && orderedProviders != null && textEntries != null && textArray != null) {
                int arrayIndex = 0;
                int i = 0;
                while (i < orderedElements.length) {
                    QuickAccessElement quickAccessElement;
                    QuickAccessProvider quickAccessProvider = this.providerMap.get(orderedProviders[i]);
                    int numTexts = Integer.parseInt(textEntries[i]);
                    if (quickAccessProvider != null && (quickAccessElement = quickAccessProvider.getElementForId(orderedElements[i])) != null) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        int j = arrayIndex;
                        while (j < arrayIndex + numTexts) {
                            String text = textArray[j];
                            if (text.length() > 0) {
                                arrayList.add(text);
                                this.elementMap.put(text, quickAccessElement);
                            }
                            ++j;
                        }
                        this.textMap.put(quickAccessElement, arrayList);
                        this.previousPicksList.add(quickAccessElement);
                    }
                    arrayIndex += numTexts;
                    ++i;
                }
            }
        }
    }

    @PreDestroy
    void dispose() {
        this.storeDialog();
    }

    private void storeDialog() {
        String[] orderedElements = new String[this.previousPicksList.size()];
        String[] orderedProviders = new String[this.previousPicksList.size()];
        String[] textEntries = new String[this.previousPicksList.size()];
        ArrayList<String> arrayList = new ArrayList<String>();
        int i = 0;
        while (i < orderedElements.length) {
            QuickAccessElement quickAccessElement = this.previousPicksList.get(i);
            ArrayList<String> elementText = this.textMap.get(quickAccessElement);
            Assert.isNotNull(elementText);
            orderedElements[i] = quickAccessElement.getId();
            orderedProviders[i] = quickAccessElement.getProvider().getId();
            arrayList.addAll(elementText);
            textEntries[i] = String.valueOf(elementText.size());
            ++i;
        }
        String[] textArray = arrayList.toArray(new String[arrayList.size()]);
        IDialogSettings dialogSettings = this.getDialogSettings();
        dialogSettings.put(ORDERED_ELEMENTS, orderedElements);
        dialogSettings.put(ORDERED_PROVIDERS, orderedProviders);
        dialogSettings.put(TEXT_ENTRIES, textEntries);
        dialogSettings.put(TEXT_ARRAY, textArray);
        dialogSettings.put(DIALOG_HEIGHT, this.dialogHeight);
        dialogSettings.put(DIALOG_WIDTH, this.dialogWidth);
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings workbenchDialogSettings = WorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings result = workbenchDialogSettings.getSection(this.getId());
        if (result == null) {
            result = workbenchDialogSettings.addNewSection(this.getId());
        }
        return result;
    }

    private String getId() {
        return "org.eclipse.ui.internal.QuickAccess";
    }

    private void addPreviousPick(String text, QuickAccessElement element) {
        this.previousPicksList.remove(element);
        if (this.previousPicksList.size() == 60) {
            QuickAccessElement removedElement = this.previousPicksList.removeLast();
            ArrayList<String> removedList = this.textMap.remove(removedElement);
            int i = 0;
            while (i < removedList.size()) {
                this.elementMap.remove(removedList.get(i));
                ++i;
            }
        }
        this.previousPicksList.addFirst(element);
        ArrayList<String> textList = this.textMap.get(element);
        if (textList == null) {
            textList = new ArrayList();
            this.textMap.put(element, textList);
        }
        textList.remove(text);
        if (textList.size() == 3) {
            String removedText = textList.remove(0);
            this.elementMap.remove(removedText);
        }
        if (text.length() > 0) {
            textList.add(text);
            QuickAccessElement replacedElement = this.elementMap.put(text, element);
            if (replacedElement != null && !replacedElement.equals(element) && (textList = this.textMap.get(replacedElement)) != null) {
                textList.remove(text);
                if (textList.isEmpty()) {
                    this.textMap.remove(replacedElement);
                    this.previousPicksList.remove(replacedElement);
                }
            }
        }
    }

    public Shell getQuickAccessShell() {
        return this.shell;
    }

    public Text getQuickAccessSearchText() {
        return this.txtQuickAccess;
    }

    public Table getQuickAccessTable() {
        return this.table;
    }
}

