/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;
import org.eclipse.team.internal.ui.synchronize.RemoteResourceTypedElement;
import org.eclipse.team.internal.ui.synchronize.SynchronizeModelElement;

public class SyncInfoModelElement
extends SynchronizeModelElement {
    private ITypedElement ancestor;
    private SyncInfo info;

    public SyncInfoModelElement(IDiffContainer parent, SyncInfo info) {
        super(parent);
        Assert.isNotNull((Object)info);
        this.info = info;
        this.setKind(info.getKind());
        this.setLeft(SyncInfoModelElement.createLocalTypeElement(info));
        this.setRight(SyncInfoModelElement.createRemoteTypeElement(info));
        this.setAncestor(SyncInfoModelElement.createBaseTypeElement(info));
        this.fireChange();
    }

    public void update(SyncInfo info) {
        this.info = info;
        this.setKind(info.getKind());
        RemoteResourceTypedElement rightEl = (RemoteResourceTypedElement)this.getRight();
        IResourceVariant remote = info.getRemote();
        if (rightEl == null && remote != null) {
            this.setRight(SyncInfoModelElement.createRemoteTypeElement(info));
        } else if (rightEl != null) {
            if (remote == null) {
                this.setRight(null);
            } else {
                this.setRight(SyncInfoModelElement.createRemoteTypeElement(info));
            }
        }
        RemoteResourceTypedElement ancestorEl = (RemoteResourceTypedElement)this.getAncestor();
        IResourceVariant base = info.getBase();
        if (ancestorEl == null && base != null) {
            this.setAncestor(SyncInfoModelElement.createBaseTypeElement(info));
        } else if (ancestorEl != null) {
            if (base == null) {
                this.setAncestor(null);
            } else {
                this.setAncestor(SyncInfoModelElement.createBaseTypeElement(info));
            }
        }
        this.fireChange();
    }

    public int getKind() {
        SyncInfo info = this.getSyncInfo();
        if (info != null) {
            return info.getKind();
        }
        return 0;
    }

    public void setAncestor(ITypedElement ancestor) {
        this.ancestor = ancestor;
    }

    public ITypedElement getAncestor() {
        return this.ancestor;
    }

    public String getName() {
        IResource resource = this.getResource();
        if (resource != null) {
            return resource.getName();
        }
        return super.getName();
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == SyncInfo.class) {
            return this.getSyncInfo();
        }
        return super.getAdapter(adapter);
    }

    @Override
    public IResource getResource() {
        return this.info.getLocal();
    }

    public String toString() {
        return this.getResource().getFullPath().toString();
    }

    public void cacheContents(IProgressMonitor monitor) throws TeamException {
        ITypedElement base = this.getAncestor();
        ITypedElement remote = this.getRight();
        int work = Math.min((remote == null ? 0 : 50) + (base == null ? 0 : 50), 10);
        monitor.beginTask(null, work);
        try {
            try {
                if (base != null && base instanceof RemoteResourceTypedElement) {
                    ((RemoteResourceTypedElement)base).cacheContents(Policy.subMonitorFor(monitor, 50));
                }
                if (remote != null && remote instanceof RemoteResourceTypedElement) {
                    ((RemoteResourceTypedElement)remote).cacheContents(Policy.subMonitorFor(monitor, 50));
                }
            }
            catch (CoreException e) {
                throw TeamException.asTeamException((CoreException)e);
            }
        }
        finally {
            monitor.done();
        }
    }

    public SyncInfo getSyncInfo() {
        return this.info;
    }

    private static ITypedElement createTypeElement(IResource resource, int kind) {
        if (resource != null) {
            return new LocalResourceTypedElement(resource);
        }
        return null;
    }

    protected static ITypedElement createTypeElement(IResourceVariant remoteResource, String encoding) {
        return new RemoteResourceTypedElement(remoteResource, encoding);
    }

    protected static ITypedElement createRemoteTypeElement(SyncInfo info) {
        if (info != null && info.getRemote() != null) {
            return SyncInfoModelElement.createTypeElement(info.getRemote(), SyncInfoModelElement.getEncoding(info.getLocal()));
        }
        return null;
    }

    private static String getEncoding(IResource local) {
        if (local instanceof IEncodedStorage) {
            IEncodedStorage es = (IEncodedStorage)local;
            try {
                return es.getCharset();
            }
            catch (CoreException e) {
                TeamUIPlugin.log(e);
            }
        }
        return null;
    }

    protected static ITypedElement createLocalTypeElement(SyncInfo info) {
        if (info != null && info.getLocal() != null) {
            return SyncInfoModelElement.createTypeElement(info.getLocal(), info.getKind());
        }
        return null;
    }

    protected static ITypedElement createBaseTypeElement(SyncInfo info) {
        if (info != null && info.getBase() != null) {
            return SyncInfoModelElement.createTypeElement(info.getBase(), SyncInfoModelElement.getEncoding(info.getLocal()));
        }
        return null;
    }
}

