/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl;

import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.ctf.core.event.metadata.DeclarationScope;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.VariantDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.AbstractScopedCommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypeAliasAliasParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypeAliasTargetParser;

public final class TypeAliasParser
extends AbstractScopedCommonTreeParser {
    public static final TypeAliasParser INSTANCE = new TypeAliasParser();

    private TypeAliasParser() {
    }

    @Override
    public IDeclaration parse(CommonTree typealias, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        if (!(param instanceof Param)) {
            throw new IllegalArgumentException("Param must be a " + Param.class.getCanonicalName());
        }
        DeclarationScope scope = ((Param)param).fDeclarationScope;
        List children = typealias.getChildren();
        CommonTree target = null;
        CommonTree alias = null;
        for (CommonTree child : children) {
            switch (child.getType()) {
                case 113: {
                    target = child;
                    break;
                }
                case 112: {
                    alias = child;
                    break;
                }
                default: {
                    throw TsdlUtils.childTypeError(child);
                }
            }
        }
        CTFTrace trace = ((Param)param).fTrace;
        IDeclaration targetDeclaration = TypeAliasTargetParser.INSTANCE.parse(target, new TypeAliasTargetParser.Param(trace, scope));
        if (targetDeclaration instanceof VariantDeclaration && ((VariantDeclaration)targetDeclaration).isTagged()) {
            throw new ParseException("Typealias of untagged variant is not permitted");
        }
        String aliasString = TypeAliasAliasParser.INSTANCE.parse(alias, null);
        scope.registerType(aliasString, targetDeclaration);
        return targetDeclaration;
    }

    @NonNullByDefault
    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final DeclarationScope fDeclarationScope;
        private final CTFTrace fTrace;

        public Param(CTFTrace trace, DeclarationScope scope) {
            this.fTrace = trace;
            this.fDeclarationScope = scope;
        }
    }
}

