/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitDestructorName;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICPPASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.DestructorCallCollector;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalID;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.FunctionSetType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class CPPASTIdExpression
extends ASTNode
implements IASTIdExpression,
ICPPASTExpression,
ICPPASTCompletionContext {
    private IASTName fName;
    private ICPPEvaluation fEvaluation;
    private IASTImplicitDestructorName[] fImplicitDestructorNames;

    public CPPASTIdExpression() {
    }

    public CPPASTIdExpression(IASTName name) {
        this.setName(name);
    }

    @Override
    public CPPASTIdExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTIdExpression copy(IASTNode.CopyStyle style) {
        CPPASTIdExpression copy = new CPPASTIdExpression(this.fName == null ? null : this.fName.copy(style));
        return this.copy(copy, style);
    }

    @Override
    public IASTName getName() {
        return this.fName;
    }

    @Override
    public void setName(IASTName name) {
        this.assertNotFrozen();
        this.fName = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(ID_NAME);
        }
    }

    @Override
    public IASTImplicitDestructorName[] getImplicitDestructorNames() {
        if (this.fImplicitDestructorNames == null) {
            this.fImplicitDestructorNames = DestructorCallCollector.getTemporariesDestructorCalls(this);
        }
        return this.fImplicitDestructorNames;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.fName != null && !this.fName.accept(action)) {
            return false;
        }
        if (action.shouldVisitImplicitDestructorNames && !CPPASTIdExpression.acceptByNodes((IASTNode[])this.getImplicitDestructorNames(), (ASTVisitor)action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public int getRoleForName(IASTName n) {
        if (this.fName == n) {
            return 1;
        }
        return 3;
    }

    @Override
    public IBinding[] findBindings(IASTName n, boolean isPrefix, String[] namespaces) {
        return CPPSemantics.findBindingsForContentAssist(n, isPrefix, namespaces);
    }

    public String toString() {
        return this.fName != null ? this.fName.toString() : "<unnamed>";
    }

    @Override
    public IBinding[] findBindings(IASTName n, boolean isPrefix) {
        return this.findBindings(n, isPrefix, null);
    }

    @Override
    public ICPPEvaluation getEvaluation() {
        if (this.fEvaluation == null) {
            this.fEvaluation = EvalID.create(this);
        }
        return this.fEvaluation;
    }

    @Override
    public IType getExpressionType() {
        IType type = this.getEvaluation().getType(this);
        if (type instanceof FunctionSetType) {
            IBinding binding = this.fName.resolveBinding();
            if (binding instanceof IFunction) {
                return SemanticUtil.mapToAST(((IFunction)binding).getType(), (IASTNode)this);
            }
            return ProblemType.UNKNOWN_FOR_EXPRESSION;
        }
        return type;
    }

    @Override
    public boolean isLValue() {
        return this.getValueCategory() == IASTExpression.ValueCategory.LVALUE;
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return this.getEvaluation().getValueCategory(this);
    }
}

