/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.BidiUtils;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.dialogs.WizardResourceImportPage;
import org.eclipse.ui.ide.dialogs.IElementFilter;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.RelativePathVariableGroup;
import org.eclipse.ui.internal.ide.filesystem.FileSystemStructureProvider;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.MinimizedFileSystemElement;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class WizardFileSystemResourceImportPage1
extends WizardResourceImportPage
implements Listener {
    protected Combo sourceNameField;
    protected Button overwriteExistingResourcesCheckbox;
    protected Button createTopLevelFolderCheckbox;
    protected Button createVirtualFoldersButton;
    protected Button createLinksInWorkspaceButton;
    protected Button advancedButton;
    protected RelativePathVariableGroup relativePathVariableGroup;
    protected String pathVariable;
    protected Button sourceBrowseButton;
    protected Button selectTypesButton;
    protected Button selectAllButton;
    protected Button deselectAllButton;
    private boolean entryChanged = false;
    private FileSystemStructureProvider fileSystemStructureProvider = new FileSystemStructureProvider();
    private static final String STORE_SOURCE_NAMES_ID = "WizardFileSystemResourceImportPage1.STORE_SOURCE_NAMES_ID";
    private static final String STORE_OVERWRITE_EXISTING_RESOURCES_ID = "WizardFileSystemResourceImportPage1.STORE_OVERWRITE_EXISTING_RESOURCES_ID";
    private static final String STORE_CREATE_CONTAINER_STRUCTURE_ID = "WizardFileSystemResourceImportPage1.STORE_CREATE_CONTAINER_STRUCTURE_ID";
    private static final String STORE_CREATE_VIRTUAL_FOLDERS_ID = "WizardFileSystemResourceImportPage1.STORE_CREATE_VIRTUAL_FOLDERS_ID";
    private static final String STORE_CREATE_LINKS_IN_WORKSPACE_ID = "WizardFileSystemResourceImportPage1.STORE_CREATE_LINKS_IN_WORKSPACE_ID";
    private static final String STORE_PATH_VARIABLE_SELECTED_ID = "WizardFileSystemResourceImportPage1.STORE_PATH_VARIABLE_SELECTED_ID";
    private static final String STORE_PATH_VARIABLE_NAME_ID = "WizardFileSystemResourceImportPage1.STORE_PATH_VARIABLE_NAME_ID";
    private static final String SELECT_TYPES_TITLE = DataTransferMessages.DataTransfer_selectTypes;
    private static final String SELECT_ALL_TITLE = DataTransferMessages.DataTransfer_selectAll;
    private static final String DESELECT_ALL_TITLE = DataTransferMessages.DataTransfer_deselectAll;
    private static final String SELECT_SOURCE_TITLE = DataTransferMessages.FileImport_selectSourceTitle;
    private static final String SELECT_SOURCE_MESSAGE = DataTransferMessages.FileImport_selectSource;
    protected static final String SOURCE_EMPTY_MESSAGE = DataTransferMessages.FileImport_sourceEmpty;
    private Composite linkedResourceComposite;
    private int linkedResourceGroupHeight = -1;
    private Composite linkedResourceParent;

    protected WizardFileSystemResourceImportPage1(String name, IWorkbench aWorkbench, IStructuredSelection selection) {
        super(name, selection);
    }

    public WizardFileSystemResourceImportPage1(IWorkbench aWorkbench, IStructuredSelection selection) {
        this("fileSystemImportPage1", aWorkbench, selection);
        this.setTitle(DataTransferMessages.DataTransfer_fileSystemTitle);
        this.setDescription(DataTransferMessages.FileImport_importFileSystem);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        GridData buttonData = new GridData(768);
        button.setLayoutData((Object)buttonData);
        button.setData((Object)id);
        button.setText(label);
        if (defaultButton) {
            Shell shell = parent.getShell();
            if (shell != null) {
                shell.setDefaultButton(button);
            }
            button.setFocus();
        }
        return button;
    }

    protected final void createButtonsGroup(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setFont(parent.getFont());
        GridData buttonData = new GridData(4, 4, true, false);
        buttonComposite.setLayoutData((Object)buttonData);
        this.selectTypesButton = this.createButton(buttonComposite, 20, SELECT_TYPES_TITLE, false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardFileSystemResourceImportPage1.this.handleTypesEditButtonPressed();
            }
        };
        this.selectTypesButton.addSelectionListener((SelectionListener)listener);
        this.setButtonLayoutData(this.selectTypesButton);
        this.selectAllButton = this.createButton(buttonComposite, 18, SELECT_ALL_TITLE, false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardFileSystemResourceImportPage1.this.setAllSelections(true);
                WizardFileSystemResourceImportPage1.this.updateWidgetEnablements();
            }
        };
        this.selectAllButton.addSelectionListener((SelectionListener)listener);
        this.setButtonLayoutData(this.selectAllButton);
        this.deselectAllButton = this.createButton(buttonComposite, 19, DESELECT_ALL_TITLE, false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardFileSystemResourceImportPage1.this.setAllSelections(false);
                WizardFileSystemResourceImportPage1.this.updateWidgetEnablements();
            }
        };
        this.deselectAllButton.addSelectionListener((SelectionListener)listener);
        this.setButtonLayoutData(this.deselectAllButton);
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        this.validateSourceGroup();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.file_system_import_wizard_page");
    }

    @Override
    protected void createOptionsGroupButtons(Group optionsGroup) {
        this.overwriteExistingResourcesCheckbox = new Button((Composite)optionsGroup, 32);
        this.overwriteExistingResourcesCheckbox.setFont(optionsGroup.getFont());
        this.overwriteExistingResourcesCheckbox.setText(DataTransferMessages.FileImport_overwriteExisting);
        this.createTopLevelFolderCheckbox = new Button((Composite)optionsGroup, 32);
        this.createTopLevelFolderCheckbox.setFont(optionsGroup.getFont());
        this.createTopLevelFolderCheckbox.setText(DataTransferMessages.FileImport_createTopLevel);
        this.createTopLevelFolderCheckbox.setSelection(false);
        this.createTopLevelFolderCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardFileSystemResourceImportPage1.this.updateWidgetEnablements();
            }
        });
        this.linkedResourceParent = optionsGroup;
        if (!ResourcesPlugin.getPlugin().getPluginPreferences().getBoolean("description.disableLinking")) {
            this.advancedButton = new Button((Composite)optionsGroup, 8);
            this.advancedButton.setFont(optionsGroup.getFont());
            this.advancedButton.setText(IDEWorkbenchMessages.showAdvanced);
            GridData data = this.setButtonLayoutData(this.advancedButton);
            data.horizontalAlignment = 1;
            this.advancedButton.setLayoutData((Object)data);
            this.advancedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WizardFileSystemResourceImportPage1.this.handleAdvancedButtonSelect();
                }
            });
        }
        this.updateWidgetEnablements();
    }

    private Composite createAdvancedSection(Composite parent) {
        Composite linkedResourceComposite = new Composite(parent, 0);
        linkedResourceComposite.setFont(parent.getFont());
        linkedResourceComposite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        linkedResourceComposite.setLayout((Layout)layout);
        this.createLinksInWorkspaceButton = new Button(linkedResourceComposite, 32);
        this.createLinksInWorkspaceButton.setFont(parent.getFont());
        this.createLinksInWorkspaceButton.setText(DataTransferMessages.FileImport_createLinksInWorkspace);
        this.createLinksInWorkspaceButton.setSelection(false);
        this.createLinksInWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardFileSystemResourceImportPage1.this.updateWidgetEnablements();
            }
        });
        Button tmp = new Button(linkedResourceComposite, 32);
        int indent = tmp.computeSize((int)-1, (int)-1).x;
        tmp.dispose();
        this.createVirtualFoldersButton = new Button(linkedResourceComposite, 32);
        this.createVirtualFoldersButton.setFont(parent.getFont());
        this.createVirtualFoldersButton.setText(DataTransferMessages.FileImport_createVirtualFolders);
        this.createVirtualFoldersButton.setToolTipText(DataTransferMessages.FileImport_createVirtualFoldersTooltip);
        this.createVirtualFoldersButton.setSelection(false);
        this.createVirtualFoldersButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardFileSystemResourceImportPage1.this.updateWidgetEnablements();
            }
        });
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = indent;
        this.createVirtualFoldersButton.setLayoutData((Object)gridData);
        Composite relativeGroup = new Composite(linkedResourceComposite, 0);
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalIndent = indent;
        relativeGroup.setFont(parent.getFont());
        relativeGroup.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        relativeGroup.setLayout((Layout)layout);
        this.relativePathVariableGroup = new RelativePathVariableGroup(new RelativePathVariableGroup.IModel(){

            @Override
            public IResource getResource() {
                IPath path = WizardFileSystemResourceImportPage1.this.getContainerFullPath();
                if (path != null) {
                    return ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                }
                return null;
            }

            @Override
            public void setVariable(String string) {
                WizardFileSystemResourceImportPage1.this.pathVariable = string;
            }

            @Override
            public String getVariable() {
                return WizardFileSystemResourceImportPage1.this.pathVariable;
            }
        }, DataTransferMessages.FileImport_importElementsAs);
        this.relativePathVariableGroup.createContents(relativeGroup);
        this.updateWidgetEnablements();
        this.relativePathVariableGroup.setSelection(true);
        return linkedResourceComposite;
    }

    private void handleAdvancedButtonSelect() {
        Shell shell = this.getShell();
        Point shellSize = shell.getSize();
        Composite composite = (Composite)this.getControl();
        if (this.linkedResourceComposite != null) {
            this.linkedResourceComposite.dispose();
            this.linkedResourceComposite = null;
            this.createLinksInWorkspaceButton = null;
            this.createVirtualFoldersButton = null;
            this.relativePathVariableGroup = null;
            composite.layout();
            shell.setSize(shellSize.x, shellSize.y - this.linkedResourceGroupHeight);
            this.advancedButton.setText(IDEWorkbenchMessages.showAdvanced);
        } else {
            this.linkedResourceComposite = this.createAdvancedSection(this.linkedResourceParent);
            if (this.linkedResourceGroupHeight == -1) {
                Point groupSize = this.linkedResourceComposite.computeSize(-1, -1, true);
                this.linkedResourceGroupHeight = groupSize.y;
            }
            shell.setSize(shellSize.x, shellSize.y + this.linkedResourceGroupHeight);
            composite.layout();
            this.advancedButton.setText(IDEWorkbenchMessages.hideAdvanced);
        }
    }

    protected void createRootDirectoryGroup(Composite parent) {
        Composite sourceContainerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        sourceContainerGroup.setLayout((Layout)layout);
        sourceContainerGroup.setFont(parent.getFont());
        sourceContainerGroup.setLayoutData((Object)new GridData(768));
        Label groupLabel = new Label(sourceContainerGroup, 0);
        groupLabel.setText(this.getSourceLabel());
        groupLabel.setFont(parent.getFont());
        this.sourceNameField = new Combo(sourceContainerGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.sourceNameField.setLayoutData((Object)data);
        this.sourceNameField.setFont(parent.getFont());
        BidiUtils.applyBidiProcessing((Combo)this.sourceNameField, (String)"file");
        this.sourceNameField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardFileSystemResourceImportPage1.this.updateFromSourceField();
            }
        });
        this.sourceNameField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    WizardFileSystemResourceImportPage1.this.entryChanged = false;
                    WizardFileSystemResourceImportPage1.this.updateFromSourceField();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.sourceNameField.addModifyListener(e -> {
            boolean bl = this.entryChanged = true;
        });
        this.sourceNameField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (WizardFileSystemResourceImportPage1.this.entryChanged) {
                    WizardFileSystemResourceImportPage1.this.entryChanged = false;
                    WizardFileSystemResourceImportPage1.this.updateFromSourceField();
                }
            }
        });
        this.sourceBrowseButton = new Button(sourceContainerGroup, 8);
        this.sourceBrowseButton.setText(DataTransferMessages.DataTransfer_browse);
        this.sourceBrowseButton.addListener(13, (Listener)this);
        this.sourceBrowseButton.setLayoutData((Object)new GridData(256));
        this.sourceBrowseButton.setFont(parent.getFont());
        this.setButtonLayoutData(this.sourceBrowseButton);
    }

    private void updateFromSourceField() {
        this.setSourceName(this.sourceNameField.getText());
        this.updateWidgetEnablements();
        this.fileSystemStructureProvider.clearVisitedDirs();
        this.selectionGroup.setFocus();
    }

    protected MinimizedFileSystemElement createRootElement(Object fileSystemObject, IImportStructureProvider provider) {
        boolean isContainer = provider.isFolder(fileSystemObject);
        String elementLabel = provider.getLabel(fileSystemObject);
        MinimizedFileSystemElement dummyParent = new MinimizedFileSystemElement("", null, true);
        dummyParent.setPopulated();
        MinimizedFileSystemElement result = new MinimizedFileSystemElement(elementLabel, dummyParent, isContainer);
        result.setFileSystemObject(fileSystemObject);
        result.getFiles(provider);
        return dummyParent;
    }

    @Override
    protected void createSourceGroup(Composite parent) {
        this.createRootDirectoryGroup(parent);
        this.createFileSelectionGroup(parent);
        this.createButtonsGroup(parent);
    }

    protected void enableButtonGroup(boolean enable) {
        this.selectTypesButton.setEnabled(enable);
        this.selectAllButton.setEnabled(enable);
        this.deselectAllButton.setEnabled(enable);
    }

    protected boolean ensureSourceIsValid() {
        if (new File(this.getSourceDirectoryName()).isDirectory()) {
            return true;
        }
        this.setErrorMessage(DataTransferMessages.FileImport_invalidSource);
        return false;
    }

    protected boolean executeImportOperation(ImportOperation op) {
        this.initializeOperation(op);
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            this.displayErrorDialog(e.getTargetException());
            return false;
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)DataTransferMessages.FileImport_importProblems, null, (IStatus)status);
            return false;
        }
        return true;
    }

    public boolean finish() {
        if (!this.ensureSourceIsValid()) {
            return false;
        }
        this.saveWidgetValues();
        Iterator resourcesEnum = this.getSelectedResources().iterator();
        ArrayList<Object> fileSystemObjects = new ArrayList<Object>();
        while (resourcesEnum.hasNext()) {
            fileSystemObjects.add(((FileSystemElement)resourcesEnum.next()).getFileSystemObject());
        }
        if (fileSystemObjects.size() > 0) {
            return this.importResources(fileSystemObjects);
        }
        MessageDialog.openInformation((Shell)this.getContainer().getShell(), (String)DataTransferMessages.DataTransfer_information, (String)DataTransferMessages.FileImport_noneSelected);
        return false;
    }

    @Override
    protected ITreeContentProvider getFileProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement element = (MinimizedFileSystemElement)((Object)o);
                    return element.getFiles(WizardFileSystemResourceImportPage1.this.fileSystemStructureProvider).getChildren((Object)element);
                }
                return new Object[0];
            }
        };
    }

    protected MinimizedFileSystemElement getFileSystemTree() {
        File sourceDirectory = this.getSourceDirectory();
        if (sourceDirectory == null) {
            return null;
        }
        return this.selectFiles(sourceDirectory, this.fileSystemStructureProvider);
    }

    @Override
    protected ITreeContentProvider getFolderProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement element = (MinimizedFileSystemElement)((Object)o);
                    return element.getFolders(WizardFileSystemResourceImportPage1.this.fileSystemStructureProvider).getChildren((Object)element);
                }
                return new Object[0];
            }

            public boolean hasChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement element = (MinimizedFileSystemElement)((Object)o);
                    if (element.isPopulated()) {
                        return this.getChildren((Object)element).length > 0;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    protected File getSourceDirectory() {
        return this.getSourceDirectory(this.sourceNameField.getText());
    }

    private File getSourceDirectory(String path) {
        File sourceDirectory = new File(this.getSourceDirectoryName(path));
        if (!sourceDirectory.exists() || !sourceDirectory.isDirectory()) {
            return null;
        }
        return sourceDirectory;
    }

    private String getSourceDirectoryName() {
        return this.getSourceDirectoryName(this.sourceNameField.getText());
    }

    private String getSourceDirectoryName(String sourceName) {
        Path result = new Path(sourceName.trim());
        result = result.getDevice() != null && result.segmentCount() == 0 ? result.addTrailingSeparator() : result.removeTrailingSeparator();
        return result.toOSString();
    }

    protected String getSourceLabel() {
        return DataTransferMessages.FileImport_fromDirectory;
    }

    @Override
    public void handleEvent(Event event) {
        if (event.widget == this.sourceBrowseButton) {
            this.handleSourceBrowseButtonPressed();
        }
        super.handleEvent(event);
    }

    protected void handleSourceBrowseButtonPressed() {
        String currentSource = this.sourceNameField.getText();
        DirectoryDialog dialog = new DirectoryDialog(this.sourceNameField.getShell(), 0x10002000);
        dialog.setText(SELECT_SOURCE_TITLE);
        dialog.setMessage(SELECT_SOURCE_MESSAGE);
        dialog.setFilterPath(this.getSourceDirectoryName(currentSource));
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            if (this.getSourceDirectory(selectedDirectory) == null || selectedDirectory.equals(currentSource)) {
                return;
            }
            this.setErrorMessage(null);
            this.setSourceName(selectedDirectory);
            this.selectionGroup.setFocus();
        }
    }

    @Override
    protected void handleTypesEditButtonPressed() {
        super.handleTypesEditButtonPressed();
    }

    protected boolean importResources(List fileSystemObjects) {
        boolean shouldImportTopLevelFoldersRecursively = this.selectionGroup.isEveryItemChecked() && !this.createTopLevelFolderCheckbox.getSelection() && this.createLinksInWorkspaceButton != null && this.createLinksInWorkspaceButton.getSelection() && this.createVirtualFoldersButton != null && !this.createVirtualFoldersButton.getSelection();
        File sourceDirectory = this.getSourceDirectory();
        if (this.createTopLevelFolderCheckbox.getSelection() && sourceDirectory.getParentFile() != null) {
            sourceDirectory = sourceDirectory.getParentFile();
        }
        ImportOperation operation = shouldImportTopLevelFoldersRecursively ? new ImportOperation(this.getContainerFullPath(), sourceDirectory, this.fileSystemStructureProvider, this, Arrays.asList(this.getSourceDirectory())) : new ImportOperation(this.getContainerFullPath(), sourceDirectory, this.fileSystemStructureProvider, this, fileSystemObjects);
        operation.setContext(this.getShell());
        return this.executeImportOperation(operation);
    }

    @Override
    protected void handleContainerBrowseButtonPressed() {
        super.handleContainerBrowseButtonPressed();
        IPath path = this.getContainerFullPath();
        if (path != null && this.relativePathVariableGroup != null) {
            IResource target = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            File file = this.getSourceDirectory();
            if (file != null && target != null) {
                this.relativePathVariableGroup.setupVariableContent();
                String preferedVariable = RelativePathVariableGroup.getPreferredVariable(new IPath[]{Path.fromOSString((String)file.getAbsolutePath())}, (IContainer)target);
                if (preferedVariable != null) {
                    this.relativePathVariableGroup.selectVariable(preferedVariable);
                }
            }
        }
        this.updateWidgetEnablements();
    }

    protected void initializeOperation(ImportOperation op) {
        op.setCreateContainerStructure(false);
        op.setOverwriteResources(this.overwriteExistingResourcesCheckbox.getSelection());
        if (this.createLinksInWorkspaceButton != null && this.createLinksInWorkspaceButton.getSelection()) {
            op.setCreateLinks(true);
            op.setVirtualFolders(this.createVirtualFoldersButton.getSelection());
            if (this.relativePathVariableGroup.getSelection()) {
                op.setRelativeVariable(this.pathVariable);
            }
        }
    }

    protected boolean isExportableExtension(String extension) {
        if (this.selectedTypes == null) {
            return true;
        }
        Iterator itr = this.selectedTypes.iterator();
        while (itr.hasNext()) {
            if (!extension.equalsIgnoreCase((String)itr.next())) continue;
            return true;
        }
        return false;
    }

    protected void resetSelection() {
        String variable;
        IResource target;
        IPath path;
        MinimizedFileSystemElement currentRoot = this.getFileSystemTree();
        this.selectionGroup.setRoot((Object)currentRoot);
        File sourceDirectory = this.getSourceDirectory();
        if (sourceDirectory != null && (path = this.getContainerFullPath()) != null && this.relativePathVariableGroup != null && (target = ResourcesPlugin.getWorkspace().getRoot().findMember(path)) != null && (variable = RelativePathVariableGroup.getPreferredVariable(new IPath[]{Path.fromOSString((String)sourceDirectory.getAbsolutePath())}, (IContainer)target)) != null) {
            this.relativePathVariableGroup.selectVariable(variable);
        }
    }

    @Override
    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (sourceNames == null) {
                return;
            }
            int i = 0;
            while (i < sourceNames.length) {
                this.sourceNameField.add(sourceNames[i]);
                ++i;
            }
            this.overwriteExistingResourcesCheckbox.setSelection(settings.getBoolean(STORE_OVERWRITE_EXISTING_RESOURCES_ID));
            boolean createStructure = settings.getBoolean(STORE_CREATE_CONTAINER_STRUCTURE_ID);
            this.createTopLevelFolderCheckbox.setSelection(createStructure);
            if (this.createVirtualFoldersButton != null) {
                boolean createVirtualFolders = settings.getBoolean(STORE_CREATE_VIRTUAL_FOLDERS_ID);
                this.createVirtualFoldersButton.setSelection(createVirtualFolders);
                boolean createLinkedResources = settings.getBoolean(STORE_CREATE_LINKS_IN_WORKSPACE_ID);
                this.createLinksInWorkspaceButton.setSelection(createLinkedResources);
                boolean pathVariableSelected = settings.getBoolean(STORE_PATH_VARIABLE_SELECTED_ID);
                this.relativePathVariableGroup.setSelection(pathVariableSelected);
                this.pathVariable = settings.get(STORE_PATH_VARIABLE_NAME_ID);
                if (this.pathVariable != null) {
                    this.relativePathVariableGroup.selectVariable(this.pathVariable);
                }
            }
            this.updateWidgetEnablements();
        }
    }

    @Override
    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            sourceNames = this.addToHistory(sourceNames, this.getSourceDirectoryName());
            settings.put(STORE_SOURCE_NAMES_ID, sourceNames);
            settings.put(STORE_OVERWRITE_EXISTING_RESOURCES_ID, this.overwriteExistingResourcesCheckbox.getSelection());
            settings.put(STORE_CREATE_CONTAINER_STRUCTURE_ID, this.createTopLevelFolderCheckbox.getSelection());
            if (this.createVirtualFoldersButton != null) {
                settings.put(STORE_CREATE_VIRTUAL_FOLDERS_ID, this.createVirtualFoldersButton.getSelection());
                settings.put(STORE_CREATE_LINKS_IN_WORKSPACE_ID, this.createLinksInWorkspaceButton.getSelection());
                settings.put(STORE_PATH_VARIABLE_SELECTED_ID, this.relativePathVariableGroup.getSelection());
                settings.put(STORE_PATH_VARIABLE_NAME_ID, this.pathVariable);
            }
        }
    }

    protected MinimizedFileSystemElement selectFiles(Object rootFileSystemObject, IImportStructureProvider structureProvider) {
        MinimizedFileSystemElement[] results = new MinimizedFileSystemElement[1];
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), () -> {
            MinimizedFileSystemElement minimizedFileSystemElement = this.createRootElement(rootFileSystemObject, structureProvider);
        });
        return results[0];
    }

    @Override
    protected void setAllSelections(boolean value) {
        super.setAllSelections(value);
    }

    protected void setSourceName(String path) {
        if (path.length() > 0) {
            String[] currentItems = this.sourceNameField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length) {
                if (currentItems[i].equals(path)) {
                    selectionIndex = i;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                int oldLength = currentItems.length;
                String[] newItems = new String[oldLength + 1];
                System.arraycopy(currentItems, 0, newItems, 0, oldLength);
                newItems[oldLength] = path;
                this.sourceNameField.setItems(newItems);
                selectionIndex = oldLength;
            }
            this.sourceNameField.select(selectionIndex);
            this.resetSelection();
        }
    }

    @Override
    protected void setupSelectionsBasedOnSelectedTypes() {
        ProgressMonitorJobsDialog dialog = new ProgressMonitorJobsDialog(this.getContainer().getShell());
        final Hashtable selectionMap = new Hashtable();
        IElementFilter filter = new IElementFilter(){

            @Override
            public void filterElements(Collection files, IProgressMonitor monitor) throws InterruptedException {
                if (files == null) {
                    throw new InterruptedException();
                }
                Iterator filesList = files.iterator();
                while (filesList.hasNext()) {
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    this.checkFile(filesList.next());
                }
            }

            @Override
            public void filterElements(Object[] files, IProgressMonitor monitor) throws InterruptedException {
                if (files == null) {
                    throw new InterruptedException();
                }
                int i = 0;
                while (i < files.length) {
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    this.checkFile(files[i]);
                    ++i;
                }
            }

            private void checkFile(Object fileElement) {
                MinimizedFileSystemElement file = (MinimizedFileSystemElement)((Object)fileElement);
                if (WizardFileSystemResourceImportPage1.this.isExportableExtension(file.getFileNameExtension())) {
                    List<MinimizedFileSystemElement> elements = new ArrayList<MinimizedFileSystemElement>();
                    FileSystemElement parent = file.getParent();
                    if (selectionMap.containsKey(parent)) {
                        elements = (List)selectionMap.get(parent);
                    }
                    elements.add(file);
                    selectionMap.put(parent, elements);
                }
            }
        };
        IRunnableWithProgress runnable = monitor -> {
            monitor.beginTask(DataTransferMessages.ImportPage_filterSelections, -1);
            this.getSelectedResources(filter, monitor);
        };
        try {
            dialog.run(true, true, runnable);
        }
        catch (InvocationTargetException invocationTargetException) {
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        this.getShell().update();
        if (selectionMap != null) {
            this.updateSelections(selectionMap);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.resetSelection();
        if (visible) {
            this.selectionGroup.setFocus();
            this.sourceNameField.setFocus();
        }
    }

    @Override
    protected void updateSelections(Map map) {
        super.updateSelections(map);
    }

    @Override
    protected void updateWidgetEnablements() {
        super.updateWidgetEnablements();
        this.enableButtonGroup(this.ensureSourceIsValid());
        if (this.createLinksInWorkspaceButton != null) {
            IResource target;
            IPath path = this.getContainerFullPath();
            if (path != null && this.relativePathVariableGroup != null && (target = ResourcesPlugin.getWorkspace().getRoot().findMember(path)) != null && target.isVirtual()) {
                this.createVirtualFoldersButton.setSelection(true);
            }
            this.relativePathVariableGroup.setEnabled(this.createLinksInWorkspaceButton.getSelection());
            this.createVirtualFoldersButton.setEnabled(this.createLinksInWorkspaceButton.getSelection());
            if (!this.selectionGroup.isEveryItemChecked() || this.createTopLevelFolderCheckbox.getSelection()) {
                this.createVirtualFoldersButton.setSelection(true);
            }
        }
    }

    @Override
    protected boolean validateSourceGroup() {
        File sourceDirectory = this.getSourceDirectory();
        if (sourceDirectory == null) {
            this.setMessage(SOURCE_EMPTY_MESSAGE);
            this.enableButtonGroup(false);
            return false;
        }
        if (this.sourceConflictsWithDestination((IPath)new Path(sourceDirectory.getPath()))) {
            this.setMessage(null);
            this.setErrorMessage(this.getSourceConflictMessage());
            this.enableButtonGroup(false);
            return false;
        }
        List resourcesToExport = this.selectionGroup.getAllWhiteCheckedItems();
        if (resourcesToExport.size() == 0) {
            this.setMessage(null);
            this.setErrorMessage(DataTransferMessages.FileImport_noneSelected);
            return false;
        }
        IContainer container = this.getSpecifiedContainer();
        if (container != null && container.isVirtual()) {
            if (ResourcesPlugin.getPlugin().getPluginPreferences().getBoolean("description.disableLinking")) {
                this.setMessage(null);
                this.setErrorMessage(DataTransferMessages.FileImport_cannotImportFilesUnderAVirtualFolder);
                return false;
            }
            if (this.createLinksInWorkspaceButton == null || !this.createLinksInWorkspaceButton.getSelection()) {
                this.setMessage(null);
                this.setErrorMessage(DataTransferMessages.FileImport_haveToCreateLinksUnderAVirtualFolder);
                return false;
            }
        }
        this.enableButtonGroup(true);
        this.setErrorMessage(null);
        return true;
    }

    @Override
    protected boolean sourceConflictsWithDestination(IPath sourcePath) {
        IContainer container = this.getSpecifiedContainer();
        if (container == null) {
            return false;
        }
        IPath destinationLocation = this.getSpecifiedContainer().getLocation();
        if (destinationLocation != null) {
            return destinationLocation.isPrefixOf(sourcePath);
        }
        return false;
    }
}

