/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.ui.tests.view.controlflow;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.ControlFlowColumnComparators;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.ControlFlowEntry;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.IControlFlowEntryComparator;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.ITimeGraphEntryComparator;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.junit.Assert;
import org.junit.Test;

public class ControlFlowEntryComparatorTest {
    private static final @NonNull String TRACE1_NAME = "/synctraces/scp_dest";
    private static final @NonNull String TRACE2_NAME = "/synctraces/scp_src";
    private static final @NonNull String TRACE3_NAME = "/debuginfo-test-app4";
    private static final @NonNull String TRACE_EXEC_NAME1 = "AAA";
    private static final @NonNull String TRACE_EXEC_NAME2 = "BBB";
    private static final @NonNull String TRACE_EXEC_NAME3 = "CCC";
    private static final int TRACE_TID1 = 1;
    private static final int TRACE_TID2 = 2;
    private static final int TRACE_TID3 = 3;
    private static final int TRACE_PTID1 = 1;
    private static final int TRACE_PTID2 = 2;
    private static final int TRACE_PTID3 = 3;
    private static final int TRACE_START_TIME1 = 1;
    private static final int TRACE_START_TIME2 = 2;
    private static final int TRACE_START_TIME3 = 3;
    private static final int TRACE_END_TIME = 4;

    @Test
    public void execNameComparatorTest() {
        ControlFlowEntry trace1Entry1 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 1, 1L, 4L);
        ControlFlowEntry trace1Entry2 = new ControlFlowEntry(0, TRACE_EXEC_NAME2, 1, 1, 1L, 4L);
        ControlFlowEntry trace1Entry3 = new ControlFlowEntry(0, TRACE_EXEC_NAME3, 1, 1, 1L, 4L);
        List<ControlFlowEntry> testVec = Arrays.asList(trace1Entry2, trace1Entry3, trace1Entry1);
        List<ControlFlowEntry> expected = Arrays.asList(trace1Entry1, trace1Entry2, trace1Entry3);
        Collections.sort(testVec, IControlFlowEntryComparator.PROCESS_NAME_COMPARATOR);
        Assert.assertEquals(expected, testVec);
    }

    @Test
    public void tidComparatorTest() {
        ControlFlowEntry trace1Entry1 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 1, 1L, 4L);
        ControlFlowEntry trace1Entry2 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 2, 1, 1L, 4L);
        ControlFlowEntry trace1Entry3 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 3, 1, 1L, 4L);
        List<ControlFlowEntry> testVec = Arrays.asList(trace1Entry2, trace1Entry3, trace1Entry1);
        List<ControlFlowEntry> expected = Arrays.asList(trace1Entry1, trace1Entry2, trace1Entry3);
        Collections.sort(testVec, IControlFlowEntryComparator.TID_COMPARATOR);
        Assert.assertEquals(expected, testVec);
    }

    @Test
    public void ptidComparatorTest() {
        ControlFlowEntry trace1Entry1 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 1, 1L, 4L);
        ControlFlowEntry trace1Entry2 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 2, 1L, 4L);
        ControlFlowEntry trace1Entry3 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 3, 1L, 4L);
        List<ControlFlowEntry> testVec = Arrays.asList(trace1Entry2, trace1Entry3, trace1Entry1);
        List<ControlFlowEntry> expected = Arrays.asList(trace1Entry1, trace1Entry2, trace1Entry3);
        Collections.sort(testVec, IControlFlowEntryComparator.PTID_COMPARATOR);
        Assert.assertEquals(expected, testVec);
    }

    @Test
    public void birthTimeComparatorTest() {
        ControlFlowEntry trace1Entry1 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 1, 1L, 4L);
        ControlFlowEntry trace1Entry2 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 1, 2L, 4L);
        ControlFlowEntry trace1Entry3 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 1, 3L, 4L);
        List<ControlFlowEntry> testVec = Arrays.asList(trace1Entry2, trace1Entry3, trace1Entry1);
        List<ControlFlowEntry> expected = Arrays.asList(trace1Entry1, trace1Entry2, trace1Entry3);
        Collections.sort(testVec, IControlFlowEntryComparator.BIRTH_TIME_COMPARATOR);
        Assert.assertEquals(expected, testVec);
    }

    @Test
    public void execNameColumnComparatorTest() {
        TimeGraphEntry trace1Entry = new TimeGraphEntry(TRACE1_NAME, 1L, 4L);
        TimeGraphEntry trace2Entry = new TimeGraphEntry(TRACE2_NAME, 2L, 4L);
        TimeGraphEntry trace3Entry = new TimeGraphEntry(TRACE3_NAME, 3L, 4L);
        List<TimeGraphEntry> testVec = Arrays.asList(trace1Entry, trace2Entry, trace3Entry);
        List<TimeGraphEntry> expectedDown = Arrays.asList(trace3Entry, trace1Entry, trace2Entry);
        List<TimeGraphEntry> expectedUp = Arrays.asList(trace2Entry, trace1Entry, trace3Entry);
        ControlFlowEntryComparatorTest.runTest(ControlFlowColumnComparators.PROCESS_NAME_COLUMN_COMPARATOR, testVec, expectedDown, expectedUp);
        ControlFlowEntry trace1Entry1 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 1, 1L, 4L);
        ControlFlowEntry trace1Entry2 = new ControlFlowEntry(0, TRACE_EXEC_NAME2, 1, 1, 1L, 4L);
        ControlFlowEntry trace1Entry3 = new ControlFlowEntry(0, TRACE_EXEC_NAME3, 1, 1, 1L, 4L);
        testVec = Arrays.asList(trace1Entry2, trace1Entry3, trace1Entry1);
        expectedDown = Arrays.asList(trace1Entry1, trace1Entry2, trace1Entry3);
        expectedUp = Arrays.asList(trace1Entry3, trace1Entry2, trace1Entry1);
        ControlFlowEntryComparatorTest.runTest(ControlFlowColumnComparators.PROCESS_NAME_COLUMN_COMPARATOR, testVec, expectedDown, expectedUp);
    }

    @Test
    public void execNameSecondaryTimeColumnComparatorTest() {
        ControlFlowEntry trace1Entry1 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 1, 1L, 4L);
        ControlFlowEntry trace1Entry2 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 1, 2L, 4L);
        ControlFlowEntry trace1Entry3 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 1, 3L, 4L);
        List<TimeGraphEntry> testVec = Arrays.asList(trace1Entry2, trace1Entry3, trace1Entry1);
        List<TimeGraphEntry> expectedDown = Arrays.asList(trace1Entry1, trace1Entry2, trace1Entry3);
        List<TimeGraphEntry> expectedUp = Arrays.asList(trace1Entry1, trace1Entry2, trace1Entry3);
        ControlFlowEntryComparatorTest.runTest(ControlFlowColumnComparators.PROCESS_NAME_COLUMN_COMPARATOR, testVec, expectedDown, expectedUp);
        trace1Entry1 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 1, 1L, 4L);
        trace1Entry2 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 2, 1, 1L, 4L);
        trace1Entry3 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 3, 1, 1L, 4L);
        testVec = Arrays.asList(trace1Entry2, trace1Entry3, trace1Entry1);
        expectedDown = Arrays.asList(trace1Entry1, trace1Entry2, trace1Entry3);
        expectedUp = Arrays.asList(trace1Entry1, trace1Entry2, trace1Entry3);
        ControlFlowEntryComparatorTest.runTest(ControlFlowColumnComparators.PROCESS_NAME_COLUMN_COMPARATOR, testVec, expectedDown, expectedUp);
        trace1Entry1 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 1, 1L, 4L);
        trace1Entry2 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 2, 1L, 4L);
        trace1Entry3 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 3, 1L, 4L);
        testVec = Arrays.asList(trace1Entry2, trace1Entry3, trace1Entry1);
        expectedDown = Arrays.asList(trace1Entry1, trace1Entry2, trace1Entry3);
        expectedUp = Arrays.asList(trace1Entry1, trace1Entry2, trace1Entry3);
        ControlFlowEntryComparatorTest.runTest(ControlFlowColumnComparators.PROCESS_NAME_COLUMN_COMPARATOR, testVec, expectedDown, expectedUp);
    }

    @Test
    public void tidColumnComparatorTest() {
        TimeGraphEntry trace1Entry = new TimeGraphEntry(TRACE1_NAME, 1L, 4L);
        TimeGraphEntry trace2Entry = new TimeGraphEntry(TRACE2_NAME, 2L, 4L);
        TimeGraphEntry trace3Entry = new TimeGraphEntry(TRACE3_NAME, 3L, 4L);
        List<TimeGraphEntry> testVec = Arrays.asList(trace1Entry, trace2Entry, trace3Entry);
        List<TimeGraphEntry> expectedDown = Arrays.asList(trace1Entry, trace2Entry, trace3Entry);
        List<TimeGraphEntry> expectedUp = Arrays.asList(trace1Entry, trace2Entry, trace3Entry);
        ControlFlowEntryComparatorTest.runTest(ControlFlowColumnComparators.TID_COLUMN_COMPARATOR, testVec, expectedDown, expectedUp);
        ControlFlowEntry trace1Entry1 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 1, 1L, 4L);
        ControlFlowEntry trace1Entry2 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 2, 1, 1L, 4L);
        ControlFlowEntry trace1Entry3 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 3, 1, 1L, 4L);
        testVec = Arrays.asList(trace1Entry2, trace1Entry3, trace1Entry1);
        expectedDown = Arrays.asList(trace1Entry1, trace1Entry2, trace1Entry3);
        expectedUp = Arrays.asList(trace1Entry3, trace1Entry2, trace1Entry1);
        ControlFlowEntryComparatorTest.runTest(ControlFlowColumnComparators.TID_COLUMN_COMPARATOR, testVec, expectedDown, expectedUp);
    }

    @Test
    public void tidSecondaryTimeColumnComparatorTest() {
        ControlFlowEntry trace1Entry1 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 1, 1L, 4L);
        ControlFlowEntry trace1Entry2 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 1, 2L, 4L);
        ControlFlowEntry trace1Entry3 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 1, 3L, 4L);
        List<TimeGraphEntry> testVec = Arrays.asList(trace1Entry2, trace1Entry3, trace1Entry1);
        List<TimeGraphEntry> expectedDown = Arrays.asList(trace1Entry1, trace1Entry2, trace1Entry3);
        List<TimeGraphEntry> expectedUp = Arrays.asList(trace1Entry1, trace1Entry2, trace1Entry3);
        ControlFlowEntryComparatorTest.runTest(ControlFlowColumnComparators.TID_COLUMN_COMPARATOR, testVec, expectedDown, expectedUp);
        trace1Entry1 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 1, 1L, 4L);
        trace1Entry2 = new ControlFlowEntry(0, TRACE_EXEC_NAME2, 1, 1, 1L, 4L);
        trace1Entry3 = new ControlFlowEntry(0, TRACE_EXEC_NAME3, 1, 1, 1L, 4L);
        testVec = Arrays.asList(trace1Entry2, trace1Entry3, trace1Entry1);
        expectedDown = Arrays.asList(trace1Entry1, trace1Entry2, trace1Entry3);
        expectedUp = Arrays.asList(trace1Entry1, trace1Entry2, trace1Entry3);
        ControlFlowEntryComparatorTest.runTest(ControlFlowColumnComparators.TID_COLUMN_COMPARATOR, testVec, expectedDown, expectedUp);
        trace1Entry1 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 1, 1L, 4L);
        trace1Entry2 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 2, 1L, 4L);
        trace1Entry3 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 3, 1L, 4L);
        testVec = Arrays.asList(trace1Entry2, trace1Entry3, trace1Entry1);
        expectedDown = Arrays.asList(trace1Entry1, trace1Entry2, trace1Entry3);
        expectedUp = Arrays.asList(trace1Entry1, trace1Entry2, trace1Entry3);
        ControlFlowEntryComparatorTest.runTest(ControlFlowColumnComparators.TID_COLUMN_COMPARATOR, testVec, expectedDown, expectedUp);
    }

    @Test
    public void ptidColumnComparatorTest() {
        TimeGraphEntry trace1Entry = new TimeGraphEntry(TRACE1_NAME, 1L, 4L);
        TimeGraphEntry trace2Entry = new TimeGraphEntry(TRACE2_NAME, 2L, 4L);
        TimeGraphEntry trace3Entry = new TimeGraphEntry(TRACE3_NAME, 3L, 4L);
        List<TimeGraphEntry> testVec = Arrays.asList(trace1Entry, trace2Entry, trace3Entry);
        List<TimeGraphEntry> expectedDown = Arrays.asList(trace1Entry, trace2Entry, trace3Entry);
        List<TimeGraphEntry> expectedUp = Arrays.asList(trace1Entry, trace2Entry, trace3Entry);
        ControlFlowEntryComparatorTest.runTest(ControlFlowColumnComparators.PTID_COLUMN_COMPARATOR, testVec, expectedDown, expectedUp);
        ControlFlowEntry trace1Entry1 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 1, 1L, 4L);
        ControlFlowEntry trace1Entry2 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 2, 1L, 4L);
        ControlFlowEntry trace1Entry3 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 3, 1L, 4L);
        testVec = Arrays.asList(trace1Entry2, trace1Entry3, trace1Entry1);
        expectedDown = Arrays.asList(trace1Entry1, trace1Entry2, trace1Entry3);
        expectedUp = Arrays.asList(trace1Entry3, trace1Entry2, trace1Entry1);
        ControlFlowEntryComparatorTest.runTest(ControlFlowColumnComparators.PTID_COLUMN_COMPARATOR, testVec, expectedDown, expectedUp);
    }

    @Test
    public void ptidSecondaryTimeColumnComparatorTest() {
        ControlFlowEntry trace1Entry1 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 1, 1L, 4L);
        ControlFlowEntry trace1Entry2 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 1, 2L, 4L);
        ControlFlowEntry trace1Entry3 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 1, 3L, 4L);
        List<TimeGraphEntry> testVec = Arrays.asList(trace1Entry2, trace1Entry3, trace1Entry1);
        List<TimeGraphEntry> expectedDown = Arrays.asList(trace1Entry1, trace1Entry2, trace1Entry3);
        List<TimeGraphEntry> expectedUp = Arrays.asList(trace1Entry1, trace1Entry2, trace1Entry3);
        ControlFlowEntryComparatorTest.runTest(ControlFlowColumnComparators.PTID_COLUMN_COMPARATOR, testVec, expectedDown, expectedUp);
        trace1Entry1 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 1, 1L, 4L);
        trace1Entry2 = new ControlFlowEntry(0, TRACE_EXEC_NAME2, 1, 1, 1L, 4L);
        trace1Entry3 = new ControlFlowEntry(0, TRACE_EXEC_NAME3, 1, 1, 1L, 4L);
        testVec = Arrays.asList(trace1Entry2, trace1Entry3, trace1Entry1);
        expectedDown = Arrays.asList(trace1Entry1, trace1Entry2, trace1Entry3);
        expectedUp = Arrays.asList(trace1Entry1, trace1Entry2, trace1Entry3);
        ControlFlowEntryComparatorTest.runTest(ControlFlowColumnComparators.PTID_COLUMN_COMPARATOR, testVec, expectedDown, expectedUp);
        trace1Entry1 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 1, 1L, 4L);
        trace1Entry2 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 2, 1, 1L, 4L);
        trace1Entry3 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 3, 1, 1L, 4L);
        testVec = Arrays.asList(trace1Entry2, trace1Entry3, trace1Entry1);
        expectedDown = Arrays.asList(trace1Entry1, trace1Entry2, trace1Entry3);
        expectedUp = Arrays.asList(trace1Entry1, trace1Entry2, trace1Entry3);
        ControlFlowEntryComparatorTest.runTest(ControlFlowColumnComparators.PTID_COLUMN_COMPARATOR, testVec, expectedDown, expectedUp);
    }

    @Test
    public void birthTimeColumnComparatorTest() {
        TimeGraphEntry trace1Entry = new TimeGraphEntry(TRACE1_NAME, 1L, 4L);
        TimeGraphEntry trace2Entry = new TimeGraphEntry(TRACE2_NAME, 2L, 4L);
        TimeGraphEntry trace3Entry = new TimeGraphEntry(TRACE3_NAME, 3L, 4L);
        List<TimeGraphEntry> testVec = Arrays.asList(trace1Entry, trace2Entry, trace3Entry);
        List<TimeGraphEntry> expectedDown = Arrays.asList(trace1Entry, trace2Entry, trace3Entry);
        List<TimeGraphEntry> expectedUp = Arrays.asList(trace3Entry, trace2Entry, trace1Entry);
        ControlFlowEntryComparatorTest.runTest(ControlFlowColumnComparators.BIRTH_TIME_COLUMN_COMPARATOR, testVec, expectedDown, expectedUp);
        ControlFlowEntry trace1Entry1 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 1, 1L, 4L);
        ControlFlowEntry trace1Entry2 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 1, 2L, 4L);
        ControlFlowEntry trace1Entry3 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 1, 3L, 4L);
        testVec = Arrays.asList(trace1Entry2, trace1Entry3, trace1Entry1);
        expectedDown = Arrays.asList(trace1Entry1, trace1Entry2, trace1Entry3);
        expectedUp = Arrays.asList(trace1Entry3, trace1Entry2, trace1Entry1);
        ControlFlowEntryComparatorTest.runTest(ControlFlowColumnComparators.BIRTH_TIME_COLUMN_COMPARATOR, testVec, expectedDown, expectedUp);
    }

    @Test
    public void birthTimeSecondaryTimeColumnComparatorTest() {
        ControlFlowEntry trace1Entry1 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 1, 1L, 4L);
        ControlFlowEntry trace1Entry2 = new ControlFlowEntry(0, TRACE_EXEC_NAME2, 1, 1, 1L, 4L);
        ControlFlowEntry trace1Entry3 = new ControlFlowEntry(0, TRACE_EXEC_NAME3, 1, 1, 1L, 4L);
        List<TimeGraphEntry> testVec = Arrays.asList(trace1Entry2, trace1Entry3, trace1Entry1);
        List<TimeGraphEntry> expectedDown = Arrays.asList(trace1Entry1, trace1Entry2, trace1Entry3);
        List<TimeGraphEntry> expectedUp = Arrays.asList(trace1Entry1, trace1Entry2, trace1Entry3);
        ControlFlowEntryComparatorTest.runTest(ControlFlowColumnComparators.BIRTH_TIME_COLUMN_COMPARATOR, testVec, expectedDown, expectedUp);
        trace1Entry1 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 1, 1L, 4L);
        trace1Entry2 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 2, 1, 1L, 4L);
        trace1Entry3 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 2, 1, 1L, 4L);
        testVec = Arrays.asList(trace1Entry2, trace1Entry3, trace1Entry1);
        expectedDown = Arrays.asList(trace1Entry1, trace1Entry2, trace1Entry3);
        expectedUp = Arrays.asList(trace1Entry1, trace1Entry2, trace1Entry3);
        ControlFlowEntryComparatorTest.runTest(ControlFlowColumnComparators.BIRTH_TIME_COLUMN_COMPARATOR, testVec, expectedDown, expectedUp);
        trace1Entry1 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 1, 1L, 4L);
        trace1Entry2 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 2, 1L, 4L);
        trace1Entry3 = new ControlFlowEntry(0, TRACE_EXEC_NAME1, 1, 3, 1L, 4L);
        testVec = Arrays.asList(trace1Entry2, trace1Entry3, trace1Entry1);
        expectedDown = Arrays.asList(trace1Entry1, trace1Entry2, trace1Entry3);
        expectedUp = Arrays.asList(trace1Entry1, trace1Entry2, trace1Entry3);
        ControlFlowEntryComparatorTest.runTest(ControlFlowColumnComparators.BIRTH_TIME_COLUMN_COMPARATOR, testVec, expectedDown, expectedUp);
    }

    private static void runTest(ITimeGraphEntryComparator comparator, List<TimeGraphEntry> testVec, List<TimeGraphEntry> expectedDown, List<TimeGraphEntry> expectedUp) {
        comparator.setDirection(1024);
        Collections.sort(testVec, comparator);
        Assert.assertEquals(expectedDown, testVec);
        comparator.setDirection(128);
        Object reverseComp = comparator;
        reverseComp = Collections.reverseOrder(reverseComp);
        Collections.sort(testVec, reverseComp);
        Assert.assertEquals(expectedUp, testVec);
    }
}

