/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.ui.tests.view.controlflow;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.ControlFlowEntry;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.NaiveOptimizationAlgorithm;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ILinkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeLinkEvent;
import org.junit.Assert;
import org.junit.Test;

public class ControlFlowOptimizerTest {
    protected Function<Collection<ILinkEvent>, Map<Integer, Long>> getOptimizationMethod() {
        return new NaiveOptimizationAlgorithm();
    }

    @Test
    public void testEmpty() {
        Function<Collection<ILinkEvent>, Map<Integer, Long>> oa = this.getOptimizationMethod();
        Map<Integer, Long> result = oa.apply(Collections.EMPTY_LIST);
        Assert.assertNotNull(result);
        Assert.assertEquals(Collections.emptyMap(), result);
    }

    @Test
    public void testSingleInvalid() {
        Function<Collection<ILinkEvent>, Map<Integer, Long>> oa = this.getOptimizationMethod();
        Map<Integer, Long> result = oa.apply(Collections.singleton(new TimeLinkEvent(null, null, 0L, 0L)));
        Assert.assertNotNull(result);
        Assert.assertEquals(Collections.emptyMap(), result);
    }

    public void testSinglePartiallyInvalid() {
        Function<Collection<ILinkEvent>, Map<Integer, Long>> oa = this.getOptimizationMethod();
        Map<Integer, Long> result = oa.apply(Collections.singleton(new TimeLinkEvent((ITimeGraphEntry)new TimeGraphEntry("Hi", 0L, 1L), (ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(0), 0L, 0L)));
        Assert.assertNotNull(result);
        Assert.assertEquals(Collections.emptyMap(), result);
        result = oa.apply(Collections.singleton(new TimeLinkEvent((ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(0), (ITimeGraphEntry)new TimeGraphEntry("Hi", 0L, 1L), 0L, 0L)));
        Assert.assertNotNull(result);
        Assert.assertEquals(Collections.emptyMap(), result);
        result = oa.apply(Collections.singleton(new TimeLinkEvent((ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(0), null, 0L, 0L)));
        Assert.assertNotNull(result);
        Assert.assertEquals(Collections.emptyMap(), result);
    }

    @Test
    public void testSingle() {
        Function<Collection<ILinkEvent>, Map<Integer, Long>> oa = this.getOptimizationMethod();
        Map<Integer, Long> result = oa.apply(Collections.singleton(new TimeLinkEvent((ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(2), (ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(0), 0L, 0L)));
        Assert.assertNotNull(result);
        Assert.assertEquals((Object)ImmutableMap.of((Object)0, (Object)0L, (Object)2, (Object)1L), result);
    }

    @Test
    public void testDouble() {
        Function<Collection<ILinkEvent>, Map<Integer, Long>> oa = this.getOptimizationMethod();
        ArrayList<TimeLinkEvent> links = new ArrayList<TimeLinkEvent>();
        links.add(new TimeLinkEvent((ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(2), (ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(0), 0L, 0L));
        links.add(new TimeLinkEvent((ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(1), (ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(0), 0L, 0L));
        Map<Integer, Long> result = oa.apply(links);
        Assert.assertNotNull(result);
        Assert.assertEquals((Object)ImmutableMap.of((Object)0, (Object)0L, (Object)1, (Object)1L, (Object)2, (Object)2L), result);
    }

    @Test
    public void testDoubleOtherOrder() {
        Function<Collection<ILinkEvent>, Map<Integer, Long>> oa = this.getOptimizationMethod();
        ArrayList<TimeLinkEvent> links = new ArrayList<TimeLinkEvent>();
        links.add(new TimeLinkEvent((ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(1), (ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(0), 0L, 0L));
        links.add(new TimeLinkEvent((ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(2), (ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(0), 0L, 0L));
        Map<Integer, Long> result = oa.apply(links);
        Assert.assertNotNull(result);
        Assert.assertEquals((Object)ImmutableMap.of((Object)0, (Object)0L, (Object)1, (Object)1L, (Object)2, (Object)2L), result);
    }

    @Test
    public void test9InOrder() {
        Map<Integer, Long> expected = ControlFlowOptimizerTest.getExpected9();
        Function<Collection<ILinkEvent>, Map<Integer, Long>> oa = this.getOptimizationMethod();
        List<ILinkEvent> links = ControlFlowOptimizerTest.getTestVector();
        Map<Integer, Long> result = oa.apply(links);
        Assert.assertNotNull(result);
        Assert.assertEquals(expected, result);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void test9InOrder10Times() {
        void var5_6;
        Map<Integer, Long> expected = ControlFlowOptimizerTest.getExpected9();
        Function<Collection<ILinkEvent>, Map<Integer, Long>> oa = this.getOptimizationMethod();
        List<ILinkEvent> links = ControlFlowOptimizerTest.getTestVector();
        ArrayList<Map<Integer, Long>> results = new ArrayList<Map<Integer, Long>>();
        boolean bl = false;
        while (var5_6 < 10) {
            results.add(oa.apply(links));
            ++var5_6;
        }
        for (Map map : results) {
            Assert.assertEquals(expected, (Object)map);
        }
    }

    @Test
    public void test9OutOfOrder() {
        Map<Integer, Long> expected = ControlFlowOptimizerTest.getExpected9();
        Random rnd = new Random();
        rnd.setSeed(0L);
        Function<Collection<ILinkEvent>, Map<Integer, Long>> oa = this.getOptimizationMethod();
        List<ILinkEvent> links = ControlFlowOptimizerTest.getTestVector();
        Collections.shuffle(links, rnd);
        Map<Integer, Long> result = oa.apply(links);
        Assert.assertNotNull(result);
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testMany() {
        Random rnd = new Random();
        rnd.setSeed(12345L);
        Function<Collection<ILinkEvent>, Map<Integer, Long>> oa = this.getOptimizationMethod();
        ArrayList<TimeLinkEvent> links = new ArrayList<TimeLinkEvent>();
        int count = 25000;
        int i = 0;
        while (i < count) {
            int src = rnd.nextInt(10000);
            int dst = rnd.nextInt(1000);
            links.add(new TimeLinkEvent((ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(src), (ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(dst), (long)src, (long)dst));
            ++i;
        }
        Map<Integer, Long> result = oa.apply(links);
        Assert.assertNotNull(result);
        long initialWeight = 0L;
        long optimalWeight = 0L;
        for (ILinkEvent iLinkEvent : links) {
            long src = iLinkEvent.getTime();
            long dst = iLinkEvent.getDuration();
            initialWeight += Math.abs(src - dst);
            Long newSrc = result.get((int)src);
            Long newDst = result.get((int)dst);
            Assert.assertNotNull((Object)newSrc);
            Assert.assertNotNull((Object)newDst);
            optimalWeight += Math.abs(newSrc - newDst);
        }
        Assert.assertTrue((optimalWeight <= initialWeight ? 1 : 0) != 0);
    }

    private static ControlFlowEntry generateCFVEntry(int tid) {
        return new ControlFlowEntry(0, "exec", tid, 0, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    private static List<ILinkEvent> getTestVector() {
        ArrayList<ILinkEvent> links = new ArrayList<ILinkEvent>();
        links.add((ILinkEvent)new TimeLinkEvent((ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(1), (ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(2), 0L, 0L));
        links.add((ILinkEvent)new TimeLinkEvent((ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(1), (ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(2), 0L, 0L));
        links.add((ILinkEvent)new TimeLinkEvent((ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(1), (ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(2), 0L, 0L));
        links.add((ILinkEvent)new TimeLinkEvent((ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(1), (ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(2), 0L, 0L));
        links.add((ILinkEvent)new TimeLinkEvent((ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(1), (ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(3), 0L, 0L));
        links.add((ILinkEvent)new TimeLinkEvent((ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(1), (ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(3), 0L, 0L));
        links.add((ILinkEvent)new TimeLinkEvent((ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(1), (ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(3), 0L, 0L));
        links.add((ILinkEvent)new TimeLinkEvent((ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(1), (ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(4), 0L, 0L));
        links.add((ILinkEvent)new TimeLinkEvent((ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(1), (ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(4), 0L, 0L));
        links.add((ILinkEvent)new TimeLinkEvent((ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(1), (ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(5), 0L, 0L));
        links.add((ILinkEvent)new TimeLinkEvent((ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(2), (ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(4), 0L, 0L));
        links.add((ILinkEvent)new TimeLinkEvent((ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(2), (ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(5), 0L, 0L));
        links.add((ILinkEvent)new TimeLinkEvent((ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(2), (ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(6), 0L, 0L));
        links.add((ILinkEvent)new TimeLinkEvent((ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(2), (ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(7), 0L, 0L));
        links.add((ILinkEvent)new TimeLinkEvent((ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(2), (ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(8), 0L, 0L));
        links.add((ILinkEvent)new TimeLinkEvent((ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(2), (ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(9), 0L, 0L));
        links.add((ILinkEvent)new TimeLinkEvent((ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(2), (ITimeGraphEntry)ControlFlowOptimizerTest.generateCFVEntry(10), 0L, 0L));
        return links;
    }

    private static Map<Integer, Long> getExpected9() {
        HashMap<Integer, Long> expected = new HashMap<Integer, Long>();
        int i = 0;
        while (i < 10) {
            expected.put(i + 1, Long.valueOf(i));
            ++i;
        }
        return expected;
    }
}

