/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.ui.swtbot.tests.preferences;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTableItem;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlAnalysisModuleSource;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.Activator;
import org.eclipse.tracecompass.tmf.core.tests.TmfCoreTestPlugin;
import org.eclipse.tracecompass.tmf.ui.dialog.TmfFileDialogFactory;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class XMLAnalysesManagerPreferencePageTest {
    private static final Logger fLogger = Logger.getRootLogger();
    protected static final String KERNEL_TRACE_TYPE = "org.eclipse.linuxtools.lttng2.kernel.tracetype";
    protected static final String TRACE_PROJECT_NAME = "test";
    private static final String TRACE_PATH = "testfiles/syslog_collapse";
    private static final String EXTENSION = ".xml";
    private static final String TEST_FILES_FOLDER = "test_xml_files/";
    private static final String VALID_FILES_FOLDER = "test_valid/";
    private static final String INVALID_FILES_FOLDER = "test_invalid/";
    private static final String[] FILES_IMPORT_VALID = new String[]{"test_valid", "test_valid_xml_timegraphView"};
    private static final String FILE_IMPORT_INVALID = "test_invalid";
    private static final String[] FILES_DELETE = new String[]{"test_valid_extended", "test_valid_pattern"};
    private static final String[] FILES_EDIT = new String[]{"kvm_exits", "test_consuming_fsm"};
    private static final String FILE_EXPORT = "state_provider_placement";
    private static final String[] FILES_BUTTONS = new String[]{"test_state_values", "test_state_values_pattern", "test_pattern_segment", "test_doubles", "test_attributes"};
    private static final @NonNull String CHECK_SELECTED = "Check selected";
    private static final @NonNull String CHECK_ALL = "Check all";
    private static final @NonNull String UNCHECK_SELECTED = "Uncheck selected";
    private static final @NonNull String UNCHECK_ALL = "Uncheck all";
    private static SWTWorkbenchBot fBot;

    @BeforeClass
    public static void beforeClass() {
        SWTBotUtils.initialize();
        SWTBotPreferences.TIMEOUT = 20000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout(), "System.out"));
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.closeView((String)"welcome", (SWTWorkbenchBot)fBot);
        SWTBotUtils.switchToTracingPerspective();
    }

    @Before
    public void before() {
        SWTBotUtils.createProject((String)TRACE_PROJECT_NAME);
        WaitUtils.waitForJobs();
        XMLAnalysesManagerPreferencePageTest.setUpTrace();
    }

    private static void setUpTrace() {
        URL location = FileLocator.find((Bundle)TmfCoreTestPlugin.getDefault().getBundle(), (IPath)new Path(TRACE_PATH), null);
        try {
            URI uri = FileLocator.toFileURL((URL)location).toURI();
            File testFile = new File(uri);
            SWTBotUtils.openTrace((String)TRACE_PROJECT_NAME, (String)testFile.getAbsolutePath(), (String)KERNEL_TRACE_TYPE);
            Assert.assertNotNull((Object)testFile);
            Assume.assumeTrue((boolean)testFile.exists());
        }
        catch (IOException | URISyntaxException e) {
            Assert.fail((String)"Failed to open the trace");
        }
    }

    @Test
    public void testPreferencePageMenuBar() {
        SWTBot bot = XMLAnalysesManagerPreferencePageTest.openXMLAnalysesPreferences().bot();
        SWTBotUtils.pressOKishButtonInPreferences((SWTBot)bot);
    }

    @Test
    public void testDelete() {
        SWTBot bot = XMLAnalysesManagerPreferencePageTest.openXMLAnalysesPreferences().bot();
        XMLAnalysesManagerPreferencePageTest.importAnalysis(bot, XMLAnalysesManagerPreferencePageTest.getRelativePaths(VALID_FILES_FOLDER, FILES_DELETE));
        SWTBotTable tablebot = bot.table(0);
        tablebot.select(new String[]{FILES_DELETE[0]});
        bot.button("Edit...").click();
        tablebot.select(FILES_DELETE);
        bot.button("Delete").click();
        SWTBotShell deleteShell = bot.shell("Delete XML file").activate();
        deleteShell.bot().button("Yes").click();
        String[] stringArray = FILES_DELETE;
        int n = FILES_DELETE.length;
        int n2 = 0;
        while (n2 < n) {
            String deleteFile = stringArray[n2];
            Assert.assertFalse((String)deleteFile, (boolean)tablebot.containsItem(deleteFile));
            ++n2;
        }
        fBot.editors().forEach(editor -> {
            if (editor != null && editor.getTitle().equals(String.valueOf(FILES_DELETE[0]) + EXTENSION)) {
                Assert.fail((String)("Editor is still open: " + FILES_DELETE[0] + EXTENSION));
            }
        });
        SWTBotUtils.pressOKishButtonInPreferences((SWTBot)bot);
    }

    @Test
    public void testImportValid() {
        SWTBot bot = XMLAnalysesManagerPreferencePageTest.openXMLAnalysesPreferences().bot();
        XMLAnalysesManagerPreferencePageTest.importAnalysis(bot, XMLAnalysesManagerPreferencePageTest.getRelativePaths(VALID_FILES_FOLDER, FILES_IMPORT_VALID));
        SWTBotTable tablebot = bot.table(0);
        String[] stringArray = FILES_IMPORT_VALID;
        int n = FILES_IMPORT_VALID.length;
        int n2 = 0;
        while (n2 < n) {
            String importedItem = stringArray[n2];
            tablebot.getTableItem(importedItem).select();
            Assert.assertTrue((boolean)bot.label("File enabled").isVisible());
            ++n2;
        }
        SWTBotUtils.pressOKishButtonInPreferences((SWTBot)bot);
    }

    @Test
    public void testImportInvalid() {
        SWTBot bot = XMLAnalysesManagerPreferencePageTest.openXMLAnalysesPreferences().bot();
        XMLAnalysesManagerPreferencePageTest.importAnalysis(bot, "test_xml_files/test_invalid/test_invalid.xml");
        SWTBotShell popupShell = bot.shell("Import XML analysis file failed.").activate();
        popupShell.bot().button("OK").click();
        SWTBotUtils.pressOKishButtonInPreferences((SWTBot)bot);
    }

    @Test
    public void testEdit() {
        SWTBot bot = XMLAnalysesManagerPreferencePageTest.openXMLAnalysesPreferences().bot();
        XMLAnalysesManagerPreferencePageTest.importAnalysis(bot, XMLAnalysesManagerPreferencePageTest.getRelativePaths(VALID_FILES_FOLDER, FILES_EDIT));
        SWTBotTable tablebot = bot.table(0);
        tablebot.select(FILES_EDIT);
        bot.button("Edit...").click();
        SWTBotUtils.pressOKishButtonInPreferences((SWTBot)bot);
        String[] stringArray = FILES_EDIT;
        int n = FILES_EDIT.length;
        int n2 = 0;
        while (n2 < n) {
            String editFile = stringArray[n2];
            fBot.editorByTitle(String.valueOf(editFile) + EXTENSION).isActive();
            ++n2;
        }
    }

    @Test
    public void testInvalidLabel() {
        XmlUtils.addXmlFile((File)Activator.getAbsolutePath((Path)new Path("test_xml_files/test_invalid/test_invalid.xml")).toFile());
        XmlAnalysisModuleSource.notifyModuleChange();
        SWTBot bot = XMLAnalysesManagerPreferencePageTest.openXMLAnalysesPreferences().bot();
        SWTBotTable tablebot = bot.table(0);
        SWTBotTableItem tableItem = tablebot.getTableItem(FILE_IMPORT_INVALID);
        tableItem.select();
        Assert.assertTrue((boolean)bot.label("Invalid file").isVisible());
        Assert.assertFalse((boolean)tableItem.isChecked());
        SWTBotUtils.pressOKishButtonInPreferences((SWTBot)bot);
    }

    @Test
    public void testCheckButtons() {
        SWTBot bot = XMLAnalysesManagerPreferencePageTest.openXMLAnalysesPreferences().bot();
        SWTBotTable tableBot = bot.table(0);
        int rowsCount = tableBot.rowCount();
        if (rowsCount > 0) {
            String[] itemNames = new String[rowsCount];
            int i = 0;
            while (i < rowsCount) {
                itemNames[i] = tableBot.getTableItem(i).getText();
                ++i;
            }
            tableBot.select(itemNames);
            bot.button("Delete").click();
            SWTBotShell deleteShell = bot.shell("Delete XML file").activate();
            deleteShell.bot().button("Yes").click();
        }
        int preRowCount = tableBot.rowCount();
        XMLAnalysesManagerPreferencePageTest.importAnalysis(bot, XMLAnalysesManagerPreferencePageTest.getRelativePaths(VALID_FILES_FOLDER, FILES_BUTTONS));
        int postRowCount = tableBot.rowCount();
        Assert.assertEquals((long)(preRowCount + FILES_BUTTONS.length), (long)postRowCount);
        int preCheckCount = SWTBotUtils.getTableCheckedItemCount((SWTBotTable)tableBot);
        int uncheckCount = 2;
        String[] toUncheck = Arrays.copyOfRange(FILES_BUTTONS, 0, uncheckCount);
        tableBot.select(toUncheck);
        bot.button(UNCHECK_SELECTED).click();
        int postCheckCount = SWTBotUtils.getTableCheckedItemCount((SWTBotTable)tableBot);
        Assert.assertEquals((String)UNCHECK_SELECTED, (long)(preCheckCount - uncheckCount), (long)postCheckCount);
        tableBot.select(toUncheck);
        bot.button(CHECK_SELECTED).click();
        postCheckCount = SWTBotUtils.getTableCheckedItemCount((SWTBotTable)tableBot);
        Assert.assertEquals((String)CHECK_SELECTED, (long)preCheckCount, (long)postCheckCount);
        bot.button(UNCHECK_ALL).click();
        postCheckCount = SWTBotUtils.getTableCheckedItemCount((SWTBotTable)tableBot);
        Assert.assertEquals((String)UNCHECK_ALL, (long)0L, (long)postCheckCount);
        bot.button(CHECK_ALL).click();
        postCheckCount = SWTBotUtils.getTableCheckedItemCount((SWTBotTable)tableBot);
        Assert.assertEquals((String)CHECK_ALL, (long)postRowCount, (long)postCheckCount);
        SWTBotUtils.pressOKishButtonInPreferences((SWTBot)bot);
    }

    @Test
    public void testExport() {
        SWTBot bot = XMLAnalysesManagerPreferencePageTest.openXMLAnalysesPreferences().bot();
        XMLAnalysesManagerPreferencePageTest.importAnalysis(bot, "test_xml_files/test_valid/state_provider_placement.xml");
        try {
            File targetFile = File.createTempFile(FILE_EXPORT, EXTENSION);
            TmfFileDialogFactory.setOverrideFiles((String[])new String[]{targetFile.getAbsolutePath()});
        }
        catch (IOException e) {
            Assert.fail((String)"Failed to export XML file state_provider_placement");
        }
        SWTBotTable tableBot = bot.table(0);
        tableBot.select(new String[]{FILE_EXPORT});
        bot.button("Export").click();
        SWTBotUtils.pressOKishButtonInPreferences((SWTBot)bot);
    }

    @After
    public void after() {
        SWTBotUtils.deleteProject((String)TRACE_PROJECT_NAME, (SWTWorkbenchBot)fBot);
        fBot.closeAllEditors();
    }

    @AfterClass
    public static void afterClass() {
        fLogger.removeAllAppenders();
    }

    private static String[] getRelativePaths(String folder, String[] files) {
        String[] relativePaths = new String[files.length];
        int i = 0;
        while (i < files.length) {
            relativePaths[i] = TEST_FILES_FOLDER + folder + files[i] + EXTENSION;
            ++i;
        }
        return relativePaths;
    }

    private static void importAnalysis(SWTBot bot, String ... relativePaths) {
        String[] absolutePaths = new String[relativePaths.length];
        int i = 0;
        while (i < relativePaths.length) {
            absolutePaths[i] = Activator.getAbsolutePath((Path)new Path(relativePaths[i])).toString();
            ++i;
        }
        TmfFileDialogFactory.setOverrideFiles((String[])absolutePaths);
        bot.button("Import").click();
        SWTBotUtils.waitUntil(tree -> tree.rowCount() > 0, (Object)bot.tree(0), (String)"Failed to import analysis");
    }

    private static SWTBotShell openXMLAnalysesPreferences() {
        SWTBotShell preferencesShell = SWTBotUtils.openPreferences((SWTBot)fBot, (String)"Manage XML analyses files");
        SWTBot bot = preferencesShell.bot();
        SWTBotTree tree = bot.tree(0);
        SWTBotTreeItem treeNode = tree.getTreeItem("Tracing");
        treeNode.select();
        treeNode.expand();
        bot.waitUntil(ConditionHelpers.IsTreeChildNodeAvailable((String)"XML Analyses", (SWTBotTreeItem)treeNode));
        treeNode = treeNode.getNode("XML Analyses");
        treeNode.select();
        return preferencesShell;
    }
}

