/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.chart.ui.swtbot.tests.shared;

import java.text.Format;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.matchers.AbstractMatcher;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotCheckBox;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.chart.ChartType;
import org.eclipse.tracecompass.internal.tmf.chart.ui.data.ChartRange;
import org.eclipse.tracecompass.internal.tmf.chart.ui.data.ChartRangeMap;
import org.eclipse.tracecompass.internal.tmf.chart.ui.format.ChartDecimalUnitFormat;
import org.eclipse.tracecompass.internal.tmf.chart.ui.format.ChartTimeStampFormat;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.ISeries;
import org.swtchart.ISeriesSet;

public final class SWTBotCustomChartUtils {
    public static final int CHART_TYPE_TABLE_INDEX = 0;
    public static final int SERIES_SELECTION_TABLE_INDEX = 1;
    public static final int X_SERIES_TABLE_INDEX = 2;
    public static final int Y_SERIES_TABLE_INDEX = 3;

    private SWTBotCustomChartUtils() {
    }

    private static void ensureDialogFocus(SWTWorkbenchBot bot) {
        bot.shell("Custom chart creation").activate();
    }

    public static void selectChartType(SWTWorkbenchBot bot, ChartType chartType) {
        SWTBotCustomChartUtils.ensureDialogFocus(bot);
        int index = 0;
        switch (chartType) {
            case BAR_CHART: {
                index = 0;
                break;
            }
            case SCATTER_CHART: {
                index = 1;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported chart type: " + chartType.name());
            }
        }
        SWTBotTable table = bot.table(0);
        table.click(index, 0);
    }

    public static void addSeries(SWTWorkbenchBot bot, String xSerie, Set<String> ySeries) {
        SWTBotCustomChartUtils.ensureDialogFocus(bot);
        SWTBotTable xTable = bot.table(2);
        xTable.getTableItem(xSerie).click();
        SWTBotTable yTable = bot.table(3);
        ySeries.forEach(s -> yTable.getTableItem(s).check());
        bot.buttonInGroup("Series Creator", 0).click();
    }

    public static void setLogScale(SWTWorkbenchBot bot, AxisType axisType) {
        SWTBotCustomChartUtils.ensureDialogFocus(bot);
        SWTBotCheckBox checkbox = bot.checkBox("Logarithmic Scale " + axisType.name());
        Assert.assertTrue((boolean)checkbox.isEnabled());
        checkbox.select();
    }

    public static void confirmDialog(SWTWorkbenchBot bot) {
        SWTBotCustomChartUtils.ensureDialogFocus(bot);
        bot.button("OK").click();
    }

    public static void closeChart(SWTWorkbenchBot bot, Chart customChart) {
        Button closeButton = (Button)bot.widget(SWTBotCustomChartUtils.closeButtonForChart(customChart), 0);
        SWTBotButton button = new SWTBotButton(closeButton);
        button.click();
    }

    private static Matcher<Button> closeButtonForChart(final Chart chart) {
        return new AbstractMatcher<Button>(){

            protected boolean doMatch(Object item) {
                if (!(item instanceof Button)) {
                    return false;
                }
                Button button = (Button)item;
                return button.getParent() == chart;
            }

            public void describeTo(Description description) {
                description.appendText("delete button for custom chart");
            }
        };
    }

    public static void assertTitles(Chart chart, String chartTitle, String xTitle, String yTitle) {
        String title = (String)UIThreadRunnable.syncExec(() -> chart.getTitle().getText());
        Assert.assertEquals((String)"Title", (Object)chartTitle, (Object)title);
        title = (String)UIThreadRunnable.syncExec(() -> chart.getAxisSet().getXAxis(0).getTitle().getText());
        Assert.assertEquals((String)"X axis title", (Object)xTitle, (Object)title);
        title = (String)UIThreadRunnable.syncExec(() -> chart.getAxisSet().getYAxis(0).getTitle().getText());
        Assert.assertEquals((String)"Y axis title", (Object)yTitle, (Object)title);
    }

    public static void assertAxisRange(Chart chart, AxisType axisType, Number min, Number max) {
        IAxis axis = axisType == AxisType.X ? chart.getAxisSet().getXAxes()[0] : chart.getAxisSet().getYAxes()[0];
        Format format = axis.getTick().getFormat();
        ChartRangeMap map = null;
        if (format instanceof ChartTimeStampFormat) {
            map = ((ChartTimeStampFormat)format).getRangeMap();
        } else if (format instanceof ChartDecimalUnitFormat) {
            map = ((ChartDecimalUnitFormat)format).getRangeMap();
        }
        Assert.assertNotNull((Object)map);
        ChartRange inputDataRange = map.getInputDataRange();
        Assert.assertEquals((double)min.doubleValue(), (double)inputDataRange.getMinimum().doubleValue(), (double)1.0);
        Assert.assertEquals((double)max.doubleValue(), (double)inputDataRange.getMaximum().doubleValue(), (double)1.0);
    }

    public static void assertCategoriesAxis(Chart chart, AxisType axisType, String[] categories) {
        IAxis axis = axisType == AxisType.X ? chart.getAxisSet().getXAxes()[0] : chart.getAxisSet().getYAxes()[0];
        Assert.assertTrue((boolean)axis.isCategoryEnabled());
        Object[] categorySeries = axis.getCategorySeries();
        Assert.assertArrayEquals((Object[])categories, (Object[])categorySeries);
    }

    public static void assertSeriesTitle(Chart customChart, List<String> titles) {
        ISeriesSet seriesSet = customChart.getSeriesSet();
        Assert.assertNotNull((Object)seriesSet);
        ISeries[] series = seriesSet.getSeries();
        Assert.assertEquals((long)titles.size(), (long)series.length);
        int i = 0;
        while (i < series.length) {
            Assert.assertEquals((String)("Series title " + i), (Object)titles.get(i), (Object)series[i].getId());
            ++i;
        }
    }

    public static void assertAxisLogscale(Chart chart, AxisType axisType, boolean logscale) {
        IAxis axis = axisType == AxisType.X ? chart.getAxisSet().getXAxes()[0] : chart.getAxisSet().getYAxes()[0];
        Assert.assertEquals((String)"Log scale", (Object)logscale, (Object)axis.isLogScaleEnabled());
    }

    public static enum AxisType {
        X,
        Y;

    }
}

