/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.remote.ui.swtbot.tests.fetch;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.varia.NullAppender;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.keyboard.Keystrokes;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotCombo;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.ctf.core.tests.shared.LttngTraceGenerator;
import org.eclipse.tracecompass.tmf.remote.ui.swtbot.tests.TmfRemoteUISWTBotTestPlugin;
import org.eclipse.tracecompass.tmf.ui.dialog.TmfFileDialogFactory;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class FetchRemoteTracesTest {
    private static final QualifiedName ORIGINAL = new QualifiedName("original", "original");
    private static final String AUTHENTICATION_SHELL_NAME = "Authentication Message";
    private static final String CONFIRMATION_SHELL_NAME = "Confirmation";
    private static final String CONNECTION_NODE1_NAME = "node1";
    private static final String CONNECTION_NODE2_NAME = "node2";
    private static final String CONNECTION_NODE_TEXT = "node1 (file://)";
    private static final String FETCH_COMMAND_NAME = "Fetch Remote Traces...";
    private static final String FETCH_SHELL_NAME = "Fetch Remote Traces";
    private static final String LTTNG_TRACE_FILE_PATTERN = ".*synthetic.*";
    private static final String PASSWORD_SHELL_NAME = "Password Required";
    private static final String PROFILE_NAME = "new profile";
    private static final String PROFILES_LOCATION;
    private static final String PROJECT_EXPLORER = "Project Explorer";
    private static final String PROJECT_NAME = "Test";
    private static final String SYSLOG_FILE_PATTERN = ".*syslog";
    private static final String WILDCARD_PATTERN = ".*";
    private static final String TRACE_GROUP_NODE_TEXT;
    private static final String TRACE_LOCATION;
    private static final String TRACE_TYPE_KERNEL = "org.eclipse.linuxtools.lttng2.kernel.tracetype";
    private static final String TRACE_TYPE_SYSLOG = "org.eclipse.linuxtools.tmf.tests.stubs.trace.text.testsyslog";
    private static final String WELCOME_NAME = "welcome";
    private static SWTWorkbenchBot fBot;
    private static final Logger fLogger;

    static {
        fLogger = Logger.getRootLogger();
        String traceLocation = "";
        String profilesLocation = "";
        try {
            Path resourcesPath = new Path("resources");
            File resourcesFile = FetchRemoteTracesTest.getBundleFile((IPath)resourcesPath);
            IPath subDirFullPath = new Path(resourcesFile.getAbsolutePath()).append("generated");
            File subDirFile = new File(subDirFullPath.toOSString());
            subDirFile.mkdir();
            IPath generatedTraceFullPath = subDirFullPath.append("synthetic-trace");
            File generatedTraceFile = new File(generatedTraceFullPath.toOSString());
            LttngTraceGenerator.generateLttngTrace((File)generatedTraceFile);
            traceLocation = new Path(resourcesFile.getAbsolutePath()).toString();
            profilesLocation = FetchRemoteTracesTest.getBundleFile((IPath)new Path("profiles/test-profiles.xml")).getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        TRACE_LOCATION = traceLocation;
        TRACE_GROUP_NODE_TEXT = String.valueOf(TRACE_LOCATION) + " (recursive)";
        PROFILES_LOCATION = profilesLocation;
    }

    private static File getBundleFile(IPath relativePath) throws URISyntaxException, IOException {
        return new File(FileLocator.toFileURL((URL)FileLocator.find((Bundle)TmfRemoteUISWTBotTestPlugin.getDefault().getBundle(), (IPath)relativePath, null)).toURI());
    }

    @BeforeClass
    public static void init() {
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        SWTBotUtils.initialize();
        SWTBotPreferences.TIMEOUT = 20000L;
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new NullAppender());
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.closeView((String)WELCOME_NAME, (SWTWorkbenchBot)fBot);
        SWTBotUtils.switchToTracingPerspective();
        WaitUtils.waitForJobs();
        FetchRemoteTracesTest.importProfiles();
    }

    @Before
    public void before() {
        SWTBotUtils.createProject((String)PROJECT_NAME);
        WaitUtils.waitForJobs();
    }

    @After
    public void after() {
        fBot.closeAllEditors();
        SWTBotUtils.deleteProject((String)PROJECT_NAME, (SWTWorkbenchBot)fBot);
    }

    @AfterClass
    public static void afterClass() {
        FetchRemoteTracesTest.clearProfiles();
        fLogger.removeAllAppenders();
    }

    @Test
    public void testImportAll() {
        FetchRemoteTracesTest.testImport(() -> {}, () -> {
            TmfProjectElement project = TmfProjectRegistry.getProject((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME), (boolean)true);
            fBot.waitUntil((ICondition)new TraceCountCondition(project, 3));
            TmfTraceFolder tracesFolder = project.getTracesFolder();
            Assert.assertNotNull((Object)tracesFolder);
            List traces = tracesFolder.getTraces();
            Assert.assertEquals((long)3L, (long)traces.size());
            FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(0), "node1/resources/generated/synthetic-trace", TRACE_TYPE_KERNEL);
            FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(1), "node1/resources/syslog", TRACE_TYPE_SYSLOG);
            FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(2), "node1/resources/unrecognized", null);
        });
    }

    @Test
    public void testImportOnlyOne() {
        FetchRemoteTracesTest.testImport(() -> {
            SWTBotTree tree = fBot.tree();
            fBot.button("Deselect All").click();
            int length = tree.getAllItems().length;
            Assert.assertTrue((length > 0 ? 1 : 0) != 0);
            SWTBotTreeItem node = FetchRemoteTracesTest.getTreeItem(fBot, tree, CONNECTION_NODE_TEXT, TRACE_GROUP_NODE_TEXT).getNode(1);
            Assert.assertEquals((Object)"syslog", (Object)node.getText());
            node.check();
        }, () -> {
            TmfProjectElement project = TmfProjectRegistry.getProject((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME), (boolean)true);
            fBot.waitUntil((ICondition)new TraceCountCondition(project, 1));
            TmfTraceFolder tracesFolder = project.getTracesFolder();
            Assert.assertNotNull((Object)tracesFolder);
            List traces = tracesFolder.getTraces();
            Assert.assertEquals((long)1L, (long)traces.size());
            FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(0), "node1/resources/syslog", TRACE_TYPE_SYSLOG);
        });
    }

    @Test
    public void testImportNothing() {
        FetchRemoteTracesTest.testImport(() -> fBot.button("Deselect All").click(), () -> {
            TmfProjectElement project = TmfProjectRegistry.getProject((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME), (boolean)true);
            TmfTraceFolder tracesFolder = project.getTracesFolder();
            Assert.assertNotNull((Object)tracesFolder);
            List traces = tracesFolder.getTraces();
            Assert.assertEquals((long)0L, (long)traces.size());
        });
    }

    @Test
    public void testEmptyFile() {
        FetchRemoteTracesTest.testImport(() -> {
            SWTBotTree tree = fBot.tree();
            fBot.button("Deselect All").click();
            int length = tree.getAllItems().length;
            Assert.assertTrue((length > 0 ? 1 : 0) != 0);
            SWTBotTreeItem groupNode = FetchRemoteTracesTest.getTreeItem(fBot, tree, CONNECTION_NODE_TEXT, TRACE_GROUP_NODE_TEXT);
            Assert.assertEquals((long)3L, (long)groupNode.getItems().length);
        }, () -> {
            TmfProjectElement project = TmfProjectRegistry.getProject((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME), (boolean)true);
            TmfTraceFolder tracesFolder = project.getTracesFolder();
            Assert.assertNotNull((Object)tracesFolder);
            List traces = tracesFolder.getTraces();
            Assert.assertEquals((long)0L, (long)traces.size());
        });
    }

    @Test
    public void test_7_03() {
        FetchRemoteTracesTest.openRemoteProfilePreferences();
        TmfFileDialogFactory.setOverrideFiles((String[])new String[]{PROFILES_LOCATION});
        fBot.button("Import").click();
        String errorMessage = fBot.text(1).getText();
        Assert.assertTrue((boolean)errorMessage.endsWith("Duplicate profile names"));
        Assert.assertTrue((!SWTBotUtils.anyButtonOf((SWTBot)fBot, (String[])new String[]{"Apply and Close", "OK"}).isEnabled() ? 1 : 0) != 0);
        fBot.button("Remove").click();
        SWTBotUtils.pressOKishButtonInPreferences((SWTBot)fBot);
    }

    @Test
    public void test_8_04() {
        SWTBotView projectExplorerBot = fBot.viewByTitle(PROJECT_EXPLORER);
        projectExplorerBot.show();
        SWTBotTreeItem tracesFolderItem = FetchRemoteTracesTest.getTracesFolderTreeItem(projectExplorerBot);
        tracesFolderItem.contextMenu(FETCH_COMMAND_NAME).click();
        SWTBotShell shell = fBot.shell(FETCH_SHELL_NAME).activate();
        fBot.comboBox().setSelection("TestAllRecursive");
        fBot.button("Next >").click();
        fBot.button("Finish").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        WaitUtils.waitForJobs();
        TmfProjectElement project = TmfProjectRegistry.getProject((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME), (boolean)true);
        fBot.waitUntil((ICondition)new TraceCountCondition(project, 3));
        TmfTraceFolder tracesFolder = project.getTracesFolder();
        Assert.assertNotNull((Object)tracesFolder);
        List traces = tracesFolder.getTraces();
        Assert.assertEquals((long)3L, (long)traces.size());
        FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(0), "node1/resources/generated/synthetic-trace", TRACE_TYPE_KERNEL);
        FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(1), "node1/resources/syslog", TRACE_TYPE_SYSLOG);
        FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(2), "node1/resources/unrecognized", null);
    }

    @Test
    public void test_8_05() {
        SWTBotView projectExplorerBot = fBot.viewByTitle(PROJECT_EXPLORER);
        projectExplorerBot.show();
        SWTBotTreeItem tracesFolderItem = FetchRemoteTracesTest.getTracesFolderTreeItem(projectExplorerBot);
        tracesFolderItem.contextMenu(FETCH_COMMAND_NAME).click();
        SWTBotShell shell = fBot.shell(FETCH_SHELL_NAME).activate();
        fBot.comboBox().setSelection("TestAllRecursive");
        fBot.button("Next >").click();
        fBot.button("Finish").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        WaitUtils.waitForJobs();
        tracesFolderItem.contextMenu(FETCH_COMMAND_NAME).click();
        shell = fBot.shell(FETCH_SHELL_NAME).activate();
        fBot.comboBox().setSelection("TestAllRecursive");
        fBot.button("Next >").click();
        fBot.button("Finish").click();
        fBot.shell(CONFIRMATION_SHELL_NAME).activate();
        fBot.button("Rename").click();
        fBot.shell(CONFIRMATION_SHELL_NAME).activate();
        fBot.button("Rename All").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        WaitUtils.waitForJobs();
        TmfProjectElement project = TmfProjectRegistry.getProject((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME), (boolean)true);
        fBot.waitUntil((ICondition)new TraceCountCondition(project, 6));
        TmfTraceFolder tracesFolder = project.getTracesFolder();
        Assert.assertNotNull((Object)tracesFolder);
        List traces = tracesFolder.getTraces();
        Assert.assertEquals((long)6L, (long)traces.size());
        FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(0), "node1/resources/generated/synthetic-trace", TRACE_TYPE_KERNEL);
        FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(1), "node1/resources/generated/synthetic-trace(2)", TRACE_TYPE_KERNEL);
        FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(2), "node1/resources/syslog", TRACE_TYPE_SYSLOG);
        FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(3), "node1/resources/unrecognized", null);
        FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(4), "node1/resources/syslog(2)", TRACE_TYPE_SYSLOG);
        FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(5), "node1/resources/unrecognized(2)", null);
    }

    @Test
    public void test_8_06() throws CoreException {
        SWTBotView projectExplorerBot = fBot.viewByTitle(PROJECT_EXPLORER);
        projectExplorerBot.show();
        SWTBotTreeItem tracesFolderItem = FetchRemoteTracesTest.getTracesFolderTreeItem(projectExplorerBot);
        tracesFolderItem.contextMenu(FETCH_COMMAND_NAME).click();
        SWTBotShell shell = fBot.shell(FETCH_SHELL_NAME).activate();
        fBot.comboBox().setSelection("TestAllRecursive");
        fBot.button("Next >").click();
        fBot.button("Finish").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        WaitUtils.waitForJobs();
        TmfProjectElement project = TmfProjectRegistry.getProject((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME), (boolean)true);
        fBot.waitUntil((ICondition)new TraceCountCondition(project, 3));
        TmfTraceFolder tracesFolder = project.getTracesFolder();
        Assert.assertNotNull((Object)tracesFolder);
        for (TmfTraceElement traceElement : tracesFolder.getTraces()) {
            traceElement.getResource().setPersistentProperty(ORIGINAL, Boolean.TRUE.toString());
        }
        tracesFolderItem.contextMenu(FETCH_COMMAND_NAME).click();
        shell = fBot.shell(FETCH_SHELL_NAME).activate();
        fBot.comboBox().setSelection("TestAllRecursive");
        fBot.button("Next >").click();
        fBot.button("Finish").click();
        fBot.shell(CONFIRMATION_SHELL_NAME).activate();
        fBot.button("Overwrite").click();
        fBot.shell(CONFIRMATION_SHELL_NAME).activate();
        fBot.button("Overwrite All").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        WaitUtils.waitForJobs();
        fBot.waitUntil((ICondition)new TraceCountCondition(project, 3));
        List traces = tracesFolder.getTraces();
        Assert.assertEquals((long)3L, (long)traces.size());
        FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(0), "node1/resources/generated/synthetic-trace", TRACE_TYPE_KERNEL);
        FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(1), "node1/resources/syslog", TRACE_TYPE_SYSLOG);
        FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(2), "node1/resources/unrecognized", null);
        for (TmfTraceElement traceElement : traces) {
            Assert.assertNull((Object)traceElement.getResource().getPersistentProperty(ORIGINAL));
        }
    }

    @Test
    public void test_8_07() throws CoreException {
        SWTBotView projectExplorerBot = fBot.viewByTitle(PROJECT_EXPLORER);
        projectExplorerBot.show();
        SWTBotTreeItem tracesFolderItem = FetchRemoteTracesTest.getTracesFolderTreeItem(projectExplorerBot);
        tracesFolderItem.contextMenu(FETCH_COMMAND_NAME).click();
        SWTBotShell shell = fBot.shell(FETCH_SHELL_NAME).activate();
        fBot.comboBox().setSelection("TestAllRecursive");
        fBot.button("Next >").click();
        fBot.button("Finish").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        WaitUtils.waitForJobs();
        TmfProjectElement project = TmfProjectRegistry.getProject((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME), (boolean)true);
        fBot.waitUntil((ICondition)new TraceCountCondition(project, 3));
        TmfTraceFolder tracesFolder = project.getTracesFolder();
        Assert.assertNotNull((Object)tracesFolder);
        for (TmfTraceElement traceElement : tracesFolder.getTraces()) {
            traceElement.getResource().setPersistentProperty(ORIGINAL, Boolean.TRUE.toString());
        }
        tracesFolderItem.contextMenu(FETCH_COMMAND_NAME).click();
        shell = fBot.shell(FETCH_SHELL_NAME).activate();
        fBot.comboBox().setSelection("TestAllRecursive");
        fBot.button("Next >").click();
        fBot.button("Finish").click();
        fBot.shell(CONFIRMATION_SHELL_NAME).activate();
        fBot.button("Skip").click();
        fBot.shell(CONFIRMATION_SHELL_NAME).activate();
        fBot.button("Skip All").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        WaitUtils.waitForJobs();
        fBot.waitUntil((ICondition)new TraceCountCondition(project, 3));
        Assert.assertNotNull((Object)tracesFolder);
        List traces = tracesFolder.getTraces();
        Assert.assertEquals((long)3L, (long)traces.size());
        FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(0), "node1/resources/generated/synthetic-trace", TRACE_TYPE_KERNEL);
        FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(1), "node1/resources/syslog", TRACE_TYPE_SYSLOG);
        FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(2), "node1/resources/unrecognized", null);
        for (TmfTraceElement traceElement : traces) {
            Assert.assertNotNull((Object)traceElement.getResource().getPersistentProperty(ORIGINAL));
        }
    }

    @Test
    public void test_8_08() throws CoreException {
        SWTBotView projectExplorerBot = fBot.viewByTitle(PROJECT_EXPLORER);
        projectExplorerBot.show();
        SWTBotTreeItem tracesFolderItem = FetchRemoteTracesTest.getTracesFolderTreeItem(projectExplorerBot);
        tracesFolderItem.contextMenu(FETCH_COMMAND_NAME).click();
        SWTBotShell shell = fBot.shell(FETCH_SHELL_NAME).activate();
        fBot.comboBox().setSelection("TestAllRecursive");
        fBot.button("Next >").click();
        fBot.button("Finish").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        WaitUtils.waitForJobs();
        TmfProjectElement project = TmfProjectRegistry.getProject((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME), (boolean)true);
        fBot.waitUntil((ICondition)new TraceCountCondition(project, 3));
        TmfTraceFolder tracesFolder = project.getTracesFolder();
        Assert.assertNotNull((Object)tracesFolder);
        for (TmfTraceElement traceElement : tracesFolder.getTraces()) {
            traceElement.getResource().setPersistentProperty(ORIGINAL, Boolean.TRUE.toString());
        }
        tracesFolderItem.contextMenu(FETCH_COMMAND_NAME).click();
        shell = fBot.shell(FETCH_SHELL_NAME).activate();
        fBot.comboBox().setSelection("TestAllRecursive");
        fBot.checkBox("Overwrite existing trace without warning").select();
        fBot.button("Next >").click();
        fBot.button("Finish").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        WaitUtils.waitForJobs();
        fBot.waitUntil((ICondition)new TraceCountCondition(project, 3));
        Assert.assertNotNull((Object)tracesFolder);
        List traces = tracesFolder.getTraces();
        Assert.assertEquals((long)3L, (long)traces.size());
        FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(0), "node1/resources/generated/synthetic-trace", TRACE_TYPE_KERNEL);
        FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(1), "node1/resources/syslog", TRACE_TYPE_SYSLOG);
        FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(2), "node1/resources/unrecognized", null);
        for (TmfTraceElement traceElement : traces) {
            Assert.assertNull((Object)traceElement.getResource().getPersistentProperty(ORIGINAL));
        }
    }

    @Test
    public void test_8_09() {
        SWTBotView projectExplorerBot = fBot.viewByTitle(PROJECT_EXPLORER);
        projectExplorerBot.show();
        SWTBotTreeItem tracesFolderItem = FetchRemoteTracesTest.getTracesFolderTreeItem(projectExplorerBot);
        tracesFolderItem.contextMenu(FETCH_COMMAND_NAME).click();
        SWTBotShell shell = fBot.shell(FETCH_SHELL_NAME).activate();
        fBot.comboBox().setSelection("TestAllRecursive");
        fBot.button("Finish").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        WaitUtils.waitForJobs();
        TmfProjectElement project = TmfProjectRegistry.getProject((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME), (boolean)true);
        fBot.waitUntil((ICondition)new TraceCountCondition(project, 3));
        TmfTraceFolder tracesFolder = project.getTracesFolder();
        Assert.assertNotNull((Object)tracesFolder);
        List traces = tracesFolder.getTraces();
        Assert.assertEquals((long)3L, (long)traces.size());
        FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(0), "node1/resources/generated/synthetic-trace", TRACE_TYPE_KERNEL);
        FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(1), "node1/resources/syslog", TRACE_TYPE_SYSLOG);
        FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(2), "node1/resources/unrecognized", null);
    }

    @Test
    public void test_8_10() {
        SWTBotView projectExplorerBot = fBot.viewByTitle(PROJECT_EXPLORER);
        projectExplorerBot.show();
        SWTBotTreeItem tracesFolderItem = FetchRemoteTracesTest.getTracesFolderTreeItem(projectExplorerBot);
        tracesFolderItem.contextMenu(FETCH_COMMAND_NAME).click();
        SWTBotShell shell = fBot.shell(FETCH_SHELL_NAME).activate();
        fBot.comboBox().setSelection("TestAllNonRecursive");
        fBot.button("Next >").click();
        fBot.button("Finish").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        WaitUtils.waitForJobs();
        TmfProjectElement project = TmfProjectRegistry.getProject((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME), (boolean)true);
        fBot.waitUntil((ICondition)new TraceCountCondition(project, 2));
        TmfTraceFolder tracesFolder = project.getTracesFolder();
        Assert.assertNotNull((Object)tracesFolder);
        List traces = tracesFolder.getTraces();
        Assert.assertEquals((long)2L, (long)traces.size());
        FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(0), "node1/resources/syslog", TRACE_TYPE_SYSLOG);
        FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(1), "node1/resources/unrecognized", null);
    }

    @Test
    public void test_8_11() {
        SWTBotView projectExplorerBot = fBot.viewByTitle(PROJECT_EXPLORER);
        projectExplorerBot.show();
        SWTBotTreeItem tracesFolderItem = FetchRemoteTracesTest.getTracesFolderTreeItem(projectExplorerBot);
        tracesFolderItem.contextMenu(FETCH_COMMAND_NAME).click();
        SWTBotShell shell = fBot.shell(FETCH_SHELL_NAME).activate();
        fBot.comboBox().setSelection("TestSpecificRecursive");
        fBot.button("Next >").click();
        fBot.button("Finish").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        WaitUtils.waitForJobs();
        TmfProjectElement project = TmfProjectRegistry.getProject((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME), (boolean)true);
        fBot.waitUntil((ICondition)new TraceCountCondition(project, 2));
        TmfTraceFolder tracesFolder = project.getTracesFolder();
        Assert.assertNotNull((Object)tracesFolder);
        List traces = tracesFolder.getTraces();
        Assert.assertEquals((long)2L, (long)traces.size());
        FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(0), "node1/resources/generated/synthetic-trace", TRACE_TYPE_KERNEL);
        FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(1), "node1/resources/syslog", TRACE_TYPE_SYSLOG);
    }

    @Test
    public void test_8_12() {
        SWTBotView projectExplorerBot = fBot.viewByTitle(PROJECT_EXPLORER);
        projectExplorerBot.show();
        SWTBotTreeItem tracesFolderItem = FetchRemoteTracesTest.getTracesFolderTreeItem(projectExplorerBot);
        tracesFolderItem.contextMenu(FETCH_COMMAND_NAME).click();
        SWTBotShell shell = fBot.shell(FETCH_SHELL_NAME).activate();
        fBot.comboBox().setSelection("TestSpecificNonRecursive");
        fBot.button("Next >").click();
        fBot.button("Finish").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        WaitUtils.waitForJobs();
        TmfProjectElement project = TmfProjectRegistry.getProject((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME), (boolean)true);
        fBot.waitUntil((ICondition)new TraceCountCondition(project, 1));
        TmfTraceFolder tracesFolder = project.getTracesFolder();
        Assert.assertNotNull((Object)tracesFolder);
        List traces = tracesFolder.getTraces();
        Assert.assertEquals((long)1L, (long)traces.size());
        FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(0), "node1/resources/syslog", TRACE_TYPE_SYSLOG);
    }

    @Test
    public void test_8_13() {
        SWTBotView projectExplorerBot = fBot.viewByTitle(PROJECT_EXPLORER);
        projectExplorerBot.show();
        SWTBotTreeItem tracesFolderItem = FetchRemoteTracesTest.getTracesFolderTreeItem(projectExplorerBot);
        tracesFolderItem.contextMenu(FETCH_COMMAND_NAME).click();
        SWTBotShell shell = fBot.shell(FETCH_SHELL_NAME).activate();
        fBot.comboBox().setSelection("TestSpecificMultiGroupRecursive");
        fBot.button("Next >").click();
        fBot.button("Finish").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        WaitUtils.waitForJobs();
        TmfProjectElement project = TmfProjectRegistry.getProject((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME), (boolean)true);
        fBot.waitUntil((ICondition)new TraceCountCondition(project, 2));
        TmfTraceFolder tracesFolder = project.getTracesFolder();
        Assert.assertNotNull((Object)tracesFolder);
        List traces = tracesFolder.getTraces();
        Assert.assertEquals((long)2L, (long)traces.size());
        FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(0), "node1/resources/generated/synthetic-trace", TRACE_TYPE_KERNEL);
        FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(1), "node1/resources/syslog", TRACE_TYPE_SYSLOG);
    }

    @Test
    public void test_8_14() {
        SWTBotView projectExplorerBot = fBot.viewByTitle(PROJECT_EXPLORER);
        projectExplorerBot.show();
        SWTBotTreeItem tracesFolderItem = FetchRemoteTracesTest.getTracesFolderTreeItem(projectExplorerBot);
        tracesFolderItem.contextMenu(FETCH_COMMAND_NAME).click();
        SWTBotShell shell = fBot.shell(FETCH_SHELL_NAME).activate();
        fBot.comboBox().setSelection("TestAllRecursive");
        fBot.button("Next >").click();
        fBot.button("Finish").click();
        fBot.button("Cancel").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        WaitUtils.waitForJobs();
    }

    @Test
    public void test_8_15() {
        SWTBotView projectExplorerBot = fBot.viewByTitle(PROJECT_EXPLORER);
        projectExplorerBot.show();
        SWTBotTreeItem tracesFolderItem = FetchRemoteTracesTest.getTracesFolderTreeItem(projectExplorerBot);
        tracesFolderItem.contextMenu(FETCH_COMMAND_NAME).click();
        SWTBotShell shell = fBot.shell(FETCH_SHELL_NAME).activate();
        fBot.comboBox().setSelection("TestMultiNode");
        fBot.button("Next >").click();
        fBot.button("Finish").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        WaitUtils.waitForJobs();
        TmfProjectElement project = TmfProjectRegistry.getProject((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME), (boolean)true);
        fBot.waitUntil((ICondition)new TraceCountCondition(project, 2));
        TmfTraceFolder tracesFolder = project.getTracesFolder();
        Assert.assertNotNull((Object)tracesFolder);
        List traces = tracesFolder.getTraces();
        Assert.assertEquals((long)2L, (long)traces.size());
        FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(0), "node1/resources/generated/synthetic-trace", TRACE_TYPE_KERNEL);
        FetchRemoteTracesTest.testTrace((TmfTraceElement)traces.get(1), "node2/resources/syslog", TRACE_TYPE_SYSLOG);
    }

    @Test
    public void test_9_01() {
        SWTBotView projectExplorerBot = fBot.viewByTitle(PROJECT_EXPLORER);
        projectExplorerBot.show();
        SWTBotTreeItem tracesFolderItem = FetchRemoteTracesTest.getTracesFolderTreeItem(projectExplorerBot);
        tracesFolderItem.contextMenu(FETCH_COMMAND_NAME).click();
        SWTBotShell shell = fBot.shell(FETCH_SHELL_NAME).activate();
        fBot.comboBox().setSelection("TestUnknown");
        fBot.button("Finish").click();
        fBot.button("Cancel").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        WaitUtils.waitForJobs();
    }

    @Test
    @Ignore
    public void test_9_02() {
        SWTBotView projectExplorerBot = fBot.viewByTitle(PROJECT_EXPLORER);
        projectExplorerBot.show();
        SWTBotTreeItem tracesFolderItem = FetchRemoteTracesTest.getTracesFolderTreeItem(projectExplorerBot);
        tracesFolderItem.contextMenu(FETCH_COMMAND_NAME).click();
        SWTBotShell shell = fBot.shell(FETCH_SHELL_NAME).activate();
        fBot.comboBox().setSelection("TestLocal");
        fBot.button("Finish").click();
        SWTBotShell anyShell = SWTBotUtils.anyShellOf((SWTBot)fBot, (String[])new String[]{AUTHENTICATION_SHELL_NAME, PASSWORD_SHELL_NAME}).activate();
        if (anyShell.getText().equals(AUTHENTICATION_SHELL_NAME)) {
            fBot.button("Yes").click();
        }
        fBot.shell(PASSWORD_SHELL_NAME).activate();
        fBot.textWithLabel("Password:").setText("anonymous");
        fBot.button("OK").click();
        fBot.shell(PASSWORD_SHELL_NAME).activate();
        fBot.button("Cancel").click();
        fBot.button("Cancel").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        WaitUtils.waitForJobs();
    }

    @Test
    public void testEditProfile() {
        FetchRemoteTracesTest.openRemoteProfilePreferences();
        FetchRemoteTracesTest.createProfile();
        FetchRemoteTracesTest.openRemoteProfilePreferences();
        SWTBotTree tree = fBot.tree(1);
        String[] traceGroupNodePath = new String[]{PROFILE_NAME, CONNECTION_NODE_TEXT, TRACE_GROUP_NODE_TEXT};
        SWTBotTreeItem traceGroupNode = FetchRemoteTracesTest.getTreeItem(fBot, tree, traceGroupNodePath);
        SWTBotTreeItem[] traceNodes = traceGroupNode.getItems();
        Assert.assertEquals((long)3L, (long)traceNodes.length);
        Assert.assertEquals((Object)LTTNG_TRACE_FILE_PATTERN, (Object)traceNodes[0].getText());
        Assert.assertEquals((Object)SYSLOG_FILE_PATTERN, (Object)traceNodes[1].getText());
        Assert.assertEquals((Object)WILDCARD_PATTERN, (Object)traceNodes[2].getText());
        SWTBotTreeItem traceNode = traceGroupNode.getNode(LTTNG_TRACE_FILE_PATTERN);
        traceNode.select();
        fBot.button("Move Down").click();
        traceGroupNode = FetchRemoteTracesTest.getTreeItem(fBot, tree, traceGroupNodePath);
        traceNodes = traceGroupNode.getItems();
        Assert.assertEquals((long)3L, (long)traceNodes.length);
        Assert.assertEquals((Object)SYSLOG_FILE_PATTERN, (Object)traceNodes[0].getText());
        Assert.assertEquals((Object)LTTNG_TRACE_FILE_PATTERN, (Object)traceNodes[1].getText());
        Assert.assertEquals((Object)WILDCARD_PATTERN, (Object)traceNodes[2].getText());
        traceNode = traceGroupNode.getNode(LTTNG_TRACE_FILE_PATTERN);
        traceNode.select();
        fBot.button("Move Up").click();
        traceGroupNode = FetchRemoteTracesTest.getTreeItem(fBot, tree, traceGroupNodePath);
        traceNodes = traceGroupNode.getItems();
        Assert.assertEquals((long)3L, (long)traceNodes.length);
        Assert.assertEquals((Object)LTTNG_TRACE_FILE_PATTERN, (Object)traceNodes[0].getText());
        Assert.assertEquals((Object)SYSLOG_FILE_PATTERN, (Object)traceNodes[1].getText());
        Assert.assertEquals((Object)WILDCARD_PATTERN, (Object)traceNodes[2].getText());
        traceNode = traceGroupNode.getNode(LTTNG_TRACE_FILE_PATTERN);
        traceNode.select().contextMenu("Copy").click();
        traceNode.contextMenu("Paste").click();
        traceNodes = traceGroupNode.getItems();
        Assert.assertEquals((long)4L, (long)traceNodes.length);
        Assert.assertEquals((Object)LTTNG_TRACE_FILE_PATTERN, (Object)traceNodes[0].getText());
        Assert.assertEquals((Object)LTTNG_TRACE_FILE_PATTERN, (Object)traceNodes[1].getText());
        Assert.assertEquals((Object)SYSLOG_FILE_PATTERN, (Object)traceNodes[2].getText());
        Assert.assertEquals((Object)WILDCARD_PATTERN, (Object)traceNodes[3].getText());
        traceNode = traceGroupNode.getNode(LTTNG_TRACE_FILE_PATTERN);
        traceNode.select().contextMenu("Cut").click();
        traceNode = traceGroupNode.getNode(SYSLOG_FILE_PATTERN);
        traceNode.select().contextMenu("Paste").click();
        traceNodes = traceGroupNode.getItems();
        Assert.assertEquals((long)4L, (long)traceNodes.length);
        Assert.assertEquals((Object)LTTNG_TRACE_FILE_PATTERN, (Object)traceNodes[0].getText());
        Assert.assertEquals((Object)SYSLOG_FILE_PATTERN, (Object)traceNodes[1].getText());
        Assert.assertEquals((Object)LTTNG_TRACE_FILE_PATTERN, (Object)traceNodes[2].getText());
        Assert.assertEquals((Object)WILDCARD_PATTERN, (Object)traceNodes[3].getText());
        traceNode = traceGroupNode.getNode(LTTNG_TRACE_FILE_PATTERN);
        traceNode.select().contextMenu("Delete").click();
        traceNodes = traceGroupNode.getItems();
        Assert.assertEquals((long)3L, (long)traceNodes.length);
        Assert.assertEquals((Object)SYSLOG_FILE_PATTERN, (Object)traceNodes[0].getText());
        Assert.assertEquals((Object)LTTNG_TRACE_FILE_PATTERN, (Object)traceNodes[1].getText());
        Assert.assertEquals((Object)WILDCARD_PATTERN, (Object)traceNodes[2].getText());
        traceNode = traceGroupNode.getNode(LTTNG_TRACE_FILE_PATTERN);
        traceNode.select().contextMenu("Copy").click();
        traceNode = traceGroupNode.select(new String[]{SYSLOG_FILE_PATTERN, LTTNG_TRACE_FILE_PATTERN, WILDCARD_PATTERN});
        traceNode.pressShortcut(new KeyStroke[]{Keystrokes.DELETE});
        traceNodes = traceGroupNode.getItems();
        Assert.assertEquals((long)0L, (long)traceNodes.length);
        traceGroupNode.contextMenu("Paste").click();
        traceNodes = traceGroupNode.getItems();
        Assert.assertEquals((long)1L, (long)traceNodes.length);
        Assert.assertEquals((Object)LTTNG_TRACE_FILE_PATTERN, (Object)traceNodes[0].getText());
        SWTBotUtils.pressOKishButtonInPreferences((SWTBot)fBot);
        FetchRemoteTracesTest.deleteProfile();
    }

    private static void testImport(Runnable selectionFunctor, Runnable verifyTracesFunctor) {
        SWTBotView projectExplorerBot = fBot.viewByTitle(PROJECT_EXPLORER);
        Assert.assertNotNull((String)"Cannot find Project Explorer", (Object)projectExplorerBot);
        projectExplorerBot.show();
        SWTBotTreeItem treeItem = FetchRemoteTracesTest.getTracesFolderTreeItem(projectExplorerBot);
        treeItem.contextMenu(FETCH_COMMAND_NAME).click();
        SWTBotShell shell = fBot.shell(FETCH_SHELL_NAME).activate();
        fBot.button("Manage Profiles").click();
        fBot.shell("Preferences (Filtered)").activate();
        FetchRemoteTracesTest.createProfile();
        Assert.assertEquals((Object)PROFILE_NAME, (Object)fBot.comboBoxWithLabel("Profile name:").getText());
        Assert.assertEquals((Object)CONNECTION_NODE_TEXT, (Object)fBot.textWithLabel("Nodes:").getText());
        fBot.button("Next >").click();
        fBot.button("< Back").click();
        Assert.assertEquals((Object)PROFILE_NAME, (Object)fBot.comboBoxWithLabel("Profile name:").getText());
        Assert.assertEquals((Object)CONNECTION_NODE_TEXT, (Object)fBot.textWithLabel("Nodes:").getText());
        fBot.button("Next >").click();
        selectionFunctor.run();
        fBot.button("Finish").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        WaitUtils.waitForJobs();
        verifyTracesFunctor.run();
        FetchRemoteTracesTest.deleteProfile();
    }

    private static void createProfile() {
        fBot.button("Add").click();
        SWTBotTree tree = fBot.tree(1);
        SWTBotTreeItem treeNode = FetchRemoteTracesTest.getTreeItem(fBot, tree, PROFILE_NAME, "name (ssh://userinfo@host:22)");
        treeNode.select();
        SWTBotText uriLabel = fBot.textWithLabel("URI:");
        uriLabel.setText("file://");
        SWTBotText nodeNameLabel = fBot.textWithLabel("Node name:");
        nodeNameLabel.setText(CONNECTION_NODE1_NAME);
        SWTBotTreeItem traceRootNode = treeNode.getNode("/rootpath");
        traceRootNode.select();
        SWTBotText pathLabel = fBot.textWithLabel("Root path:");
        pathLabel.setText(TRACE_LOCATION);
        fBot.checkBox("Recursive").select();
        treeNode = traceRootNode.getNode(WILDCARD_PATTERN);
        treeNode.select();
        SWTBotText filePatternLabel = fBot.textWithLabel("File pattern:");
        filePatternLabel.setText(LTTNG_TRACE_FILE_PATTERN);
        traceRootNode.contextMenu("New Trace").click();
        treeNode = traceRootNode.getNode(WILDCARD_PATTERN);
        treeNode.select();
        filePatternLabel = fBot.textWithLabel("File pattern:");
        filePatternLabel.setText(SYSLOG_FILE_PATTERN);
        SWTBotCombo combo = fBot.comboBoxWithLabel("Trace type:");
        combo.setSelection("Test trace : Test Syslog");
        traceRootNode.contextMenu("New Trace").click();
        SWTBotUtils.pressOKishButtonInPreferences((SWTBot)fBot);
    }

    private static void testTrace(TmfTraceElement tmfTraceElement, String expectedTracePath, String traceType) {
        Assert.assertEquals((Object)traceType, (Object)tmfTraceElement.getTraceType());
        Path tracePath = new Path(tmfTraceElement.getElementPath());
        Assert.assertEquals((Object)expectedTracePath, (Object)tracePath.toString());
        if (traceType != null) {
            SWTBotUtils.openEditor((SWTWorkbenchBot)fBot, (String)PROJECT_NAME, (IPath)tracePath);
        }
    }

    private static void deleteProfile() {
        FetchRemoteTracesTest.openRemoteProfilePreferences();
        SWTBotTree tree = fBot.tree(1);
        SWTBotTreeItem treeNode = tree.getTreeItem(PROFILE_NAME);
        treeNode.select();
        fBot.button("Remove").click();
        SWTBotUtils.pressOKishButtonInPreferences((SWTBot)fBot);
    }

    private static void importProfiles() {
        FetchRemoteTracesTest.openRemoteProfilePreferences();
        TmfFileDialogFactory.setOverrideFiles((String[])new String[]{PROFILES_LOCATION});
        fBot.button("Import").click();
        SWTBotTree tree = fBot.tree(1);
        SWTBotTreeItem[] sWTBotTreeItemArray = tree.getAllItems();
        int n = sWTBotTreeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotTreeItem profile = sWTBotTreeItemArray[n2];
            SWTBotTreeItem[] sWTBotTreeItemArray2 = profile.getItems();
            int n3 = sWTBotTreeItemArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                SWTBotTreeItem node = sWTBotTreeItemArray2[n4];
                SWTBotTreeItem[] sWTBotTreeItemArray3 = node.getItems();
                int n5 = sWTBotTreeItemArray3.length;
                int n6 = 0;
                while (n6 < n5) {
                    SWTBotTreeItem traceGroup = sWTBotTreeItemArray3[n6];
                    traceGroup.select();
                    fBot.textWithLabel("Root path:").setText(TRACE_LOCATION);
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        SWTBotUtils.pressOKishButtonInPreferences((SWTBot)fBot);
    }

    private static void clearProfiles() {
        FetchRemoteTracesTest.openRemoteProfilePreferences();
        SWTBotTree tree = fBot.tree(1);
        SWTBotTreeItem[] sWTBotTreeItemArray = tree.getAllItems();
        int n = sWTBotTreeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotTreeItem profile = sWTBotTreeItemArray[n2];
            profile.select();
            fBot.button("Remove").click();
            ++n2;
        }
        SWTBotUtils.pressOKishButtonInPreferences((SWTBot)fBot);
    }

    private static SWTBotTreeItem getTreeItem(SWTWorkbenchBot bot, SWTBotTree tree, String ... nodeNames) {
        if (nodeNames.length == 0) {
            return null;
        }
        SWTBotTreeItem currentNode = tree.getTreeItem(nodeNames[0]);
        int i = 1;
        while (i < nodeNames.length) {
            SWTBotTreeItem newNode;
            String nodeName = nodeNames[i];
            bot.waitUntil(ConditionHelpers.IsTreeChildNodeAvailable((String)nodeName, (SWTBotTreeItem)currentNode));
            currentNode = newNode = currentNode.getNode(nodeName);
            ++i;
        }
        return currentNode;
    }

    private static void openRemoteProfilePreferences() {
        SWTBotShell preferencesShell = SWTBotUtils.openPreferences((SWTBot)fBot);
        SWTBot bot = preferencesShell.bot();
        SWTBotTree tree = bot.tree(0);
        SWTBotTreeItem treeNode = tree.getTreeItem("Tracing");
        treeNode.select();
        treeNode.expand();
        bot.waitUntil(ConditionHelpers.IsTreeChildNodeAvailable((String)"Remote Profiles", (SWTBotTreeItem)treeNode));
        treeNode = treeNode.getNode("Remote Profiles");
        treeNode.select();
    }

    private static SWTBotTreeItem getTracesFolderTreeItem(SWTBotView projectExplorerBot) {
        SWTBotTreeItem treeItem = projectExplorerBot.bot().tree().getTreeItem(PROJECT_NAME);
        treeItem.select();
        treeItem.expand();
        return treeItem.getNode("Traces [0]");
    }

    private static class TraceCountCondition
    extends DefaultCondition {
        private final TmfProjectElement fProject;
        private final int fExpectedCount;

        public TraceCountCondition(TmfProjectElement project, int expectedNumber) {
            this.fProject = project;
            this.fExpectedCount = expectedNumber;
        }

        public boolean test() throws Exception {
            TmfTraceFolder tracesFolder = this.fProject.getTracesFolder();
            return tracesFolder != null && tracesFolder.getTraces().size() == this.fExpectedCount;
        }

        public String getFailureMessage() {
            return NLS.bind((String)"The project {0} does not contain {1} traces.", (Object)this.fProject.getName(), (Object)this.fExpectedCount);
        }
    }
}

