/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser.FilterExpression;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser.FilterExpressionNotCu;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser.FilterSimpleExpression;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser.FilterSimpleExpressionCu;

public class FilterExpressionCu {
    private List<Object> fElements;

    public FilterExpressionCu(List<Object> elements) {
        this.fElements = elements;
    }

    public List<Object> getElement() {
        return this.fElements;
    }

    public static @Nullable FilterExpressionCu compile(CommonTree treeNode) {
        int childCount = treeNode.getChildCount();
        if (childCount % 2 != 1) {
            return null;
        }
        ArrayList<Object> elements = new ArrayList<Object>();
        int i = 0;
        while (i < childCount) {
            if (i % 2 == 0) {
                CommonTree nodeTree = (CommonTree)treeNode.getChild(i);
                int subChildCount = nodeTree.getChildCount();
                if (nodeTree.getType() == 16) {
                    FilterExpressionCu cu;
                    boolean negate = nodeTree.getChild(0).getText().equals("!");
                    CommonTree logical = Objects.requireNonNull((CommonTree)nodeTree.getChild(subChildCount - 2));
                    FilterExpressionCu filterExpressionCu = cu = negate ? FilterExpressionNotCu.compile(logical) : FilterExpressionCu.compile(logical);
                    if (cu == null) {
                        return null;
                    }
                    elements.add(cu);
                } else if (nodeTree.getType() == 17) {
                    FilterSimpleExpressionCu node = FilterSimpleExpressionCu.compile(nodeTree);
                    if (node == null) {
                        return null;
                    }
                    elements.add(node);
                }
            } else {
                CommonTree opTree = (CommonTree)treeNode.getChild(i);
                String op = opTree.getText();
                elements.add(Objects.requireNonNull(op));
            }
            ++i;
        }
        return new FilterExpressionCu(elements);
    }

    public FilterExpression generate() {
        Queue<Object> queue = this.getElementsQueue();
        return new FilterExpression(queue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final Queue<Object> getElementsQueue() {
        LinkedList<Object> queue = new LinkedList<Object>();
        int count = this.fElements.size();
        int i = 0;
        while (i < count) {
            if (i % 2 == 0) {
                Object element = this.fElements.get(i);
                if (element instanceof FilterSimpleExpressionCu) {
                    FilterSimpleExpression filterSimpleExpression = ((FilterSimpleExpressionCu)element).generate();
                    queue.offer(filterSimpleExpression);
                } else {
                    if (!(element instanceof FilterExpressionCu)) throw new IllegalStateException("Unknown element while getting the filter element queue");
                    FilterExpression filterExpression = ((FilterExpressionCu)element).generate();
                    queue.offer(filterExpression);
                }
            } else {
                Object op = this.fElements.get(i);
                if (!(op instanceof String)) {
                    throw new IllegalStateException("Element at position " + i + " should be a String");
                }
                queue.offer(op);
            }
            ++i;
        }
        return queue;
    }
}

