/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore;

import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.statistics.AbstractSegmentStatisticsAnalysis;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.SegmentStoreStatisticsDataProvider;
import org.eclipse.tracecompass.internal.tmf.core.model.tree.TmfTreeCompositeDataProvider;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.segment.interfaces.INamedSegment;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderFactory;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;

public class SegmentStoreStatisticsDataProviderFactory
implements IDataProviderFactory {
    public @Nullable ITmfTreeDataProvider<? extends ITmfTreeDataModel> createProvider(ITmfTrace trace) {
        return null;
    }

    public @Nullable ITmfTreeDataProvider<? extends ITmfTreeDataModel> createProvider(ITmfTrace trace, String secondaryId) {
        IAnalysisModule m = trace.getAnalysisModule(secondaryId);
        String composedId = "org.eclipse.tracecompass.analysis.timing.core.segmentstore.SegmentStoreStatisticsDataProvider:" + secondaryId;
        if (!(m instanceof ISegmentStoreProvider)) {
            if (!(trace instanceof TmfExperiment)) {
                return null;
            }
            return TmfTreeCompositeDataProvider.create((Collection)TmfTraceManager.getTraceSet((ITmfTrace)trace), (String)composedId);
        }
        m.schedule();
        GenericSegmentStatisticsAnalysis module = new GenericSegmentStatisticsAnalysis(secondaryId);
        try {
            module.setTrace(trace);
        }
        catch (TmfAnalysisException e) {
            module.dispose();
            return null;
        }
        module.schedule();
        return new SegmentStoreStatisticsDataProvider(trace, module, composedId);
    }

    private static final class GenericSegmentStatisticsAnalysis
    extends AbstractSegmentStatisticsAnalysis {
        private final String fSecondaryId;

        private GenericSegmentStatisticsAnalysis(String secondaryId) {
            this.fSecondaryId = secondaryId;
        }

        @Override
        protected @Nullable String getSegmentType(@NonNull ISegment segment) {
            if (segment instanceof INamedSegment) {
                return ((INamedSegment)segment).getName();
            }
            return null;
        }

        @Override
        protected @Nullable ISegmentStoreProvider getSegmentProviderAnalysis(@NonNull ITmfTrace trace) {
            IAnalysisModule segmentStoreModule = trace.getAnalysisModule(this.fSecondaryId);
            if (segmentStoreModule instanceof ISegmentStoreProvider) {
                return (ISegmentStoreProvider)segmentStoreModule;
            }
            return null;
        }
    }
}

