/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.segmentstore;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.IAnalysisProgressListener;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.datastore.core.interval.IHTIntervalReader;
import org.eclipse.tracecompass.internal.analysis.timing.core.Activator;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.segmentstore.core.SegmentStoreFactory;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.segment.ISegmentAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;

public abstract class AbstractSegmentStoreAnalysisModule
extends TmfAbstractAnalysisModule
implements ISegmentStoreProvider {
    private static final String EXTENSION = ".ss";
    private final ListenerList fListeners = new ListenerList(1);
    private @Nullable ISegmentStore<ISegment> fSegmentStore;

    @Override
    public void addListener(IAnalysisProgressListener listener) {
        this.fListeners.add((Object)listener);
    }

    @Override
    public void removeListener(IAnalysisProgressListener listener) {
        this.fListeners.remove((Object)listener);
    }

    protected Iterable<IAnalysisProgressListener> getListeners() {
        ArrayList<IAnalysisProgressListener> listeners = new ArrayList<IAnalysisProgressListener>();
        Object[] objectArray = this.fListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            if (listener != null) {
                listeners.add((IAnalysisProgressListener)listener);
            }
            ++n2;
        }
        return listeners;
    }

    @Override
    public Iterable<ISegmentAspect> getSegmentAspects() {
        return Collections.emptyList();
    }

    protected String getDataFileName() {
        return String.valueOf(this.getId()) + EXTENSION;
    }

    protected int getVersion() {
        return 1;
    }

    protected abstract boolean buildAnalysisSegments(ISegmentStore<ISegment> var1, IProgressMonitor var2) throws TmfAnalysisException;

    protected IHTIntervalReader<ISegment> getSegmentReader() {
        throw new UnsupportedOperationException("getSegmentReader: This method should be overriden in classes that saves the segment store on disk");
    }

    protected SegmentStoreFactory.SegmentStoreType getSegmentStoreType() {
        return SegmentStoreFactory.SegmentStoreType.Fast;
    }

    @Override
    public @Nullable ISegmentStore<ISegment> getSegmentStore() {
        return this.fSegmentStore;
    }

    public void dispose() {
        super.dispose();
        ISegmentStore<ISegment> store = this.fSegmentStore;
        if (store != null) {
            store.dispose();
        }
    }

    protected boolean executeAnalysis(IProgressMonitor monitor) throws TmfAnalysisException {
        SegmentStoreFactory.SegmentStoreType type = this.getSegmentStoreType();
        ISegmentStore<ISegment> store = null;
        switch (type) {
            case Fast: 
            case Stable: 
            case Distinct: {
                store = this.buildInMemorySegmentStore(type, monitor);
                break;
            }
            case OnDisk: {
                @Nullable String dataFileName = this.getDataFileName();
                store = this.buildOnDiskSegmentStore(dataFileName, monitor);
                break;
            }
            default: {
                Activator.getInstance().logError("Unknown segment store type: " + type);
            }
        }
        if (store == null) {
            return false;
        }
        this.fSegmentStore = store;
        this.sendUpdate(store);
        return true;
    }

    private @Nullable ISegmentStore<@NonNull ISegment> buildOnDiskSegmentStore(@Nullable String dataFileName, IProgressMonitor monitor) throws TmfAnalysisException {
        ISegmentStore segmentStore;
        ITmfTrace trace = (ITmfTrace)NonNullUtils.checkNotNull((Object)this.getTrace());
        String fileName = dataFileName;
        if (fileName == null) {
            fileName = String.valueOf(this.getId()) + EXTENSION;
        }
        String dir = TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace);
        Path file = Paths.get(dir, fileName);
        boolean built = false;
        try {
            FileTime origCreationTime = Files.exists(file, new LinkOption[0]) ? ((BasicFileAttributes)NonNullUtils.checkNotNull((Object)Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]))).creationTime() : FileTime.fromMillis(0L);
            segmentStore = SegmentStoreFactory.createOnDiskSegmentStore((Path)file, this.getSegmentReader(), (int)this.getVersion());
            FileTime creationTime = ((BasicFileAttributes)NonNullUtils.checkNotNull((Object)Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]))).creationTime();
            built = origCreationTime.equals(creationTime);
        }
        catch (IOException e) {
            try {
                Files.deleteIfExists(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Activator.getInstance().logError("Error creating segment store", (Throwable)e);
            return null;
        }
        if (built) {
            return segmentStore;
        }
        boolean completed = this.buildAnalysisSegments((ISegmentStore<ISegment>)segmentStore, monitor);
        if (!completed) {
            return null;
        }
        return segmentStore;
    }

    private @Nullable ISegmentStore<@NonNull ISegment> buildInMemorySegmentStore(SegmentStoreFactory.SegmentStoreType type, IProgressMonitor monitor) throws TmfAnalysisException {
        ISegmentStore segmentStore = SegmentStoreFactory.createSegmentStore((SegmentStoreFactory.SegmentStoreType[])new SegmentStoreFactory.SegmentStoreType[]{type});
        boolean completed = this.buildAnalysisSegments((ISegmentStore<ISegment>)segmentStore, monitor);
        if (!completed) {
            return null;
        }
        return segmentStore;
    }

    protected void sendUpdate(ISegmentStore<ISegment> store) {
        for (IAnalysisProgressListener listener : this.getListeners()) {
            listener.onComplete(this, store);
        }
    }
}

