/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugModelProvider;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ITerminate;

public class DebugModelPropertyTester
extends PropertyTester {
    public static final String MODEL_TYPE_PROPERTY = "getModelIdentifier";
    public static final String IS_TERMINATED_OR_DISCONNECTED_PROPERTY = "isTerminatedOrDisconnected";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (MODEL_TYPE_PROPERTY.equals(property)) {
            IDebugTarget target = null;
            if (receiver instanceof IProcess) {
                target = (IDebugTarget)((IProcess)receiver).getAdapter(IDebugTarget.class);
            } else if (receiver instanceof IDebugElement) {
                target = (IDebugTarget)((IDebugElement)receiver).getAdapter(IDebugTarget.class);
            }
            if (target != null) {
                if (expectedValue == null || expectedValue.equals("")) {
                    return false;
                }
                if (expectedValue.equals(target.getModelIdentifier())) {
                    return true;
                }
            }
            IDebugModelProvider modelProvider = null;
            modelProvider = receiver instanceof IAdaptable ? (IDebugModelProvider)((IAdaptable)receiver).getAdapter(IDebugModelProvider.class) : (IDebugModelProvider)Platform.getAdapterManager().getAdapter(receiver, IDebugModelProvider.class);
            if (modelProvider != null) {
                String[] ids = modelProvider.getModelIdentifiers();
                int i = 0;
                while (i < ids.length) {
                    if (ids[i].equals(expectedValue)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            return "".equals(expectedValue);
        }
        if (IS_TERMINATED_OR_DISCONNECTED_PROPERTY.equals(property)) {
            if (receiver instanceof ITerminate && ((ITerminate)receiver).isTerminated()) {
                return true;
            }
            return receiver instanceof IDisconnect && ((IDisconnect)receiver).isDisconnected();
        }
        return false;
    }
}

