/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;

@NonNullByDefault
public final class StateSystemUtils {
    private StateSystemUtils() {
    }

    public static @Nullable ITmfStateInterval querySingleStackTop(ITmfStateSystem ss, long t, int stackAttributeQuark) throws AttributeNotFoundException, StateSystemDisposedException {
        @Nullable Object curStackStateValue = ss.querySingleState(t, stackAttributeQuark).getValue();
        if (curStackStateValue == null) {
            return null;
        }
        if (!(curStackStateValue instanceof Integer)) {
            throw new IllegalStateException(String.valueOf(ss.getSSID()) + "Quark: " + stackAttributeQuark + ", expected Integer.class, value was " + curStackStateValue.getClass());
        }
        int curStackDepth = (Integer)curStackStateValue;
        if (curStackDepth <= 0) {
            throw new StateValueTypeException(String.valueOf(ss.getSSID()) + " Quark:" + stackAttributeQuark + ", Stack depth:" + curStackDepth);
        }
        int subAttribQuark = ss.getQuarkRelative(stackAttributeQuark, String.valueOf(curStackDepth));
        return ss.querySingleState(t, subAttribQuark);
    }

    public static @Nullable Object queryOngoingStackTop(ITmfStateSystem ss, int stackAttributeQuark) {
        @Nullable Object curStackStateValue = ss.queryOngoing(stackAttributeQuark);
        if (curStackStateValue == null) {
            return null;
        }
        if (!(curStackStateValue instanceof Integer)) {
            throw new IllegalStateException(String.valueOf(ss.getSSID()) + " Quark:" + stackAttributeQuark + ", expected Integer.class, value was " + curStackStateValue.getClass());
        }
        int curStackDepth = (Integer)curStackStateValue;
        if (curStackDepth <= 0) {
            throw new IllegalStateException(String.valueOf(ss.getSSID()) + " Quark:" + stackAttributeQuark + ", invalid Stack depth:" + curStackDepth);
        }
        try {
            int subAttribQuark = ss.getQuarkRelative(stackAttributeQuark, String.valueOf(curStackDepth));
            return ss.queryOngoing(subAttribQuark);
        }
        catch (AttributeNotFoundException e) {
            throw new IllegalStateException(String.valueOf(ss.getSSID()) + " Quark:" + stackAttributeQuark + ", expected subAttribute '" + curStackDepth + "' not found");
        }
    }

    public static List<ITmfStateInterval> queryHistoryRange(ITmfStateSystem ss, int attributeQuark, long t1, long t2) throws AttributeNotFoundException, StateSystemDisposedException {
        if (t2 < t1) {
            throw new TimeRangeException(String.valueOf(ss.getSSID()) + " Start:" + t1 + ", End:" + t2);
        }
        long tEnd = t2 > ss.getCurrentEndTime() ? ss.getCurrentEndTime() : t2;
        ArrayList<ITmfStateInterval> intervals = new ArrayList<ITmfStateInterval>();
        ITmfStateInterval currentInterval = ss.querySingleState(t1, attributeQuark);
        intervals.add(currentInterval);
        long ts = currentInterval.getEndTime();
        while (ts != -1L && ts < tEnd) {
            currentInterval = ss.querySingleState(++ts, attributeQuark);
            intervals.add(currentInterval);
            ts = currentInterval.getEndTime();
        }
        return intervals;
    }

    public static List<ITmfStateInterval> queryHistoryRange(ITmfStateSystem ss, int attributeQuark, long t1, long t2, long resolution, @Nullable IProgressMonitor monitor) throws AttributeNotFoundException, StateSystemDisposedException {
        LinkedList<ITmfStateInterval> intervals = new LinkedList<ITmfStateInterval>();
        ITmfStateInterval currentInterval = null;
        if (t2 < t1 || resolution <= 0L) {
            throw new TimeRangeException(String.valueOf(ss.getSSID()) + " Start:" + t1 + ", End:" + t2 + ", Resolution:" + resolution);
        }
        long tEnd = t2 > ss.getCurrentEndTime() ? ss.getCurrentEndTime() : t2;
        IProgressMonitor mon = monitor;
        if (mon == null) {
            mon = new NullProgressMonitor();
        }
        long ts = t1;
        while (ts <= tEnd) {
            if (mon.isCanceled()) {
                return intervals;
            }
            currentInterval = ss.querySingleState(ts, attributeQuark);
            intervals.add(currentInterval);
            ts += ((currentInterval.getEndTime() - ts) / resolution + 1L) * resolution;
        }
        if (currentInterval != null && currentInterval.getEndTime() < tEnd) {
            currentInterval = ss.querySingleState(tEnd, attributeQuark);
            intervals.add(currentInterval);
        }
        return intervals;
    }

    /*
     * Exception decompiling
     */
    public static @Nullable ITmfStateInterval queryUntilNonNullValue(ITmfStateSystem ss, int attributeQuark, long t1, long t2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void queueOfferAttribute(ITmfStateSystemBuilder ss, long t, Object value, int attributeQuark) {
        ss.pushAttribute(t, value, attributeQuark);
    }

    public static @Nullable Object queuePollAttribute(ITmfStateSystemBuilder ss, long t, int attributeQuark) throws StateValueTypeException {
        List<@NonNull Integer> subAttributes = ss.getSubAttributes(attributeQuark, false);
        int size = subAttributes.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return ss.popAttributeObject(t, attributeQuark);
        }
        Object poppedValue = ss.queryOngoing(subAttributes.get(0));
        int i = 0;
        while (i < size - 1) {
            int childQuark = subAttributes.get(i);
            int nextChildQuark = subAttributes.get(i + 1);
            Object nextValue = ss.queryOngoing(nextChildQuark);
            ss.modifyAttribute(t, nextValue, childQuark);
            ++i;
        }
        ss.popAttributeObject(t, attributeQuark);
        return poppedValue;
    }

    public static @Nullable Object queuePeekAttribute(ITmfStateSystemBuilder ss, long t, int attributeQuark) {
        List<@NonNull Integer> subAttributes = ss.getSubAttributes(attributeQuark, false);
        if (subAttributes.size() == 0) {
            return null;
        }
        return ss.queryOngoing(subAttributes.get(0));
    }

    public static List<Long> getTimes(long from, long to, long resolution) {
        if (to < from || resolution < 0L) {
            throw new IllegalArgumentException();
        }
        long increment = Math.max(resolution, 1L);
        ArrayList<Long> times = new ArrayList<Long>((int)((to - from) / increment + 1L));
        long t = from;
        while (t < to) {
            times.add(t);
            t += increment;
        }
        times.add(to);
        return times;
    }

    public static class QuarkIterator
    implements Iterator<ITmfStateInterval> {
        private final ITmfStateSystem fSS;
        private final int fQuark;
        private final long fInitialTime;
        private final long fEndTime;
        private final long fResolution;
        private @Nullable ITmfStateInterval fCurrent;
        private @Nullable ITmfStateInterval fPrevious;
        private @Nullable ITmfStateInterval fNext;

        public QuarkIterator(ITmfStateSystem ss, int quark, long initialTime) {
            this(ss, quark, initialTime, Long.MAX_VALUE, 1L);
        }

        public QuarkIterator(ITmfStateSystem ss, int quark, long initialTime, long endTime) {
            this(ss, quark, initialTime, endTime, 1L);
        }

        public QuarkIterator(ITmfStateSystem ss, int quark, long initialTime, long endTime, long resolution) {
            if (endTime < initialTime) {
                throw new TimeRangeException("iterateOverQuark: end < start !");
            }
            this.fSS = ss;
            this.fQuark = quark;
            this.fInitialTime = initialTime;
            this.fEndTime = endTime;
            this.fResolution = Math.max(1L, resolution);
        }

        private long getNextQueryTime() {
            if (this.fCurrent != null) {
                long endTime = this.fCurrent.getEndTime();
                return this.fResolution == 1L ? endTime + 1L : this.fInitialTime + ((endTime - this.fInitialTime) / this.fResolution + 1L) * this.fResolution;
            }
            return Long.max(this.fInitialTime, this.fSS.getStartTime());
        }

        private long getPreviousQueryTime() {
            if (this.fCurrent != null) {
                long startTime = this.fCurrent.getStartTime();
                return this.fResolution == 1L ? startTime - 1L : this.fInitialTime - ((this.fInitialTime - startTime) / this.fResolution + 1L) * this.fResolution;
            }
            return Long.min(this.fInitialTime, this.fSS.getCurrentEndTime());
        }

        @Override
        public boolean hasNext() {
            if (this.fNext != null) {
                return true;
            }
            long end = Long.min(this.fEndTime, this.fSS.getCurrentEndTime());
            long nextQueryTime = this.getNextQueryTime();
            if (nextQueryTime <= end) {
                try {
                    this.fNext = this.fSS.querySingleState(nextQueryTime, this.fQuark);
                }
                catch (StateSystemDisposedException e) {
                    this.fNext = null;
                    return false;
                }
            }
            return this.fNext != null;
        }

        @Override
        public ITmfStateInterval next() {
            if (this.hasNext()) {
                ITmfStateInterval next = Objects.requireNonNull(this.fNext, "Inconsistent state, should be non null if hasNext returned true");
                this.fPrevious = this.fCurrent;
                this.fCurrent = next;
                this.fNext = null;
                return next;
            }
            throw new NoSuchElementException();
        }

        public boolean hasPrevious() {
            if (this.fPrevious != null) {
                return true;
            }
            long previousQueryTime = this.getPreviousQueryTime();
            if (previousQueryTime >= this.fSS.getStartTime()) {
                try {
                    this.fPrevious = this.fSS.querySingleState(previousQueryTime, this.fQuark);
                }
                catch (StateSystemDisposedException e) {
                    this.fPrevious = null;
                    return false;
                }
            }
            return this.fPrevious != null;
        }

        public ITmfStateInterval previous() {
            if (this.hasPrevious()) {
                ITmfStateInterval prev = Objects.requireNonNull(this.fPrevious, "Inconsistent state, should be non null if hasPrevious returned true");
                this.fNext = this.fCurrent;
                this.fCurrent = prev;
                this.fPrevious = null;
                return prev;
            }
            throw new NoSuchElementException();
        }
    }
}

