/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.model;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.project.model.TmfProjectModelHelper;
import org.eclipse.tracecompass.tmf.core.io.ResourceUtil;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.Messages;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class TmfProjectRegistry
implements IResourceChangeListener {
    private static final TmfProjectRegistry INSTANCE = new TmfProjectRegistry();
    private static final Map<IProject, TmfProjectElement> registry = new HashMap<IProject, TmfProjectElement>();
    private static final Queue<TmfTraceElement> promptQueue = new ArrayDeque<TmfTraceElement>();

    private TmfProjectRegistry() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        TmfSignalManager.register((Object)this);
    }

    public static void init() {
    }

    public static void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)INSTANCE);
        TmfSignalManager.deregister((Object)INSTANCE);
        registry.values().forEach(ITmfProjectModelElement::dispose);
    }

    public static synchronized TmfProjectElement getProject(IProject project) {
        try {
            if (project.hasNature("org.eclipse.linuxtools.tmf.project.nature")) {
                return TmfProjectRegistry.getProject(project, true);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    public static synchronized TmfProjectElement getProject(IProject aProject, boolean force) {
        TmfProjectElement element;
        IWorkspace workspace;
        IProject shadowProject;
        IProject project = aProject;
        if (TmfProjectElement.showProjectRoot(project) && (shadowProject = (workspace = ResourcesPlugin.getWorkspace()).getRoot().getProject(TmfProjectModelHelper.getShadowProjectName(project.getName()))).exists()) {
            project = shadowProject;
        }
        if ((element = registry.get(project)) == null && force) {
            element = new TmfProjectElement(project.getName(), project, null);
            registry.put(project, element);
            element.refreshChildren();
        }
        return element;
    }

    public static IProject createProject(String projectName, final URI projectLocation, IProgressMonitor monitor) {
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        final IProject project = root.getProject(projectName);
        WorkspaceModifyOperation action = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor progressMonitor) throws CoreException, InvocationTargetException, InterruptedException {
                IProjectDescription description;
                if (!project.exists()) {
                    description = workspace.newProjectDescription(project.getName());
                    if (projectLocation != null) {
                        description.setLocationURI(projectLocation);
                    }
                    project.create(description, progressMonitor);
                }
                if (!project.isOpen()) {
                    project.open(progressMonitor);
                }
                description = project.getDescription();
                description.setNatureIds(new String[]{"org.eclipse.linuxtools.tmf.project.nature"});
                project.setDescription(description, null);
                TmfProjectElement.createFolderStructure((IContainer)project);
            }
        };
        try {
            action.run(monitor);
        }
        catch (InvocationTargetException e) {
            Activator.getDefault().logError("Error creating TMF project " + project.getName(), e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return project;
    }

    public static void addTracingNature(final IProject project, IProgressMonitor monitor) {
        WorkspaceModifyOperation action = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor progressMonitor) throws CoreException, InvocationTargetException, InterruptedException {
                if (!project.isOpen()) {
                    project.open(progressMonitor);
                }
                IProjectDescription description = project.getDescription();
                boolean hasNature = description.hasNature("org.eclipse.linuxtools.tmf.project.nature");
                String[] natures = description.getNatureIds();
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                if (workspace == null) {
                    return;
                }
                if (!hasNature && natures.length > 0) {
                    String[] newNatures = new String[natures.length + 1];
                    System.arraycopy(natures, 0, newNatures, 0, natures.length);
                    newNatures[natures.length] = "org.eclipse.linuxtools.tmf.project.nature";
                    IStatus status = workspace.validateNatureSet(newNatures);
                    if (status.isOK()) {
                        description.setNatureIds(newNatures);
                        project.setDescription(description, null);
                    } else {
                        Activator.getDefault().getLog().log(status);
                    }
                }
                description = project.getDescription();
                hasNature = description.hasNature("org.eclipse.linuxtools.tmf.project.nature");
                natures = description.getNatureIds();
                if (hasNature && natures.length > 1) {
                    String shadowProjectName = TmfProjectModelHelper.getShadowProjectName(project.getName());
                    IProject shadowProject = workspace.getRoot().getProject(shadowProjectName);
                    if (shadowProject.exists() && !shadowProject.isAccessible()) {
                        shadowProject.delete(false, true, progressMonitor);
                    }
                    if (!shadowProject.exists()) {
                        IFolder shadowProjectFolder = TmfProjectElement.createFolderStructure(project, null);
                        shadowProject = TmfProjectRegistry.createProject(shadowProjectName, shadowProjectFolder.getLocationURI(), progressMonitor);
                        shadowProjectFolder.refreshLocal(2, progressMonitor);
                    }
                    if (!shadowProject.isOpen()) {
                        shadowProject.open(progressMonitor);
                    }
                    TmfProjectElement.createFolderStructure(project, shadowProject);
                    TmfProjectElement tmfProject = TmfProjectRegistry.getProject(project, false);
                    if (tmfProject != null && (tmfProject.getTracesFolder() == null || tmfProject.getExperimentsFolder() == null || tmfProject.getSupplementaryFolder() == null)) {
                        tmfProject.refreshChildren();
                    }
                }
            }
        };
        try {
            action.run(monitor);
        }
        catch (InvocationTargetException e) {
            Activator.getDefault().logError("Error adding tracing nature to project " + project.getName(), e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        block37: {
            if (event.getType() == 4 || event.getType() == 2) {
                if (event.getResource() instanceof IProject) {
                    IProject aProject = (IProject)event.getResource();
                    try {
                        TmfProjectElement projectElement;
                        IProject shadowProject;
                        boolean removeProjectElement;
                        List<TmfTraceElement> traces;
                        TmfTraceFolder tracesFolder;
                        TmfProjectElement tmfProjectElement;
                        IProject shadowProject2;
                        boolean isShadowProject = TmfProjectModelHelper.isShadowProject(Objects.requireNonNull(aProject));
                        if (!aProject.isAccessible() || !aProject.hasNature("org.eclipse.linuxtools.tmf.project.nature")) break block37;
                        IProject project = aProject;
                        if (!isShadowProject && (shadowProject2 = TmfProjectModelHelper.getShadowProject(project)).exists()) {
                            project = shadowProject2;
                        }
                        if ((tmfProjectElement = registry.get(project)) != null && (tracesFolder = tmfProjectElement.getTracesFolder()) != null && !(traces = tracesFolder.getTraces()).isEmpty()) {
                            Display.getDefault().syncExec(() -> traces.forEach(TmfTraceElement::closeEditors));
                        }
                        boolean bl = removeProjectElement = event.getType() == 2;
                        if (!isShadowProject && (shadowProject = TmfProjectModelHelper.getShadowProject(aProject)).exists()) {
                            if (event.getType() == 4) {
                                Display.getDefault().asyncExec(() -> {
                                    try {
                                        shadowProject.delete(false, true, null);
                                    }
                                    catch (CoreException e) {
                                        Activator.getDefault().logError("Error deleting shadow project when is parent project being deleted " + shadowProject.getName(), e);
                                    }
                                });
                            } else {
                                Display.getDefault().asyncExec(() -> {
                                    try {
                                        shadowProject.close(null);
                                    }
                                    catch (CoreException e) {
                                        Activator.getDefault().logError("Error removing shadow project when is parent project being closed " + shadowProject.getName(), e);
                                    }
                                });
                            }
                            removeProjectElement = false;
                        }
                        if (removeProjectElement && (projectElement = registry.remove(project)) != null) {
                            projectElement.dispose();
                        }
                    }
                    catch (CoreException e) {
                        Activator.getDefault().logError("Error handling resource change event for " + aProject.getName(), e);
                    }
                }
            } else if (event.getType() == 1) {
                IResourceDelta[] iResourceDeltaArray = event.getDelta().getAffectedChildren();
                int n = iResourceDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceDelta delta = iResourceDeltaArray[n2];
                    if (delta.getResource() instanceof IProject) {
                        IProject project = (IProject)delta.getResource();
                        try {
                            if (delta.getKind() == 2) {
                                IProject parentProject;
                                TmfProjectElement projectElement = registry.remove(project);
                                if (projectElement != null) {
                                    projectElement.dispose();
                                }
                                if ((parentProject = TmfProjectModelHelper.getProjectFromShadowProject(project)) != null) {
                                    new TmfProjectElement(parentProject.getName(), parentProject, null).refreshViewer();
                                }
                            } else if (project.isOpen() && project.hasNature("org.eclipse.linuxtools.tmf.project.nature")) {
                                if (delta.getKind() == 1 && (delta.getFlags() & 0x1000) != 0) {
                                    TmfProjectRegistry.handleProjectMoved(project);
                                } else if (delta.getKind() == 4) {
                                    if (TmfProjectModelHelper.shadowProjectAccessible(project)) {
                                        TmfProjectRegistry.handleParentProjectRefresh(project);
                                    } else if ((delta.getFlags() & 0x4000) != 0) {
                                        TmfProjectRegistry.handleParentProjectOpen(project);
                                    } else {
                                        IProject parentProject = TmfProjectModelHelper.getProjectFromShadowProject(project);
                                        HashSet resourcesToRefresh = new HashSet();
                                        HashMap resourceFlags = new HashMap();
                                        delta.accept(visited -> {
                                            resourceFlags.put(visited.getResource(), visited.getFlags());
                                            if ((visited.getFlags() & 0x200100) != 0) {
                                                resourcesToRefresh.add(visited.getResource());
                                            } else if (visited.getKind() != 4) {
                                                IContainer parent = visited.getResource().getParent();
                                                if ((visited.getFlags() & 0x3000) == 0) {
                                                    resourcesToRefresh.add(visited.getResource());
                                                    resourcesToRefresh.add(parent);
                                                } else {
                                                    Integer parentFlags = (Integer)resourceFlags.get(parent);
                                                    if (parentFlags != null && (parentFlags & 0x3000) == 0) {
                                                        resourcesToRefresh.add(parent);
                                                    }
                                                }
                                            }
                                            return true;
                                        });
                                        HashSet<ITmfProjectModelElement> elementsToRefresh = new HashSet<ITmfProjectModelElement>();
                                        for (IResource resource : resourcesToRefresh) {
                                            ITmfProjectModelElement element = TmfProjectRegistry.findElement(resource, false);
                                            if (element == null) continue;
                                            elementsToRefresh.add(element);
                                        }
                                        HashSet<TmfTraceElement> deletedTraces = new HashSet<TmfTraceElement>();
                                        HashSet<TmfTraceElement> changedTraces = new HashSet<TmfTraceElement>();
                                        Iterator iterator = elementsToRefresh.iterator();
                                        block6: while (iterator.hasNext()) {
                                            ITmfProjectModelElement element = (ITmfProjectModelElement)iterator.next();
                                            if (element instanceof TmfTraceElement) {
                                                TmfTraceElement trace = (TmfTraceElement)element;
                                                IResource resource = trace.getResource();
                                                if (TmfProjectRegistry.isHandleDeleted(resource, parentProject)) {
                                                    deletedTraces.add(trace);
                                                } else {
                                                    changedTraces.add(trace);
                                                }
                                            }
                                            for (ITmfProjectModelElement parent : elementsToRefresh) {
                                                if (!parent.getPath().isPrefixOf(element.getPath()) || parent.equals(element)) continue;
                                                iterator.remove();
                                                continue block6;
                                            }
                                        }
                                        if (!deletedTraces.isEmpty() || !changedTraces.isEmpty()) {
                                            Job.createSystem(monitor -> {
                                                try {
                                                    if (!deletedTraces.isEmpty()) {
                                                        Display.getDefault().syncExec(() -> {
                                                            for (TmfTraceElement deletedTrace : deletedTraces) {
                                                                deletedTrace.closeEditors();
                                                            }
                                                        });
                                                    }
                                                    ResourcesPlugin.getWorkspace().run(mon -> {
                                                        for (TmfTraceElement deletedTrace : deletedTraces) {
                                                            TmfProjectRegistry.handleTraceDeleted(deletedTrace);
                                                        }
                                                        for (TmfTraceElement changedTrace : changedTraces) {
                                                            TmfProjectRegistry.handleTraceContentChanged(changedTrace);
                                                        }
                                                    }, (ISchedulingRule)project, 1, null);
                                                }
                                                catch (CoreException e) {
                                                    Activator.getDefault().logError("Error handling resource change event for " + project.getName(), e);
                                                }
                                                if (parentProject != null) {
                                                    new TmfProjectElement(parentProject.getName(), parentProject, null).refreshViewer();
                                                }
                                            }).schedule();
                                        }
                                        for (ITmfProjectModelElement element : elementsToRefresh) {
                                            element.refresh();
                                        }
                                        TmfProjectElement projectElement = registry.get(project);
                                        if (projectElement != null) {
                                            projectElement.refreshViewer();
                                        }
                                    }
                                }
                            }
                        }
                        catch (CoreException e) {
                            Activator.getDefault().logError("Error handling resource change event for " + project.getName(), e);
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    private static boolean isHandleDeleted(IResource resource, IProject parentProject) {
        IPath path = ResourceUtil.getLocation((IResource)resource);
        if (path == null) {
            return false;
        }
        return (parentProject != null && parentProject.getLocation().isPrefixOf(path) || resource.getWorkspace().getRoot().getLocation().isPrefixOf(path)) && !path.toFile().exists();
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        ITmfProjectModelElement element = TmfProjectRegistry.findElement(signal.getTrace().getResource(), true);
        if (element != null) {
            element.refresh();
            if (element instanceof TmfExperimentElement) {
                TmfExperimentElement experiment = (TmfExperimentElement)element;
                for (TmfTraceElement trace : experiment.getTraces()) {
                    trace.getElementUnderTraceFolder().refresh();
                }
            }
        }
    }

    public static ITmfProjectModelElement findElement(IResource resource, boolean exact) {
        if (resource == null || resource.getProject() == null) {
            return null;
        }
        ITmfProjectModelElement element = TmfProjectRegistry.getProject(resource.getProject());
        if (element == null) {
            return null;
        }
        String[] stringArray = resource.getProjectRelativePath().segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            List<ITmfProjectModelElement> children = element.getChildren();
            boolean match = false;
            for (ITmfProjectModelElement child : children) {
                IResource childResource = child.getResource();
                if (resource.equals((Object)childResource)) {
                    return child;
                }
                if (childResource == null || !segment.equals(childResource.getName())) continue;
                element = child;
                match = true;
                break;
            }
            if (!match) {
                return exact ? null : (element instanceof TmfProjectElement ? null : element);
            }
            ++n2;
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleTraceContentChanged(TmfTraceElement traceElement) {
        boolean opened = false;
        block3: for (ITmfTrace openedTrace : TmfTraceManager.getInstance().getOpenedTraces()) {
            for (ITmfTrace trace : TmfTraceManager.getTraceSet((ITmfTrace)openedTrace)) {
                if (!traceElement.getResource().equals((Object)trace.getResource())) continue;
                opened = true;
                continue block3;
            }
        }
        if (!opened) {
            traceElement.deleteSupplementaryResources();
            return;
        }
        Queue<TmfTraceElement> queue = promptQueue;
        synchronized (queue) {
            if (!promptQueue.isEmpty()) {
                if (!promptQueue.contains(traceElement)) {
                    promptQueue.add(traceElement);
                }
                return;
            }
            promptQueue.add(traceElement);
        }
        Display.getDefault().asyncExec(() -> {
            TmfTraceElement prompting = traceElement;
            while (prompting != null) {
                boolean always = Activator.getDefault().getPreferenceStore().getBoolean("ALWAYS_CLOSE_ON_RESOURCE_CHANGE");
                if (always) {
                    prompting.closeEditors();
                    TmfProjectRegistry.deleteSupplementaryResources(prompting);
                } else {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    MessageDialog messageDialog = new MessageDialog(shell, Messages.TmfProjectRegistry_TraceChangedDialogTitle, null, NLS.bind((String)Messages.TmfProjectRegistry_TraceChangedDialogMessage, (Object)prompting.getElementPath()), 3, 2, new String[]{IDialogConstants.NO_LABEL, IDialogConstants.YES_LABEL, Messages.TmfProjectRegistry_Always});
                    int returnCode = messageDialog.open();
                    if (returnCode >= 1) {
                        prompting.closeEditors();
                        TmfProjectRegistry.deleteSupplementaryResources(prompting);
                    }
                    if (returnCode == 2) {
                        Activator.getDefault().getPreferenceStore().setValue("ALWAYS_CLOSE_ON_RESOURCE_CHANGE", true);
                    }
                }
                Queue<TmfTraceElement> queue = promptQueue;
                synchronized (queue) {
                    promptQueue.remove();
                    prompting = promptQueue.peek();
                }
            }
        });
    }

    private static void deleteSupplementaryResources(TmfTraceElement trace) {
        Job.createSystem(monitor -> {
            try {
                ResourcesPlugin.getWorkspace().run(mon -> trace.deleteSupplementaryResources(), (ISchedulingRule)trace.getProject().getResource(), 1, monitor);
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error deleting supplementary resources for " + trace.getName(), e);
            }
        }).schedule();
    }

    private static void handleTraceDeleted(TmfTraceElement trace) {
        try {
            trace.preDelete((IProgressMonitor)new NullProgressMonitor(), false);
            ResourceUtil.deleteIfBrokenSymbolicLink((IResource)trace.getResource());
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error deleting trace " + trace.getName(), e);
        }
    }

    private static void handleParentProjectOpen(IProject project) {
        Job job = Job.createSystem(monitor -> {
            IProject shadowProject = TmfProjectModelHelper.getShadowProject(project);
            if (shadowProject != null && shadowProject.exists() && !shadowProject.isOpen()) {
                try {
                    shadowProject.open((IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            TmfProjectRegistry.addTracingNature(project, monitor);
        });
        job.schedule();
    }

    private static void handleParentProjectRefresh(IProject project) {
        Job job = Job.createSystem(monitor -> {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject shadowProject = workspace.getRoot().getProject(TmfProjectModelHelper.getShadowProjectName(project.getName()));
            if (shadowProject.exists()) {
                try {
                    shadowProject.refreshLocal(2, monitor);
                }
                catch (CoreException e) {
                    Activator.getDefault().logError("Error refeshing shadow project " + shadowProject.getName(), e);
                }
            }
        });
        job.schedule();
    }

    private static void handleProjectMoved(IProject newProject) {
        Job job = Job.createSystem(monitor -> {
            TmfProjectRegistry.addTracingNature(newProject, monitor);
            IProject shadowProject = TmfProjectModelHelper.getShadowProject(newProject);
            String newShadowProjectName = TmfProjectModelHelper.getShadowProjectName(newProject.getName());
            try {
                if (shadowProject.exists()) {
                    IProjectDescription desc = shadowProject.getDescription();
                    desc.setName(newShadowProjectName);
                    shadowProject.move(desc, true, monitor);
                }
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error renaming shadow project " + shadowProject.getName() + " to " + newShadowProjectName, e);
            }
        });
        job.schedule();
    }
}

