/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.timegraph;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.internal.tmf.ui.views.timegraph.TimeEventFilterDialog;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ILinkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public abstract class AbstractStateSystemTimeGraphView
extends AbstractTimeGraphView {
    private static final long MAX_INTERVALS = 1000000L;
    private final Map<ITmfStateSystem, List<@NonNull TimeGraphEntry>> fSSEntryListMap = new HashMap<ITmfStateSystem, List<TimeGraphEntry>>();
    private final Multimap<ITmfTrace, ITmfStateSystem> fTraceSSMap = HashMultimap.create();
    private static final @NonNull Logger LOGGER = TraceCompassLog.getLogger(AbstractStateSystemTimeGraphView.class);
    private static final int DEFAULT_BUFFER_SIZE = 3;

    public AbstractStateSystemTimeGraphView(String id, TimeGraphPresentationProvider pres) {
        super(id, pres);
    }

    protected void getEnventListGaps(@NonNull TimeGraphEntry entry, List<ITimeEvent> eventList, Map<TimeGraphEntry, List<ITimeEvent>> gaps) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected @Nullable List<@NonNull TimeGraphEntry> getEntryList(ITmfStateSystem ss) {
        Map<ITmfStateSystem, List<TimeGraphEntry>> map = this.fSSEntryListMap;
        synchronized (map) {
            return this.fSSEntryListMap.get(ss);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putEntryList(ITmfTrace trace, ITmfStateSystem ss, List<@NonNull TimeGraphEntry> list) {
        super.addToEntryList(trace, AbstractStateSystemTimeGraphView.getRootEntries(list));
        Map<ITmfStateSystem, List<TimeGraphEntry>> map = this.fSSEntryListMap;
        synchronized (map) {
            this.fSSEntryListMap.put(ss, new CopyOnWriteArrayList<TimeGraphEntry>(list));
            this.fTraceSSMap.put((Object)trace, (Object)ss);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToEntryList(ITmfTrace trace, ITmfStateSystem ss, List<@NonNull TimeGraphEntry> list) {
        super.addToEntryList(trace, AbstractStateSystemTimeGraphView.getRootEntries(list));
        Map<ITmfStateSystem, List<TimeGraphEntry>> map = this.fSSEntryListMap;
        synchronized (map) {
            List<@NonNull TimeGraphEntry> entryList = this.fSSEntryListMap.get(ss);
            if (entryList == null) {
                this.fSSEntryListMap.put(ss, new CopyOnWriteArrayList<TimeGraphEntry>(list));
            } else {
                entryList.addAll(list);
            }
            this.fTraceSSMap.put((Object)trace, (Object)ss);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromEntryList(ITmfTrace trace, ITmfStateSystem ss, List<TimeGraphEntry> list) {
        super.removeFromEntryList(trace, list);
        Map<ITmfStateSystem, List<TimeGraphEntry>> map = this.fSSEntryListMap;
        synchronized (map) {
            List<TimeGraphEntry> entryList = this.fSSEntryListMap.get(ss);
            if (entryList != null) {
                entryList.removeAll(list);
                if (entryList.isEmpty()) {
                    this.fTraceSSMap.remove((Object)trace, (Object)ss);
                }
            }
        }
    }

    private static List<@NonNull TimeGraphEntry> getRootEntries(List<@NonNull TimeGraphEntry> list) {
        LinkedHashSet<@NonNull TimeGraphEntry> roots = new LinkedHashSet<TimeGraphEntry>();
        Iterator<TimeGraphEntry> iterator = list.iterator();
        while (iterator.hasNext()) {
            TimeGraphEntry entry;
            TimeGraphEntry root = entry = iterator.next();
            while (root.getParent() != null) {
                root = root.getParent();
            }
            roots.add(root);
        }
        return new ArrayList<TimeGraphEntry>(roots);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected @Nullable AbstractTimeGraphView.ZoomThread createZoomThread(long startTime, long endTime, long resolution, boolean restart) {
        ArrayList<ITmfStateSystem> ssList = null;
        Map<ITmfStateSystem, List<TimeGraphEntry>> map = this.fSSEntryListMap;
        synchronized (map) {
            ssList = new ArrayList<ITmfStateSystem>(this.fTraceSSMap.get((Object)this.getTrace()));
        }
        if (ssList.isEmpty()) {
            return null;
        }
        return new ZoomThreadByTime(this.getVisibleItems(3), ssList, startTime, endTime, resolution, restart);
    }

    protected void queryFullStates(ITmfStateSystem ss, long start, long end, long resolution, @NonNull IProgressMonitor monitor, @NonNull IQueryHandler handler) {
        if (end < start) {
            return;
        }
        ArrayList<List<ITmfStateInterval>> fullStates = new ArrayList<List<ITmfStateInterval>>();
        List prevFullState = null;
        try {
            long time = start;
            while (!monitor.isCanceled()) {
                List fullState = ss.queryFullState(time);
                fullStates.add(fullState);
                if ((long)(fullStates.size() * fullState.size()) > 1000000L) {
                    handler.handle(fullStates, prevFullState);
                    prevFullState = (List)fullStates.get(fullStates.size() - 1);
                    fullStates.clear();
                }
                if (time >= end) break;
                time = Math.min(end, time + resolution);
            }
            if (fullStates.size() > 0) {
                handler.handle(fullStates, prevFullState);
            }
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
    }

    protected abstract @Nullable List<ITimeEvent> getEventList(@NonNull TimeGraphEntry var1, ITmfStateSystem var2, @NonNull List<List<ITmfStateInterval>> var3, @Nullable List<ITmfStateInterval> var4, @NonNull IProgressMonitor var5);

    protected @NonNull List<ILinkEvent> getLinkList(ITmfStateSystem ss, @NonNull List<List<ITmfStateInterval>> fullStates, @Nullable List<ITmfStateInterval> prevFullState, @NonNull IProgressMonitor monitor) {
        return new ArrayList<ILinkEvent>();
    }

    protected @NonNull List<IMarkerEvent> getViewMarkerList(ITmfStateSystem ss, @NonNull List<List<ITmfStateInterval>> fullStates, @Nullable List<ITmfStateInterval> prevFullState, @NonNull IProgressMonitor monitor) {
        return new ArrayList<IMarkerEvent>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void resetView(ITmfTrace viewTrace) {
        super.resetView(viewTrace);
        Map<ITmfStateSystem, List<TimeGraphEntry>> map = this.fSSEntryListMap;
        synchronized (map) {
            for (ITmfStateSystem ss : this.fTraceSSMap.removeAll((Object)viewTrace)) {
                this.fSSEntryListMap.remove(ss);
            }
        }
    }

    public static interface IQueryHandler {
        public void handle(@NonNull List<List<ITmfStateInterval>> var1, @Nullable List<ITmfStateInterval> var2);
    }

    private class ZoomThreadByTime
    extends AbstractTimeGraphView.ZoomThread {
        private static final int BG_SEARCH_RESOLUTION = 1;
        private final @NonNull Collection<@NonNull TimeGraphEntry> fVisibleEntries;
        private final @NonNull List<ITmfStateSystem> fZoomSSList;
        private boolean fClearZoomedLists;

        public ZoomThreadByTime(@NonNull Collection<TimeGraphEntry> entries, List<ITmfStateSystem> ssList, long startTime, long endTime, long resolution, boolean restart) {
            super(startTime, endTime, resolution);
            this.fZoomSSList = ssList;
            this.fClearZoomedLists = !restart;
            this.fVisibleEntries = entries;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doRun() {
            ArrayList<ILinkEvent> links = new ArrayList<ILinkEvent>();
            ArrayList<IMarkerEvent> markers = new ArrayList<IMarkerEvent>();
            if (this.fClearZoomedLists) {
                this.clearZoomedLists();
            }
            for (ITmfStateSystem ss : this.fZoomSSList) {
                List entryList = null;
                Map map = AbstractStateSystemTimeGraphView.this.fSSEntryListMap;
                synchronized (map) {
                    entryList = (List)AbstractStateSystemTimeGraphView.this.fSSEntryListMap.get(ss);
                }
                if (entryList == null) continue;
                this.zoomByTime(ss, entryList, links, markers, this.getZoomStartTime(), this.getZoomEndTime(), this.getResolution(), this.getMonitor());
            }
            if (!this.getMonitor().isCanceled()) {
                markers.addAll(AbstractStateSystemTimeGraphView.this.getTraceMarkerList(this.getZoomStartTime(), this.getZoomEndTime(), this.getResolution(), this.getMonitor()));
                this.applyResults(() -> {
                    AbstractStateSystemTimeGraphView.this.getTimeGraphViewer().setLinks(links);
                    AbstractStateSystemTimeGraphView.this.getTimeGraphViewer().setMarkerCategories(AbstractStateSystemTimeGraphView.this.getMarkerCategories());
                    AbstractStateSystemTimeGraphView.this.getTimeGraphViewer().setMarkers(markers);
                });
            } else {
                TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.FINE, (String)"TimeGraphView:ZoomThreadCanceled", (Object[])new Object[0]);
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            if (this.fClearZoomedLists) {
                this.clearZoomedLists();
            }
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private void zoomByTime(ITmfStateSystem ss, List<TimeGraphEntry> entryList, List<ILinkEvent> links, List<IMarkerEvent> markers, long startTime, long endTime, long resolution, @NonNull IProgressMonitor monitor) {
            boolean fullRange;
            long start = Math.max(startTime, ss.getStartTime());
            long end = Math.min(endTime, ss.getCurrentEndTime());
            boolean bl = fullRange = this.getZoomStartTime() <= AbstractStateSystemTimeGraphView.this.getStartTime() && this.getZoomEndTime() >= AbstractStateSystemTimeGraphView.this.getEndTime();
            if (end < start) {
                return;
            }
            TimeEventFilterDialog timeEventFilterDialog = AbstractStateSystemTimeGraphView.this.getTimeEventFilterDialog();
            boolean isFilterActive = timeEventFilterDialog != null && timeEventFilterDialog.isFilterActive();
            boolean isFilterCleared = !isFilterActive && AbstractStateSystemTimeGraphView.this.getTimeGraphViewer().isTimeEventFilterActive();
            AbstractStateSystemTimeGraphView.this.getTimeGraphViewer().setTimeEventFilterApplied(isFilterActive);
            boolean hasSavedFilter = timeEventFilterDialog != null && timeEventFilterDialog.hasActiveSavedFilters();
            AbstractStateSystemTimeGraphView.this.getTimeGraphViewer().setSavedFilterStatus(hasSavedFilter);
            if (fullRange) {
                AbstractStateSystemTimeGraphView.this.redraw();
            }
            TimeGraphEntry.Sampling sampling = new TimeGraphEntry.Sampling(this.getZoomStartTime(), this.getZoomEndTime(), this.getResolution());
            @NonNull Iterable incorrectSample = Iterables.filter(this.fVisibleEntries, entry -> isFilterActive || isFilterCleared || !sampling.equals(entry.getSampling()));
            @NonNull Iterable entries = Iterables.filter((Iterable)incorrectSample, entry -> this.isMember((TimeGraphEntry)entry, entryList));
            @NonNull Map<@NonNull Integer, @NonNull Predicate<@NonNull Map<@NonNull String, @NonNull String>>> predicates = AbstractStateSystemTimeGraphView.this.computeRegexPredicate();
            HashMap<TimeGraphEntry, List<ITimeEvent>> gaps = isFilterActive ? new HashMap<TimeGraphEntry, List<ITimeEvent>>() : null;
            this.doZoom(ss, links, markers, resolution, monitor, start, end, sampling, entries, predicates, gaps);
            if (isFilterActive && gaps != null && !gaps.isEmpty()) {
                this.doBgSearch(ss, 1, monitor, gaps, predicates);
            }
        }

        private void doZoom(final ITmfStateSystem ss, final List<ILinkEvent> links, final List<IMarkerEvent> markers, long resolution, final @NonNull IProgressMonitor monitor, long start, long end, TimeGraphEntry.Sampling sampling, final Iterable<@NonNull TimeGraphEntry> entries, final Map<@NonNull Integer, @NonNull Predicate<@NonNull Map<@NonNull String, @NonNull String>>> predicates, final Map<TimeGraphEntry, List<ITimeEvent>> gaps) {
            AbstractStateSystemTimeGraphView.this.queryFullStates(ss, start, end, resolution, monitor, new IQueryHandler(){

                @Override
                public void handle(@NonNull List<List<ITmfStateInterval>> fullStates, @Nullable List<ITmfStateInterval> prevFullState) {
                    TraceCompassLogUtils.ScopeLog linksLogger;
                    Throwable throwable = null;
                    Object var4_7 = null;
                    try (TraceCompassLogUtils.ScopeLog scope = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINER, "ZoomThread:GettingStates", new Object[0]);){
                        for (TimeGraphEntry entry : entries) {
                            ZoomThreadByTime.this.zoom((TimeGraphEntry)NonNullUtils.checkNotNull((Object)entry), ss, fullStates, prevFullState, predicates, monitor, gaps);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    throwable = null;
                    var4_7 = null;
                    try {
                        linksLogger = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINER, "ZoomThread:GettingLinks", new Object[0]);
                        try {
                            links.addAll(AbstractStateSystemTimeGraphView.this.getLinkList(ss, fullStates, prevFullState, monitor));
                        }
                        finally {
                            if (linksLogger != null) {
                                linksLogger.close();
                            }
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                    throwable = null;
                    var4_7 = null;
                    try {
                        linksLogger = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINER, "ZoomThread:GettingMarkers", new Object[0]);
                        try {
                            markers.addAll(AbstractStateSystemTimeGraphView.this.getViewMarkerList(ss, fullStates, prevFullState, monitor));
                        }
                        finally {
                            if (linksLogger != null) {
                                linksLogger.close();
                            }
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                    AbstractStateSystemTimeGraphView.this.refresh();
                }
            });
            if (!monitor.isCanceled()) {
                this.applyResults(() -> entries.forEach(entry -> {
                    if (!predicates.isEmpty()) {
                        ArrayList eventList = Lists.newArrayList(entry.getTimeEventsIterator(this.getZoomStartTime(), this.getZoomEndTime(), this.getResolution()));
                        AbstractStateSystemTimeGraphView.this.doFilterEvents((TimeGraphEntry)entry, eventList, predicates);
                        entry.setZoomedEventList(eventList);
                    }
                    entry.setSampling(sampling);
                }));
            }
            AbstractStateSystemTimeGraphView.this.refresh();
        }

        private void zoom(@NonNull TimeGraphEntry entry, ITmfStateSystem ss, @NonNull List<List<ITmfStateInterval>> fullStates, @Nullable List<ITmfStateInterval> prevFullState, Map<@NonNull Integer, @NonNull Predicate<@NonNull Map<@NonNull String, @NonNull String>>> predicates, @NonNull IProgressMonitor monitor, Map<TimeGraphEntry, List<ITimeEvent>> gaps) {
            List<ITimeEvent> eventList = AbstractStateSystemTimeGraphView.this.getEventList(entry, ss, fullStates, prevFullState, monitor);
            if (gaps != null) {
                AbstractStateSystemTimeGraphView.this.getEnventListGaps(entry, eventList, gaps);
            }
            if (eventList != null && !monitor.isCanceled()) {
                AbstractStateSystemTimeGraphView.this.doFilterEvents(entry, eventList, predicates);
                this.applyResults(() -> {
                    for (ITimeEvent event : eventList) {
                        entry.addZoomedEvent(event);
                    }
                });
            }
        }

        private void doBgSearch(final ITmfStateSystem ss, int resolution, final @NonNull IProgressMonitor monitor, Map<TimeGraphEntry, List<ITimeEvent>> gaps, final @NonNull Map<@NonNull Integer, @NonNull Predicate<@NonNull Map<@NonNull String, @NonNull String>>> predicates) {
            Throwable throwable = null;
            Object var7_8 = null;
            try (TraceCompassLogUtils.ScopeLog poc = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINE, "TimegraphBgSearch", new Object[0]);){
                for (Map.Entry<TimeGraphEntry, List<ITimeEvent>> entryGap : gaps.entrySet()) {
                    List<ITimeEvent> gapEvents = entryGap.getValue();
                    final TimeGraphEntry entry = entryGap.getKey();
                    for (final ITimeEvent event : gapEvents) {
                        AbstractStateSystemTimeGraphView.this.queryFullStates(ss, event.getTime(), event.getTime() + event.getDuration(), resolution, monitor, new IQueryHandler(){

                            @Override
                            public void handle(@NonNull List<List<ITmfStateInterval>> fullStates, @Nullable List<ITmfStateInterval> prevFullState) {
                                List<ITimeEvent> eventList = AbstractStateSystemTimeGraphView.this.getEventList(Objects.requireNonNull(entry), ss, fullStates, prevFullState, monitor);
                                TimeEventFilterDialog timeEventFilterDialog = AbstractStateSystemTimeGraphView.this.getTimeEventFilterDialog();
                                boolean hasActiveSavedFilters = timeEventFilterDialog.hasActiveSavedFilters();
                                if (eventList != null && !eventList.isEmpty() && !monitor.isCanceled()) {
                                    AbstractStateSystemTimeGraphView.this.doFilterEvents(entry, eventList, predicates);
                                    boolean dimmed = (event.getActiveProperties() & 1) == 1;
                                    boolean exclude = hasActiveSavedFilters;
                                    for (ITimeEvent e : eventList) {
                                        if (dimmed && (e.getActiveProperties() & 1) == 0) {
                                            event.setProperty(1, false);
                                            dimmed = false;
                                        }
                                        if (!exclude || (e.getActiveProperties() & 4) != 0) continue;
                                        event.setProperty(4, false);
                                        ZoomThreadByTime.this.applyResults(() -> entry.updateZoomedEvent(event));
                                        exclude = false;
                                    }
                                }
                            }
                        });
                    }
                    AbstractStateSystemTimeGraphView.this.refresh();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clearZoomedLists() {
            for (ITmfStateSystem ss : this.fZoomSSList) {
                List entryList = null;
                Map map = AbstractStateSystemTimeGraphView.this.fSSEntryListMap;
                synchronized (map) {
                    entryList = (List)AbstractStateSystemTimeGraphView.this.fSSEntryListMap.get(ss);
                }
                if (entryList == null) continue;
                for (TimeGraphEntry entry : entryList) {
                    this.clearZoomedList(entry);
                }
            }
            this.fClearZoomedLists = false;
        }

        private void clearZoomedList(TimeGraphEntry entry) {
            entry.setZoomedEventList(null);
            entry.setSampling(null);
            for (TimeGraphEntry child : entry.getChildren()) {
                this.clearZoomedList(child);
            }
        }

        private boolean isMember(TimeGraphEntry entry, List<TimeGraphEntry> ssEntryList) {
            TimeGraphEntry ssEntry = entry;
            while (ssEntry != null) {
                if (ssEntryList.contains(ssEntry)) {
                    return true;
                }
                ssEntry = ssEntry.getParent();
            }
            return false;
        }
    }
}

