/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownMemberClass;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownMemberClassInstance;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPUnknownMemberClassInstance;
import org.eclipse.core.runtime.CoreException;

public class CPPUnknownClassInstance
extends CPPUnknownMemberClass
implements ICPPUnknownMemberClassInstance {
    private final ICPPTemplateArgument[] arguments;

    public CPPUnknownClassInstance(IType scopeBinding, char[] name, ICPPTemplateArgument[] arguments) {
        super(scopeBinding, name);
        this.arguments = arguments;
    }

    @Override
    public ICPPTemplateArgument[] getArguments() {
        return this.arguments;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getName()) + " " + ASTTypeUtil.getArgumentListString(this.arguments, true);
    }

    @Override
    public boolean isSameType(IType type) {
        if (this == type) {
            return true;
        }
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (type instanceof ICPPUnknownMemberClassInstance) {
            ICPPUnknownMemberClassInstance rhs = (ICPPUnknownMemberClassInstance)type;
            if (CharArrayUtils.equals(this.getNameCharArray(), rhs.getNameCharArray())) {
                ICPPTemplateArgument[] rhsArgs;
                ICPPTemplateArgument[] lhsArgs = this.getArguments();
                if (lhsArgs != (rhsArgs = rhs.getArguments())) {
                    if (lhsArgs == null || rhsArgs == null) {
                        return false;
                    }
                    if (lhsArgs.length != rhsArgs.length) {
                        return false;
                    }
                    int i = 0;
                    while (i < lhsArgs.length) {
                        if (!lhsArgs[i].isSameValue(rhsArgs[i])) {
                            return false;
                        }
                        ++i;
                    }
                }
                IType lhsContainer = this.getOwnerType();
                IType rhsContainer = rhs.getOwnerType();
                if (lhsContainer != null && rhsContainer != null) {
                    return lhsContainer.isSameType(rhsContainer);
                }
            }
        }
        return false;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer) throws CoreException {
        short firstBytes = 13;
        buffer.putShort(firstBytes);
        buffer.marshalType(this.getOwnerType());
        buffer.putCharArray(this.getNameCharArray());
        buffer.putInt(this.arguments.length);
        ICPPTemplateArgument[] iCPPTemplateArgumentArray = this.arguments;
        int n = this.arguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPTemplateArgument arg = iCPPTemplateArgumentArray[n2];
            buffer.marshalTemplateArgument(arg);
            ++n2;
        }
    }

    public static ICPPUnknownMemberClassInstance unmarshal(IIndexFragment fragment, short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        IType owner = buffer.unmarshalType();
        char[] name = buffer.getCharArray();
        int argcount = buffer.getInt();
        ICPPTemplateArgument[] args = new ICPPTemplateArgument[argcount];
        int i = 0;
        while (i < argcount) {
            args[i] = buffer.unmarshalTemplateArgument();
            ++i;
        }
        return new PDOMCPPUnknownMemberClassInstance(fragment, owner, name, args);
    }
}

