/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.filter;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.internal.tmf.core.filter.TmfFilterHelper;
import org.eclipse.tracecompass.tmf.core.filter.ITmfFilter;

@NonNullByDefault
public class TraceCompassFilter {
    private final ITmfFilter fEventFilter;
    private final String fRegex;

    private TraceCompassFilter(ITmfFilter filter, String regex) {
        this.fEventFilter = filter;
        this.fRegex = regex;
    }

    public static TraceCompassFilter fromEventFilter(ITmfFilter filter) {
        return new TraceCompassFilter(filter, TmfFilterHelper.getRegexFromFilter(filter));
    }

    public static TraceCompassFilter fromRegex(String regex) {
        return new TraceCompassFilter(TmfFilterHelper.buildFilterFromRegex(regex), regex);
    }

    public ITmfFilter getEventFilter() {
        return this.fEventFilter;
    }

    public String getRegex() {
        return this.fRegex;
    }
}

