/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.pcap.core.tests.protocol.unknown;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import org.eclipse.tracecompass.internal.pcap.core.protocol.PcapProtocol;
import org.eclipse.tracecompass.internal.pcap.core.protocol.unknown.UnknownEndpoint;
import org.eclipse.tracecompass.internal.pcap.core.protocol.unknown.UnknownPacket;
import org.eclipse.tracecompass.internal.pcap.core.trace.BadPcapFileException;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapFile;
import org.eclipse.tracecompass.pcap.core.tests.shared.PcapTestTrace;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class UnknownPacketTest {
    private static final Map<String, String> EXPECTED_FIELDS = ImmutableMap.of((Object)"Binary", (Object)"61", (Object)"Character", (Object)"a");
    private static final String fToString = "Payload: 61";
    private ByteBuffer fPacket;

    @Before
    public void initialize() {
        this.fPacket = ByteBuffer.allocate(1);
        this.fPacket.order(ByteOrder.BIG_ENDIAN);
        this.fPacket.put((byte)97);
        this.fPacket.flip();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void CompleteUnknownPacketTest() throws IOException, BadPcapFileException {
        PcapTestTrace trace = PcapTestTrace.MOSTLY_TCP;
        Assume.assumeTrue((boolean)trace.exists());
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            PcapFile dummy = new PcapFile(trace.getPath());
            try {
                ByteBuffer byteBuffer = this.fPacket;
                if (byteBuffer == null) {
                    Assert.fail((String)"CompleteUnknownPacketTest has failed!");
                    return;
                }
                UnknownPacket packet = new UnknownPacket(dummy, null, byteBuffer);
                Assert.assertEquals((Object)PcapProtocol.UNKNOWN, (Object)packet.getProtocol());
                Assert.assertTrue((boolean)packet.hasProtocol(PcapProtocol.UNKNOWN));
                Assert.assertFalse((boolean)packet.hasProtocol(PcapProtocol.UDP));
                Assert.assertTrue((boolean)packet.validate());
                Assert.assertEquals((long)1089L, (long)packet.hashCode());
                Assert.assertFalse((boolean)packet.equals(null));
                Assert.assertEquals((Object)new UnknownPacket(dummy, null, byteBuffer), (Object)packet);
                Assert.assertEquals(EXPECTED_FIELDS, (Object)packet.getFields());
                Assert.assertEquals((Object)fToString, (Object)packet.toString());
                Assert.assertEquals((Object)"Len: 1 bytes", (Object)packet.getLocalSummaryString());
                Assert.assertEquals((Object)"Data: 1 bytes", (Object)packet.getGlobalSummaryString());
                Assert.assertFalse((boolean)packet.getSourceEndpoint().equals((Object)new UnknownEndpoint(packet, true)));
                Assert.assertFalse((boolean)packet.getDestinationEndpoint().equals((Object)new UnknownEndpoint(packet, false)));
                this.fPacket.position(0);
                byte[] payload = new byte[1];
                this.fPacket.get(payload);
                ByteBuffer payloadBB = ByteBuffer.wrap(payload);
                payloadBB.flip();
                Assert.assertEquals((Object)payloadBB, (Object)packet.getPayload());
                return;
            }
            finally {
                if (dummy == null) return;
                dummy.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }
}

