/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.model;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternAnalysis;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.segment.TmfXmlPatternSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestFiles;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.module.XmlUtilsTest;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.stateprovider.XmlModuleTestBase;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FsmTest {
    private static final int END_TIME = 7;
    private static final @NonNull String TEST_TRACE = "test_traces/testTrace4.xml";
    private static final String TEST_SEGMENT_NEW = "seg_NEW";
    private static final TmfXmlTestFiles TEST_FILE_1 = TmfXmlTestFiles.INITIAL_STATE_ELEMENT_TEST_FILE_1;
    private static final TmfXmlTestFiles TEST_FILE_2 = TmfXmlTestFiles.INITIAL_STATE_ELEMENT_TEST_FILE_2;
    private static XmlPatternAnalysis fModule;
    private static XmlPatternAnalysis fModule2;
    private static ITmfTrace fTrace;

    private static XmlPatternAnalysis createModule(@NonNull Element element, TmfXmlTestFiles file) {
        XmlPatternAnalysis module = new XmlPatternAnalysis();
        module.setXmlFile(file.getFile().toPath());
        module.setName(XmlModuleTestBase.getName(element));
        return module;
    }

    private static XmlPatternAnalysis initModule(TmfXmlTestFiles file) {
        Document doc = file.getXmlDocument();
        Assert.assertNotNull((Object)doc);
        NodeList stateproviderNodes = doc.getElementsByTagName("pattern");
        Element node = (Element)stateproviderNodes.item(0);
        Assert.assertNotNull((Object)node);
        XmlPatternAnalysis module = FsmTest.createModule(node, file);
        String moduleId = node.getAttribute("id");
        Assert.assertNotNull((Object)moduleId);
        module.setId(moduleId);
        return module;
    }

    @AfterClass
    public static void tearDown() {
        fModule.dispose();
        fModule2.dispose();
        fTrace.dispose();
    }

    @BeforeClass
    public static void before() {
        ITmfTrace trace = XmlUtilsTest.initializeTrace(TEST_TRACE);
        fModule = FsmTest.initModule(TEST_FILE_1);
        try {
            fModule.setTrace(trace);
            fModule.schedule();
            Assert.assertTrue((boolean)fModule.waitForCompletion((IProgressMonitor)new NullProgressMonitor()));
        }
        catch (TmfAnalysisException e) {
            Assert.fail((String)("Cannot execute analyses " + e.getMessage()));
        }
        fModule2 = FsmTest.initModule(TEST_FILE_2);
        try {
            fModule2.setTrace(trace);
            fModule2.schedule();
            Assert.assertTrue((boolean)fModule2.waitForCompletion((IProgressMonitor)new NullProgressMonitor()));
        }
        catch (TmfAnalysisException e) {
            Assert.fail((String)("Cannot execute analyses " + e.getMessage()));
        }
        fTrace = trace;
    }

    @Test
    public void testInitialStateDeclaration() {
        ITmfStateSystem stateSystem = fModule.getStateSystem(fModule.getId());
        Assert.assertNotNull((String)"state system exist", (Object)stateSystem);
        try {
            int quark = stateSystem.getQuarkAbsolute(new String[]{"fsm1"});
            @NonNull ITmfStateInterval interval = stateSystem.querySingleState(7L, quark);
            long count1 = interval.getStateValue().unboxLong();
            quark = stateSystem.getQuarkAbsolute(new String[]{"fsm2"});
            interval = stateSystem.querySingleState(7L, quark);
            long count2 = interval.getStateValue().unboxLong();
            Assert.assertTrue((String)"Test the count value", (count1 == count2 ? 1 : 0) != 0);
        }
        catch (AttributeNotFoundException | StateSystemDisposedException e) {
            Assert.fail((String)"Failed to query the state system");
        }
    }

    @Test
    public void testInitialStateWithCondition() {
        ITmfStateSystem stateSystem = fModule.getStateSystem(fModule.getId());
        Assert.assertNotNull((String)"state system exist", (Object)stateSystem);
        try {
            int quark = stateSystem.getQuarkAbsolute(new String[]{"fsm1"});
            @NonNull ITmfStateInterval interval = stateSystem.querySingleState(7L, quark);
            long count1 = interval.getStateValue().unboxLong();
            quark = stateSystem.getQuarkAbsolute(new String[]{"fsm3"});
            interval = stateSystem.querySingleState(7L, quark);
            long count3 = interval.getStateValue().unboxLong();
            Assert.assertTrue((String)"Test the count value", (count1 > count3 ? 1 : 0) != 0);
        }
        catch (AttributeNotFoundException | StateSystemDisposedException e) {
            Assert.fail((String)"Failed to query the state system");
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testTwoInitialStates() {
        int quark;
        @Nullable @NonNull ISegmentStore ss = fModule2.getSegmentStore();
        Assert.assertNotNull((String)"segment store exist", (Object)ss);
        Assert.assertTrue((String)"Segment store not empty", (ss.size() == 1 ? 1 : 0) != 0);
        Object item = ss.iterator().next();
        Assert.assertTrue((boolean)(item instanceof TmfXmlPatternSegment));
        Assert.assertTrue((boolean)((TmfXmlPatternSegment)item).getName().equals(TEST_SEGMENT_NEW));
        ITmfStateSystem stateSystem = fModule2.getStateSystem(fModule2.getId());
        Assert.assertNotNull((String)"state system exist", (Object)stateSystem);
        try {
            quark = stateSystem.getQuarkAbsolute(new String[]{"count_new"});
            @NonNull ITmfStateInterval interval = stateSystem.querySingleState(7L, quark);
            int count = interval.getStateValue().unboxInt();
            Assert.assertTrue((String)"Test the count value", (count > 0 ? 1 : 0) != 0);
        }
        catch (AttributeNotFoundException | StateSystemDisposedException e) {
            Assert.fail((String)"Failed to query the state system");
        }
        try {
            quark = stateSystem.getQuarkAbsolute(new String[]{"precond"});
        }
        catch (AttributeNotFoundException e) {
            return;
        }
        Assert.fail();
    }
}

