/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.actions;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.core.tests.TmfCoreTestPlugin;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimePreferences;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;
import org.eclipse.tracecompass.tmf.ui.actions.TraceImportOperation;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.ui.PlatformUI;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TraceImportOperationTest {
    private static String fSourcePath;
    private static TmfTraceFolder fTracesFolder;
    private static TmfTraceFolder fDestFolder;

    @BeforeClass
    public static void beforeClass() throws Exception {
        URL resource = TmfCoreTestPlugin.getDefault().getBundle().getResource("testfiles");
        fSourcePath = FileLocator.toFileURL((URL)resource).toURI().getPath();
        IProject project = TmfProjectRegistry.createProject((String)"Test Project", null, null);
        TmfProjectElement projectElement = TmfProjectRegistry.getProject((IProject)project, (boolean)true);
        fTracesFolder = (TmfTraceFolder)NonNullUtils.checkNotNull((Object)projectElement.getTracesFolder());
        fTracesFolder.getResource().getFolder("Folder").create(false, true, null);
        fTracesFolder.refresh();
        fDestFolder = (TmfTraceFolder)fTracesFolder.getChild("Folder");
        Assert.assertNotNull((Object)fDestFolder);
    }

    @AfterClass
    public static void afterClass() throws CoreException {
        if (fDestFolder != null) {
            fDestFolder.getProject().getResource().delete(true, null);
        }
    }

    @Test
    public void test() throws Exception {
        TraceImportOperation operation = new TraceImportOperation(fSourcePath, fDestFolder);
        PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)operation);
        Assert.assertEquals((long)9L, (long)fDestFolder.getTraces().size());
        TraceImportOperationTest.validateImport(fSourcePath, fDestFolder, true);
    }

    @Test
    public void testSkipArchiveExtraction() throws Exception {
        IFolder sourceFolder = fDestFolder.getProject().getResource().getFolder("testfiles");
        sourceFolder.create(false, true, null);
        File archive = new File(sourceFolder.getFile("testfiles.zip").getLocation().toOSString());
        TraceImportOperationTest.createArchive(fSourcePath, archive);
        fTracesFolder.getResource().getFolder("skipFalse").create(false, true, null);
        TmfTraceFolder destFolder = (TmfTraceFolder)fTracesFolder.getChild("skipFalse");
        TraceImportOperation operation = new TraceImportOperation(sourceFolder.getLocation().toOSString(), destFolder);
        operation.setSkipArchiveExtraction(false);
        PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)operation);
        Assert.assertEquals((long)1L, (long)destFolder.getChildren().size());
        Assert.assertTrue((boolean)(destFolder.getChildren().get(0) instanceof TmfTraceFolder));
        destFolder = (TmfTraceFolder)destFolder.getChildren().get(0);
        Assert.assertEquals((Object)"testfiles.zip", (Object)destFolder.getName());
        Assert.assertEquals((long)9L, (long)destFolder.getTraces().size());
        TraceImportOperationTest.validateImport(fSourcePath, destFolder, false);
        fTracesFolder.getResource().getFolder("skipTrue").create(false, true, null);
        destFolder = (TmfTraceFolder)fTracesFolder.getChild("skipTrue");
        operation = new TraceImportOperation(sourceFolder.getLocation().toOSString(), destFolder);
        operation.setSkipArchiveExtraction(true);
        PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)operation);
        Assert.assertEquals((long)0L, (long)destFolder.getTraces().size());
        TraceImportOperationTest.validateImport(sourceFolder.getLocation().toOSString(), destFolder, true);
    }

    @Test
    public void testTimeRangeFiltering() throws Exception {
        IFolder sourceFolder = fDestFolder.getProject().getResource().getFolder("syslogFiles");
        sourceFolder.create(false, true, null);
        for (File file : FileUtils.listFiles((File)new File(fSourcePath), null, (boolean)false)) {
            if (!file.getName().matches("syslog[1-6]")) continue;
            FileUtils.copyFileToDirectory((File)file, (File)new File(sourceFolder.getLocation().toOSString()));
        }
        fTracesFolder.getResource().getFolder("timeFiltering").create(false, true, null);
        TmfTraceFolder destFolder = (TmfTraceFolder)fTracesFolder.getChild("timeFiltering");
        ITmfTimestamp startTimeRange = TraceImportOperationTest.parse("Jan 1 02:00:00");
        ITmfTimestamp endTimeRange = TraceImportOperationTest.parse("Jan 1 05:05:00");
        TraceImportOperation operation = new TraceImportOperation(sourceFolder.getLocation().toOSString(), destFolder);
        operation.setFilteringTimeRange(startTimeRange, endTimeRange);
        PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)operation);
        Assert.assertEquals((long)4L, (long)destFolder.getTraces().size());
        TraceImportOperationTest.validateImport(sourceFolder.getLocation().toOSString(), destFolder, true);
    }

    private static void validateImport(String sourcePath, TmfTraceFolder destFolder, boolean isLinked) {
        File[] files;
        HashMap map = new HashMap();
        destFolder.getChildren().forEach(element -> {
            ITmfProjectModelElement iTmfProjectModelElement = map.put(element.getName(), element);
        });
        File source = new File(sourcePath);
        File[] fileArray = files = source.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            ITmfProjectModelElement element2 = (ITmfProjectModelElement)map.get(file.getName());
            if (element2 != null) {
                if (file.isDirectory()) {
                    Assert.assertTrue((String)file.toString(), (boolean)(element2 instanceof TmfTraceFolder));
                    TraceImportOperationTest.validateImport(file.getAbsolutePath(), (TmfTraceFolder)element2, isLinked);
                } else {
                    Assert.assertTrue((String)file.toString(), (boolean)(element2 instanceof TmfTraceElement));
                    TmfTraceElement traceElement = (TmfTraceElement)element2;
                    Assert.assertNotNull((String)file.toString(), (Object)traceElement.getTraceType());
                    Assert.assertEquals((String)file.toString(), (Object)isLinked, (Object)traceElement.getResource().isLinked());
                }
            }
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void createArchive(String sourcePath, File archive) throws FileNotFoundException, IOException, ArchiveException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            FileOutputStream out = new FileOutputStream(archive);
            try {
                try (ArchiveOutputStream archiveOutputStream = new ArchiveStreamFactory().createArchiveOutputStream("zip", (OutputStream)out);){
                    for (File file : FileUtils.listFiles((File)new File(sourcePath), null, (boolean)true)) {
                        String name = file.getAbsolutePath().substring(sourcePath.length());
                        archiveOutputStream.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(name));
                        Throwable throwable2 = null;
                        Object var10_14 = null;
                        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                            IOUtils.copy((InputStream)in, (OutputStream)archiveOutputStream);
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                                throw throwable2;
                            } else {
                                if (throwable2 == throwable3) throw throwable2;
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                        archiveOutputStream.closeArchiveEntry();
                    }
                    archiveOutputStream.finish();
                }
                if (out == null) return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                if (out == null) throw throwable;
                ((OutputStream)out).close();
                throw throwable;
            }
            ((OutputStream)out).close();
            return;
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            } else {
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    private static ITmfTimestamp parse(String time) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd HH:mm:ss", TmfTimePreferences.getLocale());
        dateFormat.setTimeZone(TmfTimestampFormat.getDefaulTimeFormat().getTimeZone());
        Date date = dateFormat.parse(time);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.set(1, Calendar.getInstance().get(1));
        if (calendar.after(Calendar.getInstance())) {
            calendar.set(1, Calendar.getInstance().get(1) - 1);
        }
        return TmfTimestamp.fromMillis((long)calendar.getTimeInMillis());
    }
}

