/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.common.core;

import java.util.Arrays;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class NonNullUtils {
    private NonNullUtils() {
    }

    public static String nullToEmptyString(@Nullable Object obj) {
        if (obj == null) {
            return "";
        }
        String str = obj.toString();
        return str == null ? "" : str;
    }

    public static <T> @NonNull T checkNotNull(@Nullable T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    public static <T> Stream<@NonNull T> checkNotNullContents(@Nullable Stream<T> stream) {
        if (stream == null) {
            throw new NullPointerException();
        }
        return NonNullUtils.checkNotNull(stream.map(t -> NonNullUtils.checkNotNull(t)));
    }

    public static <T> @NonNull T[] checkNotNullContents(T @Nullable [] array) {
        if (array == null) {
            throw new NullPointerException();
        }
        Arrays.stream(array).forEach(elem -> {
            Object object = NonNullUtils.checkNotNull(elem);
        });
        @NonNull T[] ret = array;
        return ret;
    }
}

