/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.viewers.statistics;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.piecharts.TmfPieChartViewer;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.piecharts.model.TmfPieChartStatisticsModel;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.statistics.StatisticsUpdateJob;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.statistics.model.TmfBaseColumnData;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.statistics.model.TmfBaseColumnDataProvider;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.statistics.model.TmfStatisticsFormatter;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.statistics.model.TmfStatisticsTree;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.statistics.model.TmfStatisticsTreeManager;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.statistics.model.TmfStatisticsTreeNode;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.statistics.model.TmfTreeContentProvider;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.statistics.TmfStatisticsModule;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.ui.TmfUiRefreshHandler;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfViewer;

public class TmfStatisticsViewer
extends TmfViewer {
    private TreeViewer fTreeViewer;
    private final Object fStatisticsRangeUpdateSyncObj = new Object();
    private TmfStatisticsTree fStatisticsData;
    private ITmfTrace fTrace;
    private boolean fProcessAll;
    private static int fCountInstance = 0;
    private int fInstanceNb;
    private Cursor fWaitCursor = null;
    private int fWaitCursorCount = 0;
    private boolean fSendRangeRequest = true;
    private final Map<ITmfTrace, Job> fUpdateJobsPartial = new HashMap<ITmfTrace, Job>();
    private final Map<ITmfTrace, Job> fUpdateJobsGlobal = new HashMap<ITmfTrace, Job>();
    private TmfPieChartViewer fPieChartViewer;
    private SashForm fSash;
    private TmfPieChartStatisticsModel fPieChartModel;

    public TmfStatisticsViewer(Composite parent, String viewerName, ITmfTrace trace) {
        this.init(parent, viewerName, trace);
    }

    public void init(Composite parent, String viewerName, ITmfTrace trace) {
        super.init(parent, viewerName);
        this.fInstanceNb = ++fCountInstance;
        this.fTrace = trace;
        this.fProcessAll = trace instanceof TmfExperiment;
        this.initContent(parent);
        this.initInput();
        this.fSash.addDisposeListener(e -> this.internalDispose());
    }

    public void dispose() {
        this.fSash.dispose();
    }

    private void internalDispose() {
        super.dispose();
        if (this.fWaitCursor != null) {
            this.fWaitCursor.dispose();
        }
        for (Job j : this.fUpdateJobsGlobal.values()) {
            j.cancel();
        }
        for (Job j : this.fUpdateJobsPartial.values()) {
            j.cancel();
        }
        TmfStatisticsTreeManager.removeStatTreeRoot(this.getTreeID());
        this.fPieChartViewer.reinitializeCharts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TmfSignalHandler
    public void traceRangeUpdated(TmfTraceRangeUpdatedSignal signal) {
        ITmfTrace trace = signal.getTrace();
        if (!this.isListeningTo(trace)) {
            return;
        }
        Object object = this.fStatisticsRangeUpdateSyncObj;
        synchronized (object) {
            if (this.fSendRangeRequest) {
                this.fSendRangeRequest = false;
                TmfTraceContext ctx = TmfTraceManager.getInstance().getCurrentTraceContext();
                TmfTimeRange timeRange = ctx.getSelectionRange();
                this.requestTimeRangeData(trace, timeRange);
            }
        }
        this.requestData(trace, signal.getRange());
    }

    @TmfSignalHandler
    public void timeSynchUpdated(TmfSelectionRangeUpdatedSignal signal) {
        ITmfTimestamp end;
        if (this.fTrace == null) {
            return;
        }
        ITmfTimestamp begin = signal.getBeginTime();
        TmfTimeRange timeRange = begin.compareTo(end = signal.getEndTime()) <= 0 ? new TmfTimeRange(begin, end) : new TmfTimeRange(end, begin);
        this.requestTimeRangeData(this.fTrace, timeRange);
    }

    @Override
    public Control getControl() {
        return this.fSash;
    }

    public Object getInput() {
        return this.fTreeViewer.getInput();
    }

    public TmfStatisticsTree getStatisticData() {
        if (this.fStatisticsData == null) {
            this.fStatisticsData = new TmfStatisticsTree();
        }
        return this.fStatisticsData;
    }

    public TmfPieChartStatisticsModel getPieChartModel() {
        if (this.fPieChartModel == null) {
            this.fPieChartModel = new TmfPieChartStatisticsModel();
        }
        return this.fPieChartModel;
    }

    public String getTreeID() {
        return String.valueOf(this.getName()) + this.fInstanceNb;
    }

    @Override
    public void refresh() {
        Control viewerControl = this.getControl();
        if (viewerControl.isDisposed()) {
            return;
        }
        this.refreshTree();
        this.refreshPieCharts(true, true);
    }

    private void refreshTree() {
        final Control viewerControl = this.getControl();
        if (viewerControl.isDisposed()) {
            return;
        }
        TmfUiRefreshHandler.getInstance().queueUpdate(this.fTreeViewer, new Runnable(){

            @Override
            public void run() {
                if (!viewerControl.isDisposed()) {
                    TmfStatisticsViewer.this.fTreeViewer.refresh();
                }
            }
        });
    }

    protected void refreshPieCharts(final boolean refreshGlobal, final boolean refreshSelection) {
        final Control viewerControl = this.getControl();
        if (viewerControl.isDisposed()) {
            return;
        }
        TmfPieChartStatisticsModel pieChartModel = this.getPieChartModel();
        if (pieChartModel == null || pieChartModel.getPieChartGlobalModel() == null) {
            return;
        }
        boolean moreThanOne = false;
        for (Map.Entry<ITmfTrace, Map<String, Long>> entry : pieChartModel.getPieChartGlobalModel().entrySet()) {
            if (entry.getValue() == null || entry.getValue().size() <= 1) continue;
            moreThanOne = true;
            break;
        }
        this.setPieChartsVisible(moreThanOne);
        TmfUiRefreshHandler.getInstance().queueUpdate((Object)this.fPieChartViewer, new Runnable(){

            @Override
            public void run() {
                if (!viewerControl.isDisposed()) {
                    TmfStatisticsViewer.this.fPieChartViewer.refresh(refreshGlobal, refreshSelection);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPartialRequestOnNextUpdate() {
        Object object = this.fStatisticsRangeUpdateSyncObj;
        synchronized (object) {
            this.fSendRangeRequest = true;
        }
    }

    public void setFocus() {
        this.fTreeViewer.getTree().setFocus();
    }

    protected void cancelOngoingRequest(ITmfEventRequest request) {
        if (request != null && !request.isCompleted()) {
            request.cancel();
        }
    }

    protected TmfBaseColumnDataProvider getColumnDataProvider() {
        return new TmfBaseColumnDataProvider();
    }

    protected void initContent(Composite parent) {
        final List<TmfBaseColumnData> columnDataList = this.getColumnDataProvider().getColumnData();
        this.fSash = new SashForm(parent, 256);
        this.fTreeViewer = new TreeViewer((Composite)this.fSash, 2816);
        this.fPieChartViewer = new TmfPieChartViewer((Composite)this.fSash);
        this.fPieChartViewer.addEventTypeSelectionListener(new Listener(){

            public void handleEvent(Event event) {
                String eventTypeName = event.text;
                if (TmfStatisticsViewer.this.getStatisticData().getRootNode() == null || TmfStatisticsViewer.this.fTreeViewer.getTree() == null) {
                    return;
                }
                List nodes = (List)TmfStatisticsViewer.this.getStatisticData().getRootNode().findChildren(eventTypeName, true);
                if (nodes.isEmpty()) {
                    return;
                }
                TmfStatisticsViewer.this.fTreeViewer.setSelection((ISelection)new StructuredSelection(nodes.get(0)), true);
            }
        });
        this.fSash.setWeights(new int[]{100, 100});
        this.fTreeViewer.setContentProvider((IContentProvider)new TmfTreeContentProvider());
        this.fTreeViewer.getTree().setHeaderVisible(true);
        this.fTreeViewer.setUseHashlookup(true);
        for (final TmfBaseColumnData columnData : columnDataList) {
            final TreeViewerColumn treeColumn = new TreeViewerColumn(this.fTreeViewer, columnData.getAlignment());
            treeColumn.getColumn().setText(columnData.getHeader());
            treeColumn.getColumn().setWidth(columnData.getWidth());
            treeColumn.getColumn().setToolTipText(columnData.getTooltip());
            if (columnData == columnDataList.get(TmfBaseColumnDataProvider.StatsColumn.DUMMY.getIndex())) {
                treeColumn.getColumn().setResizable(false);
            }
            if (columnData.getComparator() != null) {
                treeColumn.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){
                    private ViewerComparator reverseComparator;

                    public void widgetSelected(SelectionEvent e) {
                        if (this.reverseComparator == null) {
                            this.reverseComparator = new ViewerComparator(){

                                public int compare(Viewer viewer, Object e1, Object e2) {
                                    return -1 * columnData.getComparator().compare(viewer, e1, e2);
                                }
                            };
                        }
                        if (TmfStatisticsViewer.this.fTreeViewer.getTree().getSortDirection() == 128 || TmfStatisticsViewer.this.fTreeViewer.getTree().getSortColumn() != treeColumn.getColumn()) {
                            TmfStatisticsViewer.this.fTreeViewer.setComparator(columnData.getComparator());
                            TmfStatisticsViewer.this.fTreeViewer.getTree().setSortDirection(1024);
                        } else {
                            TmfStatisticsViewer.this.fTreeViewer.setComparator(this.reverseComparator);
                            TmfStatisticsViewer.this.fTreeViewer.getTree().setSortDirection(128);
                        }
                        TmfStatisticsViewer.this.fTreeViewer.getTree().setSortColumn(treeColumn.getColumn());
                    }
                });
            }
            treeColumn.setLabelProvider((CellLabelProvider)columnData.getLabelProvider());
        }
        this.fTreeViewer.getTree().addListener(40, new Listener(){

            public void handleEvent(Event event) {
                if (((TmfBaseColumnData)columnDataList.get(event.index)).getPercentageProvider() != null) {
                    long eventValue;
                    TmfStatisticsTreeNode node = (TmfStatisticsTreeNode)event.item.getData();
                    if (TmfBaseColumnDataProvider.HIDDEN_FOLDER_LEVELS.contains(node.getName())) {
                        return;
                    }
                    double percentage = ((TmfBaseColumnData)columnDataList.get(event.index)).getPercentageProvider().getPercentage(node);
                    if ((event.detail & 2) > 0) {
                        event.gc.fillRectangle(event.x, event.y, event.width, event.height);
                        event.detail &= 0xFFFFFFFD;
                    }
                    if (event.index != TmfBaseColumnDataProvider.StatsColumn.TOTAL.getIndex() && event.index != TmfBaseColumnDataProvider.StatsColumn.PARTIAL.getIndex() || node == node.getTop()) {
                        return;
                    }
                    long l = eventValue = event.index == TmfBaseColumnDataProvider.StatsColumn.TOTAL.getIndex() ? node.getTop().getValues().getTotal() : node.getTop().getValues().getPartial();
                    if (eventValue != 0L) {
                        int oldAlpha = event.gc.getAlpha();
                        Color oldForeground = event.gc.getForeground();
                        Color oldBackground = event.gc.getBackground();
                        if (percentage != 0.0) {
                            int barWidth = (int)((double)(TmfStatisticsViewer.this.fTreeViewer.getTree().getColumn(event.index).getWidth() - 8) * percentage);
                            event.gc.setAlpha(64);
                            event.gc.setForeground(event.item.getDisplay().getSystemColor(9));
                            event.gc.setBackground(event.item.getDisplay().getSystemColor(25));
                            event.gc.fillGradientRectangle(event.x, event.y, barWidth, event.height, true);
                            event.gc.drawRectangle(event.x, event.y, barWidth, event.height);
                            event.gc.setBackground(oldBackground);
                            event.gc.setAlpha(oldAlpha);
                            event.detail &= 0xFFFFFFF7;
                        }
                        String percentageText = TmfStatisticsFormatter.toPercentageText(percentage);
                        String absoluteNumberText = TmfStatisticsFormatter.toColumnData(node, TmfBaseColumnDataProvider.StatsColumn.getColumn(event.index));
                        if (event.width > event.gc.stringExtent((String)percentageText).x + event.gc.stringExtent((String)absoluteNumberText).x) {
                            int textHeight = event.gc.stringExtent((String)percentageText).y;
                            event.gc.setForeground(event.item.getDisplay().getSystemColor(16));
                            event.gc.drawText(percentageText, event.x, event.y + (event.height - textHeight) / 2, true);
                        }
                        event.gc.setForeground(oldForeground);
                    }
                }
            }
        });
        this.fTreeViewer.setComparator(columnDataList.get(0).getComparator());
        this.fTreeViewer.getTree().setSortColumn(this.fTreeViewer.getTree().getColumn(0));
        this.fTreeViewer.getTree().setSortDirection(1024);
    }

    protected void initInput() {
        TmfStatisticsTreeNode statisticsTreeNode;
        String treeID = this.getTreeID();
        if (TmfStatisticsTreeManager.containsTreeRoot(treeID)) {
            statisticsTreeNode = TmfStatisticsTreeManager.getStatTreeRoot(treeID);
            int numNodeTraces = statisticsTreeNode.getNbChildren();
            Collection traces = TmfTraceManager.getTraceSet((ITmfTrace)this.fTrace);
            int numTraces = traces.size();
            if (numTraces == numNodeTraces) {
                boolean same = true;
                for (ITmfTrace trace : traces) {
                    String traceName = trace.getName();
                    if (statisticsTreeNode.containsChild(traceName)) continue;
                    same = false;
                    break;
                }
                if (same) {
                    this.fTreeViewer.setInput((Object)statisticsTreeNode);
                    return;
                }
                statisticsTreeNode.reset();
            }
        } else {
            statisticsTreeNode = TmfStatisticsTreeManager.addStatsTreeRoot(treeID, this.getStatisticData());
        }
        this.fTreeViewer.setInput((Object)statisticsTreeNode);
        this.fPieChartViewer.setInput(this.getPieChartModel());
    }

    protected boolean isListeningTo(ITmfTrace trace) {
        return this.fProcessAll || trace == this.fTrace;
    }

    protected void modelComplete(boolean global) {
        this.refreshTree();
        this.waitCursor(false);
    }

    protected void requestData(ITmfTrace trace, TmfTimeRange timeRange) {
        this.buildStatisticsTree(trace, timeRange, true);
    }

    protected void requestTimeRangeData(ITmfTrace trace, TmfTimeRange timeRange) {
        this.buildStatisticsTree(trace, timeRange, false);
    }

    private void buildStatisticsTree(ITmfTrace trace, TmfTimeRange timeRange, boolean isGlobal) {
        TmfStatisticsTree statsData = TmfStatisticsTreeManager.getStatTree(this.getTreeID());
        if (statsData == null) {
            return;
        }
        Map<ITmfTrace, Job> updateJobs = isGlobal ? this.fUpdateJobsGlobal : this.fUpdateJobsPartial;
        for (ITmfTrace aTrace : TmfTraceManager.getTraceSet((ITmfTrace)trace)) {
            Job job;
            TmfStatisticsModule statsMod;
            if (!this.isListeningTo(aTrace) || (statsMod = (TmfStatisticsModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)aTrace, TmfStatisticsModule.class, (String)"org.eclipse.linuxtools.tmf.core.statistics.analysis")) == null || (job = updateJobs.get(aTrace)) != null) continue;
            job = new StatisticsUpdateJob("Statistics update", aTrace, isGlobal, timeRange, statsMod, this);
            updateJobs.put(aTrace, job);
            job.setSystem(true);
            job.schedule();
        }
    }

    private void setPieChartsVisible(final boolean visible) {
        if (this.fPieChartViewer.isDisposed()) {
            return;
        }
        TmfUiRefreshHandler.getInstance().queueUpdate((Object)this.fPieChartViewer, new Runnable(){

            @Override
            public void run() {
                if (!TmfStatisticsViewer.this.fPieChartViewer.isDisposed()) {
                    TmfStatisticsViewer.this.fPieChartViewer.setVisible(visible);
                    TmfStatisticsViewer.this.fPieChartViewer.getParent().layout();
                }
            }
        });
    }

    protected void resetTimeRangeValue() {
        TmfStatisticsTreeNode treeModelRoot = TmfStatisticsTreeManager.getStatTreeRoot(this.getTreeID());
        if (treeModelRoot != null && treeModelRoot.hasChildren()) {
            treeModelRoot.resetTimeRangeValue();
        }
    }

    protected void waitCursor(final boolean waitRequested) {
        if (this.fTreeViewer == null || this.fTreeViewer.getTree().isDisposed()) {
            return;
        }
        boolean needsUpdate = false;
        Display display = this.fTreeViewer.getControl().getDisplay();
        if (waitRequested) {
            ++this.fWaitCursorCount;
            if (this.fWaitCursor == null) {
                this.fWaitCursor = new Cursor((Device)display, 1);
            }
            if (this.fWaitCursorCount == 1) {
                needsUpdate = true;
            }
        } else if (this.fWaitCursorCount > 0) {
            --this.fWaitCursorCount;
            if (this.fWaitCursorCount == 0) {
                needsUpdate = true;
            }
        }
        if (needsUpdate) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (TmfStatisticsViewer.this.fTreeViewer != null && !TmfStatisticsViewer.this.fTreeViewer.getTree().isDisposed()) {
                        Cursor cursor = null;
                        if (waitRequested) {
                            cursor = TmfStatisticsViewer.this.fWaitCursor;
                        }
                        TmfStatisticsViewer.this.fTreeViewer.getControl().setCursor(cursor);
                    }
                }
            });
        }
    }

    void removeFromJobs(boolean isGlobal, ITmfTrace jobTrace) {
        Map<ITmfTrace, Job> updateJobs = isGlobal ? this.fUpdateJobsGlobal : this.fUpdateJobsPartial;
        Job job = updateJobs.remove(jobTrace);
        if (job != null) {
            job.cancel();
        }
    }
}

