/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.IDataDrivenRuntimeObject;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValue;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.IAnalysisDataContainer;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public abstract class DataDrivenCondition
implements IDataDrivenRuntimeObject {
    public abstract boolean test(ITmfEvent var1, DataDrivenScenarioInfo var2, IAnalysisDataContainer var3);

    public static enum ConditionOperator implements Predicate<Integer>
    {
        EQ(i -> i == 0),
        NE(i -> i != 0),
        GE(i -> i >= 0),
        GT(i -> i > 0),
        LE(i -> i <= 0),
        LT(i -> i < 0);

        private final Function<Integer, Boolean> fCmpFunction;

        private ConditionOperator(Function<Integer, Boolean> cmpFunction) {
            this.fCmpFunction = cmpFunction;
        }

        @Override
        public boolean test(Integer cmpValue) {
            return Objects.requireNonNull(this.fCmpFunction.apply(cmpValue));
        }
    }

    public static class DataDrivenAndCondition
    extends DataDrivenCondition {
        private final List<DataDrivenCondition> fConditions;

        public DataDrivenAndCondition(List<DataDrivenCondition> conditions) {
            this.fConditions = conditions;
        }

        @Override
        public boolean test(ITmfEvent event, DataDrivenScenarioInfo scenarioInfo, IAnalysisDataContainer container) {
            for (DataDrivenCondition cond : this.fConditions) {
                if (cond.test(event, scenarioInfo, container)) continue;
                return false;
            }
            return true;
        }
    }

    public static class DataDrivenComparisonCondition
    extends DataDrivenCondition {
        private final DataDrivenValue fFirstValue;
        private final DataDrivenValue fSecondValue;
        private final ConditionOperator fOperator;

        public DataDrivenComparisonCondition(DataDrivenValue firstValue, DataDrivenValue secondValue, ConditionOperator operator) {
            this.fFirstValue = firstValue;
            this.fSecondValue = secondValue;
            this.fOperator = operator;
        }

        @Override
        public boolean test(ITmfEvent event, DataDrivenScenarioInfo scenarioInfo, IAnalysisDataContainer container) {
            Object firstValue = this.fFirstValue.getValue(event, -1, scenarioInfo, container);
            Object secondValue = this.fSecondValue.getValue(event, -1, scenarioInfo, container);
            Integer cmpVal = null;
            cmpVal = firstValue instanceof Integer && secondValue instanceof Number ? Integer.valueOf(((Integer)firstValue).compareTo(((Number)secondValue).intValue())) : (firstValue instanceof Long && secondValue instanceof Number ? Integer.valueOf(((Long)firstValue).compareTo(((Number)secondValue).longValue())) : Integer.valueOf(String.valueOf(firstValue).compareTo(String.valueOf(secondValue))));
            return this.fOperator.test(cmpVal);
        }
    }

    public static class DataDrivenOrCondition
    extends DataDrivenCondition {
        private final List<DataDrivenCondition> fConditions;

        public DataDrivenOrCondition(List<DataDrivenCondition> conditions) {
            this.fConditions = conditions;
        }

        @Override
        public boolean test(ITmfEvent event, DataDrivenScenarioInfo scenarioInfo, IAnalysisDataContainer container) {
            for (DataDrivenCondition cond : this.fConditions) {
                if (!cond.test(event, scenarioInfo, container)) continue;
                return true;
            }
            return false;
        }
    }

    public static class TmfDdNotCondition
    extends DataDrivenCondition {
        private final DataDrivenCondition fCondition;

        public TmfDdNotCondition(DataDrivenCondition condition) {
            this.fCondition = condition;
        }

        @Override
        public boolean test(ITmfEvent event, DataDrivenScenarioInfo scenarioInfo, IAnalysisDataContainer container) {
            return !this.fCondition.test(event, scenarioInfo, container);
        }
    }
}

