/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.c.ICExternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.c.CBasicType;
import org.eclipse.cdt.internal.core.dom.parser.c.CFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionType;

public class CExternalFunction
extends CFunction
implements ICExternalBinding {
    private static final IType VOID_TYPE = new CBasicType(IBasicType.Kind.eVoid, 0);
    private IASTName name;
    private IASTTranslationUnit tu;

    public CExternalFunction(IASTTranslationUnit tu, IASTName name) {
        super(null);
        this.name = name;
        this.tu = tu;
    }

    @Override
    public IFunctionType getType() {
        if (this.type == null) {
            this.type = new CPPFunctionType(VOID_TYPE, IType.EMPTY_TYPE_ARRAY);
            IFunctionType computedType = this.createType();
            if (computedType != null) {
                this.type = computedType;
            }
        }
        return this.type;
    }

    @Override
    public IParameter[] getParameters() {
        return IParameter.EMPTY_PARAMETER_ARRAY;
    }

    @Override
    protected IASTTranslationUnit getTranslationUnit() {
        return this.tu;
    }

    @Override
    public String getName() {
        return this.name.toString();
    }

    @Override
    public char[] getNameCharArray() {
        return this.name.toCharArray();
    }

    @Override
    public IScope getScope() {
        return this.tu.getScope();
    }

    @Override
    public boolean isExtern() {
        return true;
    }
}

