/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.common.core.tests.xml;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.tracecompass.common.core.xml.XmlUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TestTransform {
    private static final String BILLION_LAUGH_ATTACK = "<?xml version=\"1.0\"?>\n<!DOCTYPE lolz [\n<!ENTITY lol \"lol\">\n<!ENTITY lol2 \"&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;\">\n<!ENTITY lol3 \"&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;\">\n<!ENTITY lol4 \"&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;\">\n<!ENTITY lol5 \"&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;\">\n<!ENTITY lol6 \"&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;\">\n<!ENTITY lol7 \"&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;\">\n<!ENTITY lol8 \"&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;\">\n<!ENTITY lol9 \"&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;\">\n]>\n<lolz>&lol9;</lolz>";
    private static final String RECURSIVE_ENTITY_REFERENCE = "<!DOCTYPE A [\n <!ELEMENT A ANY>\n <!ENTITY A \"<A>&B;</A>\"> \n <!ENTITY B \"&A;\">\n]>\n<A>&A;</A>";
    private static final String XML_INJECTION_ATTACK = "<?xml version=\"1.0\"?>\n<!DOCTYPE order [\n<!ELEMENT foo ANY >\n<!ENTITY xxe SYSTEM \"file:///dev/random\" >\n]>\n<soap:Envelope xmlns:soap=\"http://www.w3.org/2001/12/soap-envelope\" soap:encodingStyle=\"http://www.w3.org/2001/12/soap-encoding\">\n  <soap:Body xmlns:m=\"http://www.example.org/order\">\n     <foo>&xxe;</foo>\n  </soap:Body>\n</soap:Envelope>\n";

    private static void testExploit(String attackVector) throws SAXException, IOException, ParserConfigurationException, TransformerException {
        Transformer newSafeTransformer = XmlUtils.newSecureTransformer();
        Assert.assertNotNull((Object)newSafeTransformer);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document document = dbf.newDocumentBuilder().parse(new InputSource(new StringReader(attackVector)));
        newSafeTransformer.setOutputProperty("method", "xml");
        newSafeTransformer.setOutputProperty("indent", "yes");
        newSafeTransformer.setOutputProperty("encoding", "UTF-8");
        StreamResult output = new StreamResult(new StringWriter());
        newSafeTransformer.transform(new DOMSource(document), output);
    }

    @Test(expected=SAXException.class)
    public void testBillionLaughs() throws TransformerException, SAXException, IOException, ParserConfigurationException {
        TestTransform.testExploit(BILLION_LAUGH_ATTACK);
    }

    @Test(expected=SAXException.class)
    public void testRecursiveEntityReference() throws TransformerException, SAXException, IOException, ParserConfigurationException {
        TestTransform.testExploit(RECURSIVE_ENTITY_REFERENCE);
    }

    @Ignore
    @Test(expected=IOException.class)
    public void testXmlInjection() throws SAXException, IOException, ParserConfigurationException, TransformerException {
        TestTransform.testExploit(XML_INJECTION_ATTACK);
    }
}

