/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.pcap.core.tests.protocol.ethernet2;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.tracecompass.internal.pcap.core.packet.BadPacketException;
import org.eclipse.tracecompass.internal.pcap.core.protocol.PcapProtocol;
import org.eclipse.tracecompass.internal.pcap.core.protocol.ethernet2.EthernetIIEndpoint;
import org.eclipse.tracecompass.internal.pcap.core.protocol.ethernet2.EthernetIIPacket;
import org.eclipse.tracecompass.internal.pcap.core.trace.BadPcapFileException;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapFile;
import org.eclipse.tracecompass.pcap.core.tests.shared.PcapTestTrace;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class EthernetIIPacketTest {
    private static final Map<String, String> EXPECTED_FIELDS = ImmutableMap.of((Object)"Source MAC Address", (Object)"10:f8:82:b3:44:78", (Object)"Destination MAC Address", (Object)"34:67:0c:d2:91:51", (Object)"Ethertype", (Object)"Unknown (0xa256)");
    private static final String EXPECTED_TOSTRING = "Ethernet II, Source: 10:f8:82:b3:44:78, Destination: 34:67:0c:d2:91:51, Type: Unknown (0xa256)\nPayload: a6";
    private ByteBuffer fPacket;

    @Before
    public void initialize() {
        this.fPacket = ByteBuffer.allocate(15);
        this.fPacket.order(ByteOrder.BIG_ENDIAN);
        this.fPacket.put((byte)52);
        this.fPacket.put((byte)103);
        this.fPacket.put((byte)12);
        this.fPacket.put((byte)-46);
        this.fPacket.put((byte)-111);
        this.fPacket.put((byte)81);
        this.fPacket.put((byte)16);
        this.fPacket.put((byte)-8);
        this.fPacket.put((byte)-126);
        this.fPacket.put((byte)-77);
        this.fPacket.put((byte)68);
        this.fPacket.put((byte)120);
        this.fPacket.put((byte)-94);
        this.fPacket.put((byte)86);
        this.fPacket.put((byte)-90);
        this.fPacket.flip();
    }

    @Test
    public void CompleteEthernetIIPacketTest() throws IOException, BadPcapFileException, BadPacketException {
        PcapTestTrace trace = PcapTestTrace.MOSTLY_TCP;
        Assume.assumeTrue((boolean)trace.exists());
        Throwable throwable = null;
        Object var3_4 = null;
        try (PcapFile dummy = new PcapFile(trace.getPath());){
            ByteBuffer byteBuffer = this.fPacket;
            if (byteBuffer == null) {
                Assert.fail((String)"CompleteEthernetIIPacketTest has failed!");
                return;
            }
            EthernetIIPacket packet = new EthernetIIPacket(dummy, null, byteBuffer);
            Assert.assertEquals((Object)PcapProtocol.ETHERNET_II, (Object)packet.getProtocol());
            Assert.assertTrue((boolean)packet.hasProtocol(PcapProtocol.ETHERNET_II));
            Assert.assertTrue((boolean)packet.hasProtocol(PcapProtocol.UNKNOWN));
            Assert.assertFalse((boolean)packet.hasProtocol(PcapProtocol.TCP));
            Assert.assertTrue((boolean)packet.validate());
            Assert.assertEquals((long)-653947816L, (long)packet.hashCode());
            Assert.assertFalse((boolean)packet.equals(null));
            Assert.assertEquals((Object)new EthernetIIPacket(dummy, null, byteBuffer), (Object)packet);
            Assert.assertEquals(EXPECTED_FIELDS, (Object)packet.getFields());
            Assert.assertEquals((Object)EXPECTED_TOSTRING, (Object)packet.toString());
            Assert.assertEquals((Object)"Src: 10:f8:82:b3:44:78 , Dst: 34:67:0c:d2:91:51", (Object)packet.getLocalSummaryString());
            Assert.assertEquals((Object)"Source MAC: 10:f8:82:b3:44:78 , Destination MAC: 34:67:0c:d2:91:51", (Object)packet.getGlobalSummaryString());
            Assert.assertEquals((Object)new EthernetIIEndpoint(packet, true), (Object)packet.getSourceEndpoint());
            Assert.assertEquals((Object)new EthernetIIEndpoint(packet, false), (Object)packet.getDestinationEndpoint());
            this.fPacket.position(14);
            byte[] payload = new byte[1];
            this.fPacket.get(payload);
            Assert.assertEquals((Object)ByteBuffer.wrap(payload), (Object)packet.getPayload());
            Assert.assertTrue((boolean)Arrays.equals(packet.getSourceMacAddress(), Arrays.copyOfRange(this.fPacket.array(), 6, 12)));
            Assert.assertTrue((boolean)Arrays.equals(packet.getDestinationMacAddress(), Arrays.copyOfRange(this.fPacket.array(), 0, 6)));
            Assert.assertEquals((long)41558L, (long)packet.getEthertype());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

