/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.pcap.core.tests.protocol.tcp;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.tracecompass.internal.pcap.core.packet.BadPacketException;
import org.eclipse.tracecompass.internal.pcap.core.protocol.PcapProtocol;
import org.eclipse.tracecompass.internal.pcap.core.protocol.tcp.TCPEndpoint;
import org.eclipse.tracecompass.internal.pcap.core.protocol.tcp.TCPPacket;
import org.eclipse.tracecompass.internal.pcap.core.trace.BadPcapFileException;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapFile;
import org.eclipse.tracecompass.pcap.core.tests.shared.PcapTestTrace;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TCPPacketTest {
    private static final Map<String, String> EXPECTED_FIELDS = new LinkedHashMap<String, String>();
    private static final String EXPECTED_TOSTRING;
    private ByteBuffer fPacket;

    static {
        EXPECTED_FIELDS.put("Source Port", "18057");
        EXPECTED_FIELDS.put("Destination Port", "39611");
        EXPECTED_FIELDS.put("Sequence Number", "2575857510");
        EXPECTED_FIELDS.put("Acknowledgement Number", "1430532898");
        EXPECTED_FIELDS.put("Length", "24 bytes");
        EXPECTED_FIELDS.put("ECN-Nonce Flag", "true");
        EXPECTED_FIELDS.put("Congestion Window Reduced Flag", "false");
        EXPECTED_FIELDS.put("ECN-Echo Flag", "true");
        EXPECTED_FIELDS.put("Urgent Flag", "false");
        EXPECTED_FIELDS.put("ACK Flag", "true");
        EXPECTED_FIELDS.put("PSH Flag", "false");
        EXPECTED_FIELDS.put("RST Flag", "true");
        EXPECTED_FIELDS.put("SYN Flag", "false");
        EXPECTED_FIELDS.put("FIN Flag", "true");
        EXPECTED_FIELDS.put("Window Size Value", "4352");
        EXPECTED_FIELDS.put("Checksum", "0xffee");
        EXPECTED_FIELDS.put("Urgent Pointer", "0xddcc");
        EXPECTED_FIELDS.put("Options", "ad da bc cb");
        StringBuilder sb = new StringBuilder();
        sb.append("Transmission Control Protocol, Source Port: 18057, Destination Port: 39611\n");
        sb.append("Sequence Number: 2575857510, Acknowledgment Number: 1430532898\n");
        sb.append("Header length: 24 bytes, Data length: 4\n");
        sb.append("Window size value: 4352, Urgent Pointer: 0xddcc\n");
        sb.append("Checksum: 0xffee\n");
        sb.append("Payload: 99 88 77 66");
        EXPECTED_TOSTRING = sb.toString();
    }

    @Before
    public void initialize() {
        this.fPacket = ByteBuffer.allocate(28);
        this.fPacket.order(ByteOrder.BIG_ENDIAN);
        this.fPacket.put((byte)70);
        this.fPacket.put((byte)-119);
        this.fPacket.put((byte)-102);
        this.fPacket.put((byte)-69);
        this.fPacket.put((byte)-103);
        this.fPacket.put((byte)-120);
        this.fPacket.put((byte)119);
        this.fPacket.put((byte)102);
        this.fPacket.put((byte)85);
        this.fPacket.put((byte)68);
        this.fPacket.put((byte)51);
        this.fPacket.put((byte)34);
        this.fPacket.put((byte)97);
        this.fPacket.put((byte)85);
        this.fPacket.put((byte)17);
        this.fPacket.put((byte)0);
        this.fPacket.put((byte)-1);
        this.fPacket.put((byte)-18);
        this.fPacket.put((byte)-35);
        this.fPacket.put((byte)-52);
        this.fPacket.put((byte)-83);
        this.fPacket.put((byte)-38);
        this.fPacket.put((byte)-68);
        this.fPacket.put((byte)-53);
        this.fPacket.put((byte)-103);
        this.fPacket.put((byte)-120);
        this.fPacket.put((byte)119);
        this.fPacket.put((byte)102);
        this.fPacket.flip();
    }

    @Test
    public void CompleteTCPPacketTest() throws BadPacketException, IOException, BadPcapFileException {
        PcapTestTrace trace = PcapTestTrace.MOSTLY_TCP;
        Assume.assumeTrue((boolean)trace.exists());
        Throwable throwable = null;
        Object var3_4 = null;
        try (PcapFile dummy = new PcapFile(trace.getPath());){
            ByteBuffer byteBuffer = this.fPacket;
            if (byteBuffer == null) {
                Assert.fail((String)"CompleteTCPPacketTest has failed!");
                return;
            }
            TCPPacket packet = new TCPPacket(dummy, null, byteBuffer);
            Assert.assertEquals((Object)PcapProtocol.TCP, (Object)packet.getProtocol());
            Assert.assertTrue((boolean)packet.hasProtocol(PcapProtocol.TCP));
            Assert.assertTrue((boolean)packet.hasProtocol(PcapProtocol.UNKNOWN));
            Assert.assertFalse((boolean)packet.hasProtocol(PcapProtocol.IPV4));
            Assert.assertTrue((boolean)packet.validate());
            Assert.assertEquals((long)-677046102L, (long)packet.hashCode());
            Assert.assertFalse((boolean)packet.equals(null));
            Assert.assertEquals((Object)new TCPPacket(dummy, null, byteBuffer), (Object)packet);
            Assert.assertEquals(EXPECTED_FIELDS, (Object)packet.getFields());
            Assert.assertEquals((Object)EXPECTED_TOSTRING, (Object)packet.toString());
            Assert.assertEquals((Object)"Src Port: 18057, Dst Port: 39611, Seq: 2575857510, Ack: 1430532898, Len: 24", (Object)packet.getLocalSummaryString());
            Assert.assertEquals((Object)"18057 > 39611 [ACK, FIN, RST, NS, ECE] Seq=2575857510 Ack=1430532898 Len=24", (Object)packet.getGlobalSummaryString());
            Assert.assertEquals((Object)new TCPEndpoint(packet, true), (Object)packet.getSourceEndpoint());
            Assert.assertEquals((Object)new TCPEndpoint(packet, false), (Object)packet.getDestinationEndpoint());
            this.fPacket.position(24);
            byte[] payload = new byte[4];
            this.fPacket.get(payload);
            Assert.assertEquals((Object)ByteBuffer.wrap(payload), (Object)packet.getPayload());
            Assert.assertEquals((long)18057L, (long)packet.getSourcePort());
            Assert.assertEquals((long)39611L, (long)packet.getDestinationPort());
            Assert.assertEquals((long)2575857510L, (long)packet.getSequenceNumber());
            Assert.assertEquals((long)1430532898L, (long)packet.getAcknowledgmentNumber());
            Assert.assertEquals((long)6L, (long)packet.getDataOffset());
            Assert.assertEquals((long)0L, (long)packet.getReservedField());
            Assert.assertEquals((Object)true, (Object)packet.isNSFlagSet());
            Assert.assertEquals((Object)false, (Object)packet.isCongestionWindowReducedFlagSet());
            Assert.assertEquals((Object)true, (Object)packet.isECNEchoFlagSet());
            Assert.assertEquals((Object)false, (Object)packet.isUrgentFlagSet());
            Assert.assertEquals((Object)true, (Object)packet.isAcknowledgeFlagSet());
            Assert.assertEquals((Object)false, (Object)packet.isPushFlagSet());
            Assert.assertEquals((Object)true, (Object)packet.isResetFlagSet());
            Assert.assertEquals((Object)false, (Object)packet.isSynchronizationFlagSet());
            Assert.assertEquals((Object)true, (Object)packet.isFinalFlagSet());
            Assert.assertEquals((long)4352L, (long)packet.getWindowSize());
            Assert.assertEquals((long)65518L, (long)packet.getChecksum());
            Assert.assertEquals((long)56780L, (long)packet.getUrgentPointer());
            Assert.assertTrue((boolean)Arrays.equals(packet.getOptions(), Arrays.copyOfRange(this.fPacket.array(), 20, 24)));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

