/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.AnalysisCompilationData;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.IDataDrivenCompilationUnit;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlStateSystemPathCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlStateValueCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenCondition;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.w3c.dom.Element;

public abstract class TmfXmlConditionCu
implements IDataDrivenCompilationUnit {
    @Override
    public abstract DataDrivenCondition generate();

    public static @Nullable String compileNamedCondition(AnalysisCompilationData analysisData, Element namedEl) {
        String id = namedEl.getAttribute("id");
        List<@Nullable Element> childElements = XmlUtils.getChildElements(namedEl);
        Element child = (Element)NonNullUtils.checkNotNull((Object)childElements.get(0));
        if ((childElements = XmlUtils.getChildElements(child)).size() != 1) {
            Activator.logError("There should be only one element under this condition");
            throw new NullPointerException("Can't compile the condition");
        }
        Element subCondition = Objects.requireNonNull(childElements.get(0));
        TmfXmlConditionCu condition = TmfXmlConditionCu.compile(analysisData, subCondition);
        if (condition == null) {
            return null;
        }
        analysisData.addTest(id, condition);
        return id;
    }

    public static @Nullable TmfXmlConditionCu compile(AnalysisCompilationData analysisData, Element conditionEl) {
        switch (conditionEl.getNodeName()) {
            case "condition": {
                return TmfXmlConditionCu.compileSingleCondition(analysisData, conditionEl);
            }
            case "not": {
                List<@Nullable Element> childElements = XmlUtils.getChildElements(conditionEl);
                if (childElements.size() != 1) {
                    Activator.logError("Compiling condition: NOT condition must have 1 and only 1 child");
                    return null;
                }
                Element element = Objects.requireNonNull(childElements.get(0));
                TmfXmlConditionCu compile = TmfXmlConditionCu.compile(analysisData, element);
                return compile == null ? null : new TmfXmlNotConditionCu(compile);
            }
            case "and": {
                List<TmfXmlConditionCu> childConditions = TmfXmlConditionCu.getCompiledChildConditions(analysisData, conditionEl);
                return childConditions == null ? null : new TmfXmlAndConditionCu(childConditions);
            }
            case "or": {
                List<TmfXmlConditionCu> childConditions = TmfXmlConditionCu.getCompiledChildConditions(analysisData, conditionEl);
                return childConditions == null ? null : new TmfXmlOrConditionCu(childConditions);
            }
        }
        Activator.logError("Xml condition: Unsupported condition type: " + conditionEl.getNodeName());
        return null;
    }

    private static @Nullable List<TmfXmlConditionCu> getCompiledChildConditions(AnalysisCompilationData analysisData, Element conditionEl) {
        List<@Nullable Element> childElements = XmlUtils.getChildElements(conditionEl);
        if (childElements.isEmpty()) {
            Activator.logError("Compiling condition: AND and OR condition must have at least 1 element");
            return null;
        }
        ArrayList<TmfXmlConditionCu> childConditions = new ArrayList<TmfXmlConditionCu>();
        for (Element element : childElements) {
            TmfXmlConditionCu condition = TmfXmlConditionCu.compile(analysisData, Objects.requireNonNull(element));
            if (condition == null) {
                return null;
            }
            childConditions.add(condition);
        }
        return childConditions;
    }

    private static @Nullable TmfXmlConditionCu compileSingleCondition(AnalysisCompilationData analysisData, Element conditionEl) {
        if (conditionEl.getElementsByTagName("stateValue").getLength() > 0) {
            return TmfXmlConditionCu.compileValueCondition(analysisData, conditionEl);
        }
        List<Element> childElements = TmfXmlUtils.getChildElements(conditionEl, "timerange");
        if (childElements.size() == 1) {
            return TmfXmlConditionCu.compileTimeRangeCondition(childElements.get(0));
        }
        childElements = TmfXmlUtils.getChildElements(conditionEl, "elapsedTime");
        if (childElements.size() == 1) {
            return TmfXmlConditionCu.compileElapsedTimeCondition(childElements.get(0));
        }
        return null;
    }

    private static @Nullable TmfXmlConditionCu compileElapsedTimeCondition(Element element) {
        DataDrivenCondition.ConditionOperator operator;
        String type;
        String unit = element.getAttribute("unit");
        List<@Nullable Element> childElements = XmlUtils.getChildElements(element);
        if (childElements.size() != 1) {
            Activator.logError("Invalid timestampsChecker declaration in XML : Only one timing condition is allowed");
            return null;
        }
        Element firstElement = (Element)NonNullUtils.checkNotNull((Object)childElements.get(0));
        switch (type = firstElement.getNodeName()) {
            case "less": {
                operator = DataDrivenCondition.ConditionOperator.LT;
                break;
            }
            case "equal": {
                operator = DataDrivenCondition.ConditionOperator.EQ;
                break;
            }
            case "more": {
                operator = DataDrivenCondition.ConditionOperator.GT;
                break;
            }
            default: {
                Activator.logError("ElapsedTimeChecker: Invalid operator: " + type);
                return null;
            }
        }
        String reference = firstElement.getAttribute("since");
        String valueStr = firstElement.getAttribute("value");
        try {
            long value = TmfXmlConditionCu.valueToNanoseconds(Long.parseLong(valueStr), unit);
            return new TmfXmlElapsedTimeConditionCu(operator, reference, value);
        }
        catch (NumberFormatException e) {
            Activator.logError("Invalid value for elapsed time: " + e.getMessage());
            return null;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static @Nullable TmfXmlConditionCu compileTimeRangeCondition(Element element) {
        DataDrivenCondition.TimeRangeOperator operator;
        String type;
        String unit = element.getAttribute("unit");
        @Nullable List childElements = (List)NonNullUtils.checkNotNull(XmlUtils.getChildElements(element));
        if (childElements.size() != 1) {
            Activator.logError("Invalid timestampsChecker declaration in XML : Only one timing condition is allowed");
            return null;
        }
        Element firstElement = (Element)NonNullUtils.checkNotNull((Object)((Element)childElements.get(0)));
        switch (type = firstElement.getNodeName()) {
            case "in": {
                operator = DataDrivenCondition.TimeRangeOperator.IN;
                break;
            }
            case "out": {
                operator = DataDrivenCondition.TimeRangeOperator.OUT;
                break;
            }
            default: {
                Activator.logError("TimeRangeChecker: Invalid operator: " + type);
                return null;
            }
        }
        String beginStr = firstElement.getAttribute("begin");
        String endStr = firstElement.getAttribute("end");
        try {
            long begin = TmfXmlConditionCu.valueToNanoseconds(Long.parseLong(beginStr), unit);
            long end = TmfXmlConditionCu.valueToNanoseconds(Long.parseLong(endStr), unit);
            return new TmfXmlTimeRangeConditionCu(operator, begin, end);
        }
        catch (NumberFormatException e) {
            Activator.logError("Invalid value for time range: " + e.getMessage());
            return null;
        }
    }

    public static long valueToNanoseconds(long timestamp, String unit) {
        switch (unit) {
            case "ns": {
                return timestamp;
            }
            case "us": {
                return TmfTimestamp.create((long)timestamp, (int)-6).toNanos();
            }
            case "ms": {
                return TmfTimestamp.create((long)timestamp, (int)-3).toNanos();
            }
            case "s": {
                return TmfTimestamp.create((long)timestamp, (int)0).toNanos();
            }
        }
        throw new IllegalArgumentException("The time unit is not yet supporting.");
    }

    private static @Nullable TmfXmlConditionCu compileValueCondition(AnalysisCompilationData analysisData, Element conditionEl) {
        DataDrivenCondition.ConditionOperator conditionOperator = TmfXmlConditionCu.getConditionOperator(conditionEl);
        List<Element> childElements = TmfXmlUtils.getChildElements(conditionEl, "stateValue");
        if (childElements.size() == 2) {
            TmfXmlStateValueCu firstValue = TmfXmlStateValueCu.compileValue(analysisData, childElements.get(0));
            TmfXmlStateValueCu secondValue = TmfXmlStateValueCu.compileValue(analysisData, childElements.get(1));
            if (firstValue == null || secondValue == null) {
                return null;
            }
            return new TmfXmlCompareConditionCu(firstValue, secondValue, conditionOperator);
        }
        if (childElements.size() == 1) {
            TmfXmlStateValueCu secondValue = TmfXmlStateValueCu.compileValue(analysisData, childElements.get(0));
            TmfXmlStateValueCu firstValue = null;
            List<Element> attributes = TmfXmlUtils.getChildElements(conditionEl, "stateAttribute");
            if (!attributes.isEmpty()) {
                TmfXmlStateSystemPathCu path = TmfXmlStateSystemPathCu.compile(analysisData, attributes);
                if (path == null) {
                    return null;
                }
                firstValue = TmfXmlStateValueCu.compileAsQuery(path);
            } else {
                attributes = TmfXmlUtils.getChildElements(conditionEl, "field");
                if (attributes.size() != 1) {
                    Activator.logError("Condition: There should be either 2 state values or 1 attribute or field and 1 state value");
                    return null;
                }
                firstValue = TmfXmlStateValueCu.compileField(analysisData, attributes.get(0));
            }
            if (firstValue == null || secondValue == null) {
                return null;
            }
            return new TmfXmlCompareConditionCu(firstValue, secondValue, conditionOperator);
        }
        return null;
    }

    private static DataDrivenCondition.ConditionOperator getConditionOperator(Element rootNode) {
        String equationType;
        switch (equationType = rootNode.getAttribute("operator")) {
            case "eq": {
                return DataDrivenCondition.ConditionOperator.EQ;
            }
            case "ne": {
                return DataDrivenCondition.ConditionOperator.NE;
            }
            case "ge": {
                return DataDrivenCondition.ConditionOperator.GE;
            }
            case "gt": {
                return DataDrivenCondition.ConditionOperator.GT;
            }
            case "le": {
                return DataDrivenCondition.ConditionOperator.LE;
            }
            case "lt": {
                return DataDrivenCondition.ConditionOperator.LT;
            }
            case "": {
                return DataDrivenCondition.ConditionOperator.EQ;
            }
        }
        throw new IllegalArgumentException("TmfXmlCondition: invalid comparison operator.");
    }

    private static class TmfXmlAndConditionCu
    extends TmfXmlConditionCu {
        private final List<TmfXmlConditionCu> fConditions;

        TmfXmlAndConditionCu(List<TmfXmlConditionCu> childConditions) {
            this.fConditions = childConditions;
        }

        @Override
        public DataDrivenCondition generate() {
            List<DataDrivenCondition> conditions = this.fConditions.stream().map(TmfXmlConditionCu::generate).collect(Collectors.toList());
            return new DataDrivenCondition.DataDrivenAndCondition(conditions);
        }
    }

    private static class TmfXmlCompareConditionCu
    extends TmfXmlConditionCu {
        private final TmfXmlStateValueCu fFirstValue;
        private final TmfXmlStateValueCu fSecondValue;
        private final DataDrivenCondition.ConditionOperator fOperator;

        TmfXmlCompareConditionCu(TmfXmlStateValueCu firstValue, TmfXmlStateValueCu secondValue, DataDrivenCondition.ConditionOperator conditionOperator) {
            this.fFirstValue = firstValue;
            this.fSecondValue = secondValue;
            this.fOperator = conditionOperator;
        }

        @Override
        public DataDrivenCondition generate() {
            return new DataDrivenCondition.DataDrivenComparisonCondition(this.fFirstValue.generate(), this.fSecondValue.generate(), this.fOperator);
        }
    }

    private static class TmfXmlElapsedTimeConditionCu
    extends TmfXmlConditionCu {
        private final DataDrivenCondition.ConditionOperator fOperator;
        private final String fReference;
        private final long fValue;

        TmfXmlElapsedTimeConditionCu(DataDrivenCondition.ConditionOperator operator, String reference, long end) {
            this.fOperator = operator;
            this.fReference = reference;
            this.fValue = end;
        }

        @Override
        public DataDrivenCondition generate() {
            return new DataDrivenCondition.DataDrivenElapsedTimeCondition(this.fOperator, this.fReference, this.fValue);
        }
    }

    private static class TmfXmlNotConditionCu
    extends TmfXmlConditionCu {
        private final TmfXmlConditionCu fCondition;

        TmfXmlNotConditionCu(TmfXmlConditionCu compile) {
            this.fCondition = compile;
        }

        @Override
        public DataDrivenCondition generate() {
            return new DataDrivenCondition.TmfDdNotCondition(this.fCondition.generate());
        }
    }

    private static class TmfXmlOrConditionCu
    extends TmfXmlConditionCu {
        private final List<TmfXmlConditionCu> fConditions;

        TmfXmlOrConditionCu(List<TmfXmlConditionCu> childConditions) {
            this.fConditions = childConditions;
        }

        @Override
        public DataDrivenCondition generate() {
            List<DataDrivenCondition> conditions = this.fConditions.stream().map(TmfXmlConditionCu::generate).collect(Collectors.toList());
            return new DataDrivenCondition.DataDrivenOrCondition(conditions);
        }
    }

    private static class TmfXmlTimeRangeConditionCu
    extends TmfXmlConditionCu {
        private final DataDrivenCondition.TimeRangeOperator fOperator;
        private final long fBegin;
        private final long fEnd;

        TmfXmlTimeRangeConditionCu(DataDrivenCondition.TimeRangeOperator operator, long begin, long end) {
            this.fOperator = operator;
            this.fBegin = begin;
            this.fEnd = end;
        }

        @Override
        public DataDrivenCondition generate() {
            return new DataDrivenCondition.DataDrivenTimeRangeCondition(this.fOperator, this.fBegin, this.fEnd);
        }
    }
}

