/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenCondition;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.IAnalysisDataContainer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.Messages;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlBasicTransition;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlPatternEventHandler;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlScenario;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlState;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlStateTransition;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TmfXmlFsm {
    private final Map<String, TmfXmlState> fStatesMap;
    private final List<TmfXmlScenario> fActiveScenariosList;
    private final List<TmfXmlBasicTransition> fPreconditions;
    private final String fId;
    private final ITmfXmlModelFactory fModelFactory;
    private final IXmlStateSystemContainer fContainer;
    private final String fFinalStateId;
    private final String fAbandonStateId;
    private final boolean fInstanceMultipleEnabled;
    private final String fInitialStateId;
    private final boolean fConsuming;
    private boolean fEventConsumed;
    private int fTotalScenarios;
    private @Nullable TmfXmlScenario fPendingScenario;

    public static TmfXmlFsm create(ITmfXmlModelFactory modelFactory, Element node, IXmlStateSystemContainer container) {
        Element abandonElement;
        Element finalElement;
        String id = node.getAttribute("id");
        boolean consuming = node.getAttribute("consuming").isEmpty() ? true : Boolean.parseBoolean(node.getAttribute("consuming"));
        boolean instanceMultipleEnabled = node.getAttribute("multiple").isEmpty() ? true : Boolean.parseBoolean(node.getAttribute("multiple"));
        ArrayList<@NonNull TmfXmlBasicTransition> preconditions = new ArrayList<TmfXmlBasicTransition>();
        NodeList nodesPreconditions = node.getElementsByTagName("precondition");
        int i = 0;
        while (i < nodesPreconditions.getLength()) {
            preconditions.add(new TmfXmlBasicTransition((Element)NonNullUtils.checkNotNull((Object)nodesPreconditions.item(i))));
            ++i;
        }
        HashMap<@NonNull String, @NonNull TmfXmlState> statesMap = new HashMap<String, TmfXmlState>();
        String initialState = node.getAttribute("initial");
        NodeList nodesInitialElement = node.getElementsByTagName("initial");
        NodeList nodesInitialStateElement = node.getElementsByTagName("initialState");
        if (nodesInitialStateElement.getLength() > 0) {
            if (!initialState.isEmpty() || nodesInitialElement.getLength() > 0) {
                Activator.logWarning("Fsm " + id + ": the 'initial' attribute was set or an <initial> element was defined. Only one of the 3 should be used.");
            }
            @NonNull TmfXmlState initial = modelFactory.createState((Element)nodesInitialStateElement.item(0), container, null);
            statesMap.put("#initial", initial);
            initialState = "#initial";
        } else {
            if (!initialState.isEmpty() && nodesInitialElement.getLength() > 0) {
                Activator.logWarning("Fsm " + id + " was declared with both 'initial' attribute and <initial> element. Only the 'initial' attribute will be used");
            }
            if (initialState.isEmpty() && nodesInitialElement.getLength() > 0) {
                NodeList nodesTransition = ((Element)nodesInitialElement.item(0)).getElementsByTagName("transition");
                if (nodesInitialElement.getLength() != 1) {
                    throw new IllegalArgumentException("initial element : there should be one and only one initial state.");
                }
                initialState = ((Element)nodesTransition.item(0)).getAttribute("target");
            }
        }
        NodeList nodesState = node.getElementsByTagName("state");
        int i2 = 0;
        while (i2 < nodesState.getLength()) {
            Element element = (Element)NonNullUtils.checkNotNull((Object)nodesState.item(i2));
            TmfXmlState state = modelFactory.createState(element, container, null);
            statesMap.put(state.getId(), state);
            if (initialState.isEmpty()) {
                initialState = state.getId();
            }
            ++i2;
        }
        if (initialState.isEmpty()) {
            throw new IllegalStateException("No initial state has been declared in fsm " + id);
        }
        String finalStateId = "";
        NodeList nodesFinalState = node.getElementsByTagName("final");
        if (nodesFinalState.getLength() == 1 && !(finalStateId = (finalElement = (Element)NonNullUtils.checkNotNull((Object)((Element)nodesFinalState.item(0)))).getAttribute("id")).isEmpty()) {
            TmfXmlState finalState = modelFactory.createState(finalElement, container, null);
            statesMap.put(finalState.getId(), finalState);
        }
        String abandonStateId = "";
        NodeList nodesAbandonState = node.getElementsByTagName("abandonState");
        if (nodesAbandonState.getLength() == 1 && !(abandonStateId = (abandonElement = (Element)NonNullUtils.checkNotNull((Object)((Element)nodesAbandonState.item(0)))).getAttribute("id")).isEmpty()) {
            TmfXmlState abandonState = modelFactory.createState(abandonElement, container, null);
            statesMap.put(abandonState.getId(), abandonState);
        }
        return new TmfXmlFsm(modelFactory, container, id, consuming, instanceMultipleEnabled, initialState, finalStateId, abandonStateId, preconditions, statesMap);
    }

    private TmfXmlFsm(ITmfXmlModelFactory modelFactory, IXmlStateSystemContainer container, String id, boolean consuming, boolean multiple, String initialState, String finalState, String abandonState, List<TmfXmlBasicTransition> preconditions, Map<String, TmfXmlState> states) {
        this.fModelFactory = modelFactory;
        this.fTotalScenarios = 0;
        this.fContainer = container;
        this.fId = id;
        this.fConsuming = consuming;
        this.fInstanceMultipleEnabled = multiple;
        this.fInitialStateId = initialState;
        this.fFinalStateId = finalState;
        this.fAbandonStateId = abandonState;
        this.fPreconditions = ImmutableList.copyOf(preconditions);
        this.fStatesMap = ImmutableMap.copyOf(states);
        this.fActiveScenariosList = new ArrayList<TmfXmlScenario>();
    }

    public String getId() {
        return this.fId;
    }

    public String getInitialStateId() {
        return this.fInitialStateId;
    }

    public String getFinalStateId() {
        return this.fFinalStateId;
    }

    public String getAbandonStateId() {
        return this.fAbandonStateId;
    }

    public Map<String, TmfXmlState> getStatesMap() {
        return Collections.unmodifiableMap(this.fStatesMap);
    }

    public void setEventConsumed(boolean eventConsumed) {
        this.fEventConsumed = eventConsumed;
    }

    private boolean isEventConsumed() {
        return this.fEventConsumed;
    }

    public @Nullable TmfXmlStateTransition next(ITmfEvent event, Map<String, DataDrivenCondition> tests, TmfXmlScenarioInfo scenarioInfo, IAnalysisDataContainer container) {
        boolean matched = false;
        TmfXmlStateTransition stateTransition = null;
        TmfXmlState state = this.fStatesMap.get(scenarioInfo.getActiveState());
        if (state == null) {
            Activator.logError(NLS.bind((String)Messages.TmfXmlFsm_StateUndefined, (Object)scenarioInfo.getActiveState(), (Object)this.getId()));
            return null;
        }
        int i = 0;
        while (i < state.getTransitionList().size() && !matched) {
            stateTransition = state.getTransitionList().get(i);
            matched = stateTransition.test(event, scenarioInfo, tests, container);
            ++i;
        }
        return matched ? stateTransition : null;
    }

    private boolean validatePreconditions(ITmfEvent event, Map<String, DataDrivenCondition> tests, IAnalysisDataContainer container) {
        if (this.fPreconditions.isEmpty()) {
            return true;
        }
        for (TmfXmlBasicTransition precondition : this.fPreconditions) {
            if (!precondition.test(event, null, tests, container)) continue;
            return true;
        }
        return false;
    }

    public void handleEvent(ITmfEvent event, Map<String, DataDrivenCondition> testMap, IAnalysisDataContainer container) {
        this.setEventConsumed(false);
        boolean isValidInput = this.handleActiveScenarios(event, testMap, container);
        this.handlePendingScenario(event, isValidInput, container);
    }

    private boolean handleActiveScenarios(ITmfEvent event, Map<String, DataDrivenCondition> testMap, IAnalysisDataContainer container) {
        if (!this.validatePreconditions(event, testMap, container)) {
            return false;
        }
        Iterator<TmfXmlScenario> currentItr = this.fActiveScenariosList.iterator();
        while (currentItr.hasNext()) {
            TmfXmlScenario scenario = currentItr.next();
            if (!scenario.isActive()) {
                currentItr.remove();
                continue;
            }
            TmfXmlFsm.handleScenario(scenario, event, container);
            if (!this.fConsuming || !this.isEventConsumed()) continue;
            return true;
        }
        return true;
    }

    private void handlePendingScenario(ITmfEvent event, boolean isInputValid, IAnalysisDataContainer container) {
        if (this.fConsuming && this.isEventConsumed()) {
            return;
        }
        TmfXmlScenario scenario = this.fPendingScenario;
        if ((this.fInitialStateId.equals("#initial") || isInputValid) && scenario != null) {
            TmfXmlFsm.handleScenario(scenario, event, container);
            if (!scenario.isPending()) {
                this.addActiveScenario(scenario);
                this.fPendingScenario = null;
            }
        }
    }

    public void dispose() {
        for (TmfXmlScenario scenario : this.fActiveScenariosList) {
            if (!scenario.isActive()) continue;
            scenario.cancel();
        }
    }

    private static void handleScenario(TmfXmlScenario scenario, ITmfEvent event, IAnalysisDataContainer container) {
        if (scenario.isActive() || scenario.isPending()) {
            scenario.handleEvent(event, container);
        }
    }

    public synchronized void createScenario(@Nullable ITmfEvent event, TmfXmlPatternEventHandler eventHandler, boolean force) {
        if (force || this.isNewScenarioAllowed()) {
            this.fPendingScenario = new TmfXmlScenario(event, eventHandler, this.fId, this.fContainer, this.fModelFactory);
            ++this.fTotalScenarios;
        }
    }

    private void addActiveScenario(TmfXmlScenario scenario) {
        this.fActiveScenariosList.add(scenario);
    }

    public synchronized boolean isNewScenarioAllowed() {
        return this.fTotalScenarios > 0 && this.fInstanceMultipleEnabled && this.fPendingScenario == null;
    }
}

