/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValue;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternStateProvider;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.segment.TmfXmlPatternSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TmfXmlPatternSegmentBuilder {
    public static final String UNKNOWN_STRING = "unknown";
    public static final String PATTERN_SEGMENT_NAME_PREFIX = "seg_";
    private final ITmfXmlModelFactory fModelFactory;
    private final IXmlStateSystemContainer fContainer;
    private final List<TmfXmlPatternSegmentField> fFields = new ArrayList<TmfXmlPatternSegmentField>();
    private final TmfXmlPatternSegmentType fSegmentType;
    private @Nullable DataDrivenValue fBegin;
    private @Nullable DataDrivenValue fEnd;
    private @Nullable DataDrivenValue fDuration;

    public TmfXmlPatternSegmentBuilder(ITmfXmlModelFactory modelFactory, Element node, IXmlStateSystemContainer parent) {
        NodeList nodesSegmentContent;
        Element fContentElement;
        Element fTimeElement;
        this.fModelFactory = modelFactory;
        this.fContainer = parent;
        NodeList nodesSegmentType = node.getElementsByTagName("segType");
        Element element = (Element)nodesSegmentType.item(0);
        if (element == null) {
            throw new IllegalArgumentException();
        }
        this.fSegmentType = new TmfXmlPatternSegmentType(element);
        NodeList nodesSegmentTime = node.getElementsByTagName("segTime");
        if (nodesSegmentTime != null && (fTimeElement = (Element)nodesSegmentTime.item(0)) != null) {
            NodeList nodesBeginTime = fTimeElement.getElementsByTagName("begin");
            Element beginTimeElement = (Element)nodesBeginTime.item(0);
            if (beginTimeElement == null) {
                throw new IllegalArgumentException("Invalid xml segment description");
            }
            this.fBegin = modelFactory.createStateValue(beginTimeElement, parent);
            NodeList nodesEndTime = fTimeElement.getElementsByTagName("end");
            Element endTimeElement = (Element)nodesEndTime.item(0);
            this.fEnd = endTimeElement == null ? null : modelFactory.createStateValue(endTimeElement, parent);
            NodeList nodesDuration = fTimeElement.getElementsByTagName("duration");
            Element durationElement = (Element)nodesDuration.item(0);
            DataDrivenValue dataDrivenValue = this.fDuration = durationElement == null ? null : modelFactory.createStateValue(durationElement, parent);
        }
        if ((fContentElement = (Element)(nodesSegmentContent = node.getElementsByTagName("segContent")).item(0)) != null) {
            NodeList nodesSegmentField = fContentElement.getElementsByTagName("segField");
            int i = 0;
            while (i < nodesSegmentField.getLength()) {
                this.fFields.add(new TmfXmlPatternSegmentField((Element)NonNullUtils.checkNotNull((Object)((Element)nodesSegmentField.item(i)))));
                ++i;
            }
        }
    }

    public TmfXmlPatternSegment generatePatternSegment(ITmfEvent event, ITmfTimestamp start, ITmfTimestamp end, @Nullable TmfXmlScenarioInfo scenarioInfo) {
        Object value;
        int scale = event.getTimestamp().getScale();
        long startValue = start.toNanos();
        if (this.fBegin != null) {
            Object value2 = this.fBegin.getValue(event, -1, scenarioInfo, this.fContainer);
            startValue = value2 instanceof Number ? ((Number)value2).longValue() : startValue;
        }
        long endValue = end.toNanos();
        if (this.fEnd != null) {
            value = this.fEnd.getValue(event, -1, scenarioInfo, this.fContainer);
            long endLong = value instanceof Number ? ((Number)value).longValue() : endValue;
            endValue = endLong >= startValue ? endLong : endValue;
        } else if (this.fDuration != null) {
            value = this.fDuration.getValue(event, -1, scenarioInfo, this.fContainer);
            long durationLong = value instanceof Number ? ((Number)value).longValue() : 0L;
            endValue = durationLong + startValue >= startValue ? durationLong + startValue : endValue;
        }
        String segmentName = this.getPatternSegmentName(event, scenarioInfo);
        HashMap<String, ITmfStateValue> fields = new HashMap<String, ITmfStateValue>();
        this.setPatternSegmentContent(event, fields, scenarioInfo);
        TmfXmlPatternSegment segment = new TmfXmlPatternSegment(startValue, endValue, scale, segmentName, fields);
        if (this.fContainer instanceof XmlPatternStateProvider) {
            ((XmlPatternStateProvider)this.fContainer).getListener().onNewSegment((ISegment)segment);
        }
        return segment;
    }

    private String getPatternSegmentName(ITmfEvent event, @Nullable TmfXmlScenarioInfo scenarioInfo) {
        return this.fSegmentType.getName(event, scenarioInfo);
    }

    private void setPatternSegmentContent(ITmfEvent event, Map<String, ITmfStateValue> fields, @Nullable TmfXmlScenarioInfo scenarioInfo) {
        for (TmfXmlPatternSegmentField field : this.fFields) {
            fields.put(field.getName().intern(), field.getValue(event, scenarioInfo));
        }
        if (scenarioInfo != null) {
            this.addStoredFieldsContent(event, fields, scenarioInfo);
        }
    }

    protected void addStoredFieldsContent(ITmfEvent event, Map<String, ITmfStateValue> fields, TmfXmlScenarioInfo info) {
        if (this.fContainer instanceof XmlPatternStateProvider) {
            for (Map.Entry<String, String> entry : ((XmlPatternStateProvider)this.fContainer).getStoredFields().entrySet()) {
                ITmfStateValue value = ((XmlPatternStateProvider)this.fContainer).getHistoryBuilder().getStoredFieldValue(this.fContainer, entry.getValue(), info, event);
                if (value.isNull()) continue;
                fields.put(entry.getValue().intern(), value);
            }
        }
    }

    private static ITmfStateValue getStateValueFromConstant(String constantValue, String type) {
        switch (type) {
            case "int": {
                return TmfStateValue.newValueInt((int)Integer.parseInt(constantValue));
            }
            case "long": {
                return TmfStateValue.newValueLong((long)Long.parseLong(constantValue));
            }
            case "string": {
                return TmfStateValue.newValueString((String)constantValue);
            }
            case "null": {
                return TmfStateValue.nullValue();
            }
        }
        throw new IllegalArgumentException("Invalid type of field : " + type);
    }

    private void getNameFromXmlStateValue(ITmfEvent event, StringBuilder builder, DataDrivenValue xmlStateValue, @Nullable TmfXmlScenarioInfo scenarioInfo) {
        Object value = xmlStateValue.getValue(event, -1, scenarioInfo, this.fContainer);
        builder.append(String.valueOf(value));
    }

    private class TmfXmlPatternSegmentField {
        private final String fName;
        private final String fType;
        private final @Nullable ITmfStateValue fStateValue;
        private final @Nullable DataDrivenValue fXmlStateValue;

        public TmfXmlPatternSegmentField(Element element) {
            this.fName = element.getAttribute("name");
            this.fType = element.getAttribute("type");
            String constantValue = element.getAttribute("value");
            if (constantValue.isEmpty() && !this.fType.equals("null")) {
                this.fStateValue = null;
                Element elementFieldStateValue = (Element)element.getElementsByTagName("stateValue").item(0);
                if (elementFieldStateValue == null) {
                    throw new IllegalArgumentException("The value of the field " + this.fName + " is missing");
                }
                this.fXmlStateValue = TmfXmlPatternSegmentBuilder.this.fModelFactory.createStateValue(elementFieldStateValue, TmfXmlPatternSegmentBuilder.this.fContainer);
            } else {
                this.fStateValue = TmfXmlPatternSegmentBuilder.getStateValueFromConstant(constantValue, this.fType);
                this.fXmlStateValue = null;
            }
        }

        public ITmfStateValue getValue(ITmfEvent event, @Nullable TmfXmlScenarioInfo scenarioInfo) {
            if (this.fStateValue != null) {
                return this.fStateValue;
            }
            Object value = ((DataDrivenValue)NonNullUtils.checkNotNull((Object)this.fXmlStateValue)).getValue(event, -1, scenarioInfo, TmfXmlPatternSegmentBuilder.this.fContainer);
            return TmfStateValue.newValue((Object)value);
        }

        public String getName() {
            return this.fName;
        }
    }

    private class TmfXmlPatternSegmentType {
        private final String fSegmentNameAttribute;
        private final @Nullable DataDrivenValue fNameStateValue;

        public TmfXmlPatternSegmentType(Element element) {
            this.fSegmentNameAttribute = element.getAttribute("segName");
            if (!this.fSegmentNameAttribute.isEmpty()) {
                this.fNameStateValue = null;
            } else {
                Element elementSegmentNameStateValue = (Element)element.getElementsByTagName("stateValue").item(0);
                if (elementSegmentNameStateValue == null) {
                    throw new IllegalArgumentException("Failed to get the segment name. A state value is needed.");
                }
                this.fNameStateValue = TmfXmlPatternSegmentBuilder.this.fModelFactory.createStateValue(elementSegmentNameStateValue, TmfXmlPatternSegmentBuilder.this.fContainer);
            }
        }

        public String getName(ITmfEvent event, @Nullable TmfXmlScenarioInfo scenarioInfo) {
            StringBuilder name = new StringBuilder(TmfXmlPatternSegmentBuilder.PATTERN_SEGMENT_NAME_PREFIX);
            if (this.fNameStateValue != null) {
                TmfXmlPatternSegmentBuilder.this.getNameFromXmlStateValue(event, name, this.fNameStateValue, scenarioInfo);
            } else {
                name.append(this.fSegmentNameAttribute);
            }
            return name.toString().intern();
        }
    }
}

