/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.IDataDrivenRuntimeObject;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValue;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.IAnalysisDataContainer;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public interface DataDrivenCondition
extends IDataDrivenRuntimeObject {
    public boolean test(ITmfEvent var1, DataDrivenScenarioInfo var2, IAnalysisDataContainer var3);

    public static enum ConditionOperator implements Predicate<Integer>
    {
        EQ(i -> i == 0),
        NE(i -> i != 0),
        GE(i -> i >= 0),
        GT(i -> i > 0),
        LE(i -> i <= 0),
        LT(i -> i < 0);

        private final Function<Integer, Boolean> fCmpFunction;

        private ConditionOperator(Function<Integer, Boolean> cmpFunction) {
            this.fCmpFunction = cmpFunction;
        }

        @Override
        public boolean test(Integer cmpValue) {
            return Objects.requireNonNull(this.fCmpFunction.apply(cmpValue));
        }
    }

    public static class DataDrivenAndCondition
    implements DataDrivenCondition {
        private final List<DataDrivenCondition> fConditions;

        public DataDrivenAndCondition(List<DataDrivenCondition> conditions) {
            this.fConditions = conditions;
        }

        @Override
        public boolean test(ITmfEvent event, DataDrivenScenarioInfo scenarioInfo, IAnalysisDataContainer container) {
            for (DataDrivenCondition cond : this.fConditions) {
                if (cond.test(event, scenarioInfo, container)) continue;
                return false;
            }
            return true;
        }
    }

    public static class DataDrivenComparisonCondition
    implements DataDrivenCondition {
        private final ConditionOperator fOperator;
        private final DataDrivenValue fFirstValue;
        private final DataDrivenValue fSecondValue;

        public DataDrivenComparisonCondition(DataDrivenValue firstValue, DataDrivenValue secondValue, ConditionOperator operator) {
            this.fFirstValue = firstValue;
            this.fSecondValue = secondValue;
            this.fOperator = operator;
        }

        @Override
        public boolean test(ITmfEvent event, DataDrivenScenarioInfo scenarioInfo, IAnalysisDataContainer container) {
            Object firstValue = this.fFirstValue.getValue(event, -1, scenarioInfo, container);
            Object secondValue = this.fSecondValue.getValue(event, -1, scenarioInfo, container);
            Integer cmpVal = null;
            cmpVal = firstValue instanceof Integer && secondValue instanceof Number ? Integer.valueOf(((Integer)firstValue).compareTo(((Number)secondValue).intValue())) : (firstValue instanceof Long && secondValue instanceof Number ? Integer.valueOf(((Long)firstValue).compareTo(((Number)secondValue).longValue())) : Integer.valueOf(String.valueOf(firstValue).compareTo(String.valueOf(secondValue))));
            return this.fOperator.test(cmpVal);
        }
    }

    public static class DataDrivenElapsedTimeCondition
    implements DataDrivenCondition {
        private final ConditionOperator fOperator;
        private final String fReference;
        private final long fValue;

        public DataDrivenElapsedTimeCondition(ConditionOperator operator, String reference, long value) {
            this.fOperator = operator;
            this.fReference = reference;
            this.fValue = value;
        }

        @Override
        public boolean test(ITmfEvent event, DataDrivenScenarioInfo scenarioInfo, IAnalysisDataContainer container) {
            long ts = event.getTimestamp().toNanos();
            long referenceTs = scenarioInfo.getStateStartTime(container, this.fReference);
            if (referenceTs < 0L) {
                return false;
            }
            return this.fOperator.test(Long.compare(ts - referenceTs, this.fValue));
        }
    }

    public static class DataDrivenOrCondition
    implements DataDrivenCondition {
        private final List<DataDrivenCondition> fConditions;

        public DataDrivenOrCondition(List<DataDrivenCondition> conditions) {
            this.fConditions = conditions;
        }

        @Override
        public boolean test(ITmfEvent event, DataDrivenScenarioInfo scenarioInfo, IAnalysisDataContainer container) {
            for (DataDrivenCondition cond : this.fConditions) {
                if (!cond.test(event, scenarioInfo, container)) continue;
                return true;
            }
            return false;
        }
    }

    public static class DataDrivenTimeRangeCondition
    implements DataDrivenCondition {
        private final TimeRangeOperator fOperator;
        private final long fBegin;
        private final long fEnd;

        public DataDrivenTimeRangeCondition(TimeRangeOperator operator, long begin, long end) {
            this.fOperator = operator;
            this.fBegin = begin;
            this.fEnd = end;
        }

        @Override
        public boolean test(ITmfEvent event, DataDrivenScenarioInfo scenarioInfo, IAnalysisDataContainer container) {
            long ts = event.getTimestamp().toNanos();
            return this.fOperator.test(ts >= this.fBegin && ts <= this.fEnd);
        }
    }

    public static enum TimeRangeOperator implements Predicate<Boolean>
    {
        IN(i -> i),
        OUT(i -> i == false);

        private final Function<Boolean, Boolean> fResultFunction;

        private TimeRangeOperator(Function<Boolean, Boolean> cmpFunction) {
            this.fResultFunction = cmpFunction;
        }

        @Override
        public boolean test(Boolean t) {
            return Objects.requireNonNull(this.fResultFunction.apply(t));
        }
    }

    public static class TmfDdNotCondition
    implements DataDrivenCondition {
        private final DataDrivenCondition fCondition;

        public TmfDdNotCondition(DataDrivenCondition condition) {
            this.fCondition = condition;
        }

        @Override
        public boolean test(ITmfEvent event, DataDrivenScenarioInfo scenarioInfo, IAnalysisDataContainer container) {
            return !this.fCondition.test(event, scenarioInfo, container);
        }
    }
}

