/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.model;

import org.eclipse.core.resources.IResource;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisOutput;
import org.eclipse.tracecompass.tmf.ui.analysis.TmfAnalysisViewOutput;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfAnalysisElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectModelIcons;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.IViewDescriptor;

public class TmfAnalysisOutputElement
extends TmfProjectModelElement {
    private final IAnalysisOutput fOutput;

    protected TmfAnalysisOutputElement(String name, IResource resource, TmfAnalysisElement parent, IAnalysisOutput output) {
        super(name, resource, parent);
        this.fOutput = output;
    }

    @Override
    public Image getIcon() {
        IViewDescriptor descr;
        if (this.fOutput instanceof TmfAnalysisViewOutput && (descr = PlatformUI.getWorkbench().getViewRegistry().find(((TmfAnalysisViewOutput)this.fOutput).getViewId())) != null) {
            Activator bundle = Activator.getDefault();
            String key = descr.getId();
            Image icon = bundle.getImageRegistry().get(key);
            if (icon == null) {
                icon = descr.getImageDescriptor().createImage();
                bundle.getImageRegistry().put(key, icon);
            }
            if (icon != null) {
                return icon;
            }
        }
        return TmfProjectModelIcons.DEFAULT_VIEW_ICON;
    }

    public void outputAnalysis() {
        ITmfProjectModelElement parent = this.getParent();
        if (parent instanceof TmfAnalysisElement) {
            ((TmfAnalysisElement)parent).activateParentTrace();
            this.fOutput.requestOutput();
        }
    }

    @Override
    protected void refreshChildren() {
    }

    IAnalysisOutput getOutput() {
        return this.fOutput;
    }
}

