/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.IAnalysisDataContainer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlScenarioHistoryBuilder;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfAttributePool;

public class DataDrivenScenarioInfo {
    private static final String START_TIME = "startTime";
    public static final DataDrivenScenarioInfo DUMMY_SCENARIO = new DataDrivenScenarioInfo("", TmfXmlScenarioHistoryBuilder.ScenarioStatusType.PENDING, -1, -1);
    private final int fQuark;
    private final int fStatusQuark;
    private String fActiveState;
    private TmfXmlScenarioHistoryBuilder.ScenarioStatusType fStatus;
    private final Map<@NonNull TmfAttributePool, Integer> fPoolAttributes = new HashMap<TmfAttributePool, Integer>();

    public DataDrivenScenarioInfo(String activeState, TmfXmlScenarioHistoryBuilder.ScenarioStatusType status, int quark, int statusQuark) {
        this.fActiveState = activeState;
        this.fQuark = quark;
        this.fStatus = status;
        this.fStatusQuark = statusQuark;
    }

    public void setActiveState(String activeState) {
        this.fActiveState = activeState;
    }

    public void setStatus(TmfXmlScenarioHistoryBuilder.ScenarioStatusType status) {
        this.fStatus = status;
    }

    public int getQuark() {
        return this.fQuark;
    }

    public String getActiveState() {
        return this.fActiveState;
    }

    public TmfXmlScenarioHistoryBuilder.ScenarioStatusType getStatus() {
        return this.fStatus;
    }

    public int getStatusQuark() {
        return this.fStatusQuark;
    }

    public Integer getAttributeFromPool(TmfAttributePool pool) {
        Integer quark = this.fPoolAttributes.get(pool);
        if (quark == null) {
            quark = pool.getAvailable();
            this.fPoolAttributes.put(pool, quark);
        }
        return quark;
    }

    public void recycleAttributes(long ts) {
        this.fPoolAttributes.entrySet().forEach(e -> ((TmfAttributePool)NonNullUtils.checkNotNull((Object)((TmfAttributePool)e.getKey()))).recycle(((Integer)e.getValue()).intValue(), ts));
    }

    public long getStateStartTime(IAnalysisDataContainer container, String state) {
        ITmfStateSystem stateSystem = container.getStateSystem();
        int stateQuark = stateSystem.optQuarkRelative(this.fQuark, new String[]{"state", state, START_TIME});
        if (stateQuark < 0) {
            return -1L;
        }
        Object startTs = stateSystem.queryOngoing(stateQuark);
        if (startTs instanceof Long) {
            return (Long)startTs;
        }
        return -1L;
    }
}

