/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.IAnalysisDataContainer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlAction;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlFsm;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlPatternEventHandler;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlScenarioHistoryBuilder;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlStateTransition;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternStateProvider;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class TmfXmlScenario {
    private final IXmlStateSystemContainer fContainer;
    private final TmfXmlFsm fFsm;
    private TmfXmlPatternEventHandler fPatternHandler;
    private TmfXmlScenarioInfo fScenarioInfo;
    TmfXmlScenarioHistoryBuilder fHistoryBuilder;

    public TmfXmlScenario(@Nullable ITmfEvent event, TmfXmlPatternEventHandler patternHandler, String fsmId, IXmlStateSystemContainer container, ITmfXmlModelFactory modelFactory) {
        TmfXmlFsm fsm = patternHandler.getFsm(fsmId);
        if (fsm == null) {
            throw new IllegalArgumentException(String.valueOf(fsmId) + "has not been declared.");
        }
        this.fFsm = fsm;
        this.fContainer = container;
        this.fHistoryBuilder = ((XmlPatternStateProvider)container).getHistoryBuilder();
        this.fPatternHandler = patternHandler;
        int quark = this.fHistoryBuilder.assignScenarioQuark(this.fContainer, fsmId);
        int statusQuark = this.fHistoryBuilder.getScenarioStatusQuark(this.fContainer, quark);
        this.fScenarioInfo = new TmfXmlScenarioInfo(this.fFsm.getInitialStateId(), TmfXmlScenarioHistoryBuilder.ScenarioStatusType.PENDING, quark, statusQuark, this.fFsm);
        this.fHistoryBuilder.update(this.fContainer, this.fScenarioInfo, event);
    }

    public TmfXmlScenarioInfo getScenarioInfos() {
        return this.fScenarioInfo;
    }

    public void cancel() {
        this.fScenarioInfo.setStatus(TmfXmlScenarioHistoryBuilder.ScenarioStatusType.ABANDONED);
        if (this.fScenarioInfo.getStatus() != TmfXmlScenarioHistoryBuilder.ScenarioStatusType.PENDING) {
            this.fHistoryBuilder.completeScenario(this.fContainer, this.fScenarioInfo, null);
        }
    }

    public boolean isActive() {
        return this.fScenarioInfo.getStatus() == TmfXmlScenarioHistoryBuilder.ScenarioStatusType.IN_PROGRESS;
    }

    public boolean isPending() {
        return this.fScenarioInfo.getStatus() == TmfXmlScenarioHistoryBuilder.ScenarioStatusType.PENDING;
    }

    public void handleEvent(ITmfEvent event, IAnalysisDataContainer container) {
        TmfXmlStateTransition out = this.fFsm.next(event, this.fPatternHandler.getTestMap(), this.fScenarioInfo, container);
        if (out == null) {
            return;
        }
        this.fFsm.setEventConsumed(true);
        List<String> actions = out.getAction();
        for (String actionId : actions) {
            ITmfXmlAction action = this.fPatternHandler.getActionMap().get(actionId);
            if (action != null) {
                action.execute(event, this.fScenarioInfo);
                continue;
            }
            Activator.logError("Action " + actionId + " cannot be found.");
            return;
        }
        @NonNull String nextState = out.getTarget();
        if (this.fScenarioInfo.getStatus().equals((Object)TmfXmlScenarioHistoryBuilder.ScenarioStatusType.PENDING)) {
            this.fScenarioInfo.setStatus(TmfXmlScenarioHistoryBuilder.ScenarioStatusType.IN_PROGRESS);
            this.fHistoryBuilder.startScenario(this.fContainer, this.fScenarioInfo, event);
        }
        if (nextState.equals(this.fFsm.getAbandonStateId())) {
            this.fScenarioInfo.setStatus(TmfXmlScenarioHistoryBuilder.ScenarioStatusType.ABANDONED);
            this.fHistoryBuilder.completeScenario(this.fContainer, this.fScenarioInfo, event);
        } else if (nextState.equals(this.fFsm.getFinalStateId())) {
            this.fScenarioInfo.setStatus(TmfXmlScenarioHistoryBuilder.ScenarioStatusType.MATCHED);
            this.fHistoryBuilder.completeScenario(this.fContainer, this.fScenarioInfo, event);
        }
        this.fScenarioInfo.setActiveState(nextState);
        this.fHistoryBuilder.update(this.fContainer, this.fScenarioInfo, event);
    }
}

