/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.graph.core.tests.analysis.criticalpath;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfVertex;
import org.eclipse.tracecompass.analysis.graph.core.tests.stubs.GraphBuilder;
import org.eclipse.tracecompass.analysis.graph.core.tests.stubs.GraphFactory;
import org.eclipse.tracecompass.analysis.graph.core.tests.stubs.GraphOps;
import org.junit.Assert;
import org.junit.Test;

public abstract class TmfCriticalPathAlgorithmTest {
    protected abstract TmfGraph computeCriticalPath(TmfGraph var1, @NonNull TmfVertex var2);

    protected abstract TmfGraph getExpectedCriticalPath(GraphBuilder var1);

    private void testCriticalPath(GraphBuilder builder, IGraphWorker obj) {
        TmfGraph main = builder.build();
        Assert.assertNotNull((Object)main);
        TmfGraph expected = this.getExpectedCriticalPath(builder);
        Assert.assertNotNull((Object)expected);
        TmfVertex head = null;
        head = obj == null ? main.getHead() : main.getHead(obj);
        Assert.assertNotNull((Object)head);
        TmfGraph actual = this.computeCriticalPath(main, head);
        Assert.assertNotNull((Object)actual);
        GraphOps.checkEquality(expected, actual);
    }

    @Test
    public void testCriticalPathBasic() {
        this.testCriticalPath(GraphFactory.GRAPH_BASIC, null);
    }

    @Test
    public void testCriticalPathWakeupSelf() {
        this.testCriticalPath(GraphFactory.GRAPH_WAKEUP_SELF, null);
    }

    @Test
    public void testCriticalPathWakeupNew() {
        this.testCriticalPath(GraphFactory.GRAPH_WAKEUP_NEW, null);
    }

    @Test
    public void testCriticalPathWakeupUnknown() {
        this.testCriticalPath(GraphFactory.GRAPH_WAKEUP_UNKNOWN, null);
    }

    @Test
    public void testCriticalPathWakeupMutual() {
        this.testCriticalPath(GraphFactory.GRAPH_WAKEUP_MUTUAL, null);
    }

    @Test
    public void testCriticalPathWakeupNested() {
        this.testCriticalPath(GraphFactory.GRAPH_NESTED, GraphFactory.Actor0);
    }

    @Test
    public void testCriticalPathWakeupOpened() {
        this.testCriticalPath(GraphFactory.GRAPH_OPENED, null);
    }

    @Test
    public void testCriticalPathWakeupOpenedDelay() {
        this.testCriticalPath(GraphFactory.GRAPH_OPENED_DELAY, null);
    }

    @Test
    public void testCriticalPathWakeupMissing() {
        this.testCriticalPath(GraphFactory.GRAPH_WAKEUP_MISSING, null);
    }

    @Test
    public void testCriticalPathWakeupEmbedded() {
        this.testCriticalPath(GraphFactory.GRAPH_WAKEUP_EMBEDDED, GraphFactory.Actor0);
    }

    @Test
    public void testCriticalPathWakeupInterleave() {
        this.testCriticalPath(GraphFactory.GRAPH_WAKEUP_INTERLEAVE, GraphFactory.Actor0);
    }

    @Test
    public void testCriticalPathWakeupNet1() {
        this.testCriticalPath(GraphFactory.GRAPH_NET1, GraphFactory.Actor0);
    }
}

