/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.common.core.tests.format;

import java.text.Format;
import java.text.ParseException;
import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.format.DataSizeWithUnitFormat;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DataSizeFormatTest {
    private static final @NonNull Format FORMAT = DataSizeWithUnitFormat.getInstance();
    private final @NonNull Number fNumValue;
    private final @NonNull String fStringValue;
    private final @NonNull Number fParseValue;

    public DataSizeFormatTest(@NonNull Number numValue, @NonNull String stringValue, @NonNull Number parseValue) {
        this.fNumValue = numValue;
        this.fStringValue = stringValue;
        this.fParseValue = parseValue;
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getParameters() {
        return Arrays.asList({0, "0", 0L}, {3, "3 B", 3L}, {975, "975 B", 975L}, {1024, "1 KB", 1024L}, {0x100000, "1 MB", 0x100000L}, {0x40000000, "1 GB", 0x40000000L}, {0x10000000000L, "1 TB", 0x10000000000L}, {4096, "4 KB", 4096L}, {-4096, "-4 KB", -4096L}, {4096L, "4 KB", 4096L}, {4096.0, "4 KB", 4096L}, {12345678, "11.774 MB", 1.2345933824E7}, {Integer.MAX_VALUE, "2 GB", 0x80000000L}, {Integer.MIN_VALUE, "-2 GB", Integer.MIN_VALUE}, {Long.MAX_VALUE, "8388608 TB", 9.223372036854776E18}, {9.8765432123456E7, "94.19 MB", 9.876537344E7}, {-9.8765432123456E7, "-94.19 MB", -9.876537344E7}, {555555555555L, "517.401 GB", 5.55555093479424E11}, {555555555555555L, "505.275 TB", 5.555557377245184E14});
    }

    protected Format getFormatter() {
        return FORMAT;
    }

    @Test
    public void testFormat() {
        Assert.assertEquals((String)"format value", (Object)this.fStringValue, (Object)this.getFormatter().format(this.fNumValue));
    }

    @Test
    public void testParseObject() throws ParseException {
        Assert.assertEquals((String)"parseObject value", (Object)this.fParseValue, (Object)this.getFormatter().parseObject(this.fStringValue));
    }
}

