/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.common.core.tests.format;

import java.text.Format;
import java.text.ParseException;
import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.format.DecimalUnitFormat;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DecimalUnitFormatTest {
    private static final @NonNull Format FORMATTER = new DecimalUnitFormat();
    private final @NonNull Number fNumValue;
    private final @NonNull String fStringValue;
    private final @NonNull Number fParseValue;

    public DecimalUnitFormatTest(@NonNull Number numValue, @NonNull String stringValue, @NonNull Number parseValue) {
        this.fNumValue = numValue;
        this.fStringValue = stringValue;
        this.fParseValue = parseValue;
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getParameters() {
        return Arrays.asList({3, "3", 3L}, {5.6, "5.6", 5.6}, {1.234567, "1.2", 1.2}, {1.01, "1", 1L}, {975, "975", 975L}, {1000, "1 k", 1000L}, {4000, "4 k", 4000L}, {-4000, "-4 k", -4000L}, {4000L, "4 k", 4000L}, {4000.0, "4 k", 4000L}, {12345678, "12.3 M", 12300000L}, {Integer.MAX_VALUE, "2.1 G", 2100000000L}, {Integer.MIN_VALUE, "-2.1 G", -2100000000L}, {Long.MAX_VALUE, "9223.4 P", 9.2234E18}, {9.8765432123456E7, "98.8 M", 98800000L}, {-9.8765432123456E7, "-98.8 M", -98800000L}, {555555555555L, "555.6 G", 555600000000L}, {555555555555555L, "555.6 T", 555600000000000L}, {100100000, "100.1 M", 100100000L}, {0.1, "100 m", 0.1}, {0.001, "1 m", 0.001}, {1.0E-6, "1 \u00b5", 1.0E-6}, {1.0E-9, "1 n", 1.0E-9}, {1.0E-12, "1 p", 1.0E-12}, {1.0E-13, "0", 0L}, {-0.04, "-40 m", -0.04}, {0.002, "2 m", 0.002}, {0.0555, "55.5 m", 0.0555}, {4.928373928E-4, "492.8 \u00b5", 4.928E-4}, {2.51E-7, "251 n", 2.51E-7}, {4.3E-11, "43 p", 4.3E-11}, {4.5643E-8, "45.6 n", 4.56E-8}, {Double.MAX_VALUE, "1.7976931348623157E308", Double.MAX_VALUE}, {Double.POSITIVE_INFINITY, "\u221e", Double.POSITIVE_INFINITY}, {Double.MIN_NORMAL, "0", 0L}, {Double.NEGATIVE_INFINITY, "-\u221e", Double.NEGATIVE_INFINITY}, {Double.NaN, "\ufffd", Double.NaN});
    }

    @Test
    public void testFormat() {
        Assert.assertEquals((String)"format value", (Object)this.fStringValue, (Object)FORMATTER.format(this.fNumValue));
    }

    @Test
    public void testParseObject() throws ParseException {
        Assert.assertEquals((String)"parseObject value", (Object)this.fParseValue, (Object)FORMATTER.parseObject(this.fStringValue));
    }
}

