/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.trace;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.IEventDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.tests.shared.CtfTestTraceUtils;
import org.eclipse.tracecompass.ctf.core.trace.CTFStreamInput;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.core.trace.ICTFStream;
import org.eclipse.tracecompass.internal.ctf.core.event.EventDeclaration;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.trace.CTFStream;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CTFStreamTest {
    private static final CtfTestTrace testTrace = CtfTestTrace.KERNEL;
    private CTFStream fixture;
    private CTFStreamInput fInput;

    @Before
    public void setUp() throws CTFException {
        this.fixture = new CTFStream(CtfTestTraceUtils.getTrace(testTrace));
        this.fixture.setEventContext(new StructDeclaration(1L));
        this.fixture.setPacketContext(new StructDeclaration(1L));
        this.fixture.setEventHeader(new StructDeclaration(1L));
        this.fixture.setId(1L);
        this.fInput = new CTFStreamInput((ICTFStream)new CTFStream(CtfTestTraceUtils.getTrace(testTrace)), CTFStreamTest.createFile());
        this.fixture.addInput(this.fInput);
    }

    private static @NonNull File createFile() throws CTFException {
        File path = new File(CtfTestTraceUtils.getTrace(testTrace).getPath());
        File[] listFiles = path.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.contains("hann");
            }
        });
        Assert.assertNotNull((Object)listFiles);
        File returnFile = listFiles[0];
        Assert.assertNotNull((Object)returnFile);
        return returnFile;
    }

    @Test
    public void testStream() throws CTFException {
        CTFTrace trace = CtfTestTraceUtils.getTrace(testTrace);
        CTFStream result = new CTFStream(trace);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testAddEvent_base() throws ParseException {
        EventDeclaration event = new EventDeclaration();
        this.fixture.addEvent((IEventDeclaration)event);
    }

    @Test
    public void testEventContextIsSet() {
        Assert.assertTrue((boolean)this.fixture.isEventContextSet());
    }

    @Test
    public void testToString() {
        Assert.assertNotNull((Object)this.fixture.toString());
    }

    @Test
    public void testEventHeaderIsSet() {
        Assert.assertTrue((boolean)this.fixture.isEventHeaderSet());
    }

    @Test
    public void testGetEventContextDecl() {
        Assert.assertNotNull((Object)this.fixture.getEventContextDecl());
    }

    @Test
    public void testGetEventHeaderDecl() {
        IDeclaration eventHeaderDecl = this.fixture.getEventHeaderDeclaration();
        Assert.assertNotNull((Object)eventHeaderDecl);
    }

    @Test
    public void testGetEvents() {
        Assert.assertNotNull((Object)this.fixture.getEventDeclarations());
    }

    @Test
    public void testGetId() {
        Long result = this.fixture.getId();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetPacketContextDecl() {
        StructDeclaration result = this.fixture.getPacketContextDecl();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetStreamInputs() {
        Set result = this.fixture.getStreamInputs();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetTrace() {
        CTFTrace result = this.fixture.getTrace();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testIdIsSet() {
        boolean result = this.fixture.isIdSet();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testPacketContextIsSet() {
        boolean result = this.fixture.isPacketContextSet();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testSetEventContext() {
        StructDeclaration eventContext = new StructDeclaration(1L);
        this.fixture.setEventContext(eventContext);
    }

    @Test
    public void testSetEventHeader() {
        StructDeclaration eventHeader = new StructDeclaration(1L);
        this.fixture.setEventHeader(eventHeader);
    }

    @Test
    public void testSetId() {
        long id = 1L;
        this.fixture.setId(id);
    }

    @Test
    public void testSetPacketContext() {
        StructDeclaration packetContext = new StructDeclaration(1L);
        this.fixture.setPacketContext(packetContext);
    }
}

