/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.types;

import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.IEventDeclaration;
import org.eclipse.tracecompass.ctf.core.event.IEventDefinition;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.tests.shared.CtfTestTraceUtils;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.core.trace.CTFTraceReader;
import org.eclipse.tracecompass.internal.ctf.core.event.EventDeclaration;
import org.eclipse.tracecompass.internal.ctf.core.event.LostEventDeclaration;
import org.eclipse.tracecompass.internal.ctf.core.trace.CTFStream;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EventDeclarationTest {
    private static final CtfTestTrace testTrace = CtfTestTrace.KERNEL;
    private EventDeclaration fixture;
    IEventDeclaration e1;
    IEventDeclaration e2;

    @Before
    public void setUp() throws CTFException {
        this.fixture = new EventDeclaration();
        this.fixture.setContext(new StructDeclaration(1L));
        this.fixture.setId(1L);
        this.fixture.setFields(new StructDeclaration(1L));
        this.fixture.setStream(new CTFStream(CtfTestTraceUtils.getTrace(testTrace)));
        this.fixture.setName("");
    }

    @Test
    public void testEventDeclaration() {
        EventDeclaration result = new EventDeclaration();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testContextIsSet() {
        boolean result = this.fixture.contextIsSet();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testContextIsSet_null() {
        this.fixture.setContext(null);
        boolean result = this.fixture.contextIsSet();
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testEquals() throws CTFException {
        EventDeclaration obj = new EventDeclaration();
        obj.setContext(new StructDeclaration(1L));
        obj.setId(1L);
        obj.setFields(new StructDeclaration(1L));
        obj.setStream(new CTFStream(CtfTestTraceUtils.getTrace(testTrace)));
        obj.setName("");
        Assert.assertTrue((boolean)this.fixture.equals((Object)this.fixture));
        boolean result = this.fixture.equals((Object)obj);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testEquals_null() {
        Object obj = null;
        boolean result = this.fixture.equals(obj);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testEquals_emptyObject() {
        Object obj = new Object();
        boolean result = this.fixture.equals(obj);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testEquals_other1() {
        EventDeclaration obj = new EventDeclaration();
        obj.setContext(this.fixture.getContext());
        boolean result = this.fixture.equals((Object)obj);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testEquals_other2() {
        EventDeclaration obj = new EventDeclaration();
        obj.setContext(new StructDeclaration(1L));
        obj.setFields(new StructDeclaration(1L));
        boolean result = this.fixture.equals((Object)obj);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testEquals_other3() {
        EventDeclaration obj = new EventDeclaration();
        obj.setContext(new StructDeclaration(1L));
        obj.setId(1L);
        obj.setFields(new StructDeclaration(1L));
        boolean result = this.fixture.equals((Object)obj);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testEquals_other4() {
        EventDeclaration obj = new EventDeclaration();
        obj.setContext(new StructDeclaration(1L));
        obj.setId(1L);
        obj.setFields(new StructDeclaration(1L));
        obj.setName("");
        boolean result = this.fixture.equals((Object)obj);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testFieldsIsSet() {
        boolean result = this.fixture.fieldsIsSet();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testFieldsIsSet_null() {
        this.fixture.setFields(null);
        boolean result = this.fixture.fieldsIsSet();
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testGetFields() {
        StructDeclaration result = this.fixture.getFields();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetId() {
        Assert.assertEquals((long)1L, (long)this.fixture.id());
    }

    @Test
    public void testGetName() {
        String result = this.fixture.getName();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetStream() {
        CTFStream result = this.fixture.getStream();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testHashCode() {
        int result = this.fixture.hashCode();
        Assert.assertTrue((result != 0 ? 1 : 0) != 0);
    }

    @Test
    public void testHashCode_null() {
        this.fixture.setStream(null);
        this.fixture.setName(null);
        int result = this.fixture.hashCode();
        Assert.assertTrue((result != 0 ? 1 : 0) != 0);
    }

    @Test
    public void testIdIsSet() {
        boolean result = this.fixture.idIsSet();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testNameIsSet() {
        boolean result = this.fixture.nameIsSet();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testNameIsSet_null() {
        this.fixture.setName(null);
        boolean result = this.fixture.nameIsSet();
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testStreamIsSet() {
        boolean result = this.fixture.streamIsSet();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testStreamIsSet_null() {
        this.fixture.setStream(null);
        boolean result = this.fixture.streamIsSet();
        Assert.assertEquals((Object)false, (Object)result);
    }

    @Test
    public void testEventDefinition() throws CTFException {
        CTFTrace trace = CtfTestTraceUtils.getTrace(testTrace);
        IEventDefinition ed = null;
        Throwable throwable = null;
        Object var4_5 = null;
        try (CTFTraceReader tr = new CTFTraceReader(trace);){
            tr.advance();
            ed = tr.getCurrentEventDef();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertTrue((boolean)(ed instanceof IDefinitionScope));
        IDefinitionScope ds = (IDefinitionScope)ed;
        Assert.assertNotNull((Object)ed);
        Assert.assertNotNull((Object)ds.getScopePath());
        Assert.assertNotNull((Object)ed.getDeclaration());
        Assert.assertNotNull((Object)ed.getFields());
        Assert.assertNull((Object)ed.getContext());
        Assert.assertNotNull((Object)ed.getPacketContext());
        Assert.assertNotNull((Object)ed.getCPU());
        Assert.assertNull((Object)ds.lookupDefinition("context"));
        Assert.assertNotNull((Object)ds.lookupDefinition("fields"));
        Assert.assertNull((Object)ds.lookupDefinition("other"));
        Assert.assertNotNull((Object)ed.toString());
    }

    @Test
    public void testEquals1() {
        this.e1 = new EventDeclaration();
        Assert.assertFalse((boolean)this.e1.equals(null));
    }

    @Test
    public void testEquals2() {
        this.e1 = LostEventDeclaration.INSTANCE;
        Assert.assertFalse((boolean)this.e1.equals(new Long(23L)));
    }

    @Test
    public void testEquals3() {
        this.e1 = LostEventDeclaration.INSTANCE;
        Assert.assertEquals((Object)this.e1, (Object)this.e1);
    }

    @Test
    public void testEquals4() {
        this.e1 = LostEventDeclaration.INSTANCE;
        this.e2 = LostEventDeclaration.INSTANCE;
        Assert.assertEquals((Object)this.e1, (Object)this.e2);
    }

    @Test
    public void testEquals5() {
        this.e1 = LostEventDeclaration.INSTANCE;
        this.e2 = new EventDeclaration();
        Assert.assertFalse((boolean)this.e1.equals(this.e2));
    }
}

