/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.integration.swtbot.tests.perspectives;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.tracecompass.ctf.core.tests.shared.LttngTraceGenerator;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class TmfPerspectiveManagerTest {
    private static final String TRACE_PROJECT_NAME = "test";
    private static final String KERNEL_TRACE_TYPE = "org.eclipse.linuxtools.lttng2.kernel.tracetype";
    private static final String UST_TRACE_TYPE = "org.eclipse.linuxtools.lttng2.ust.tracetype";
    private static File fTmpFolder = null;
    private static String fKernelPath = null;
    private static String fUstPath = null;
    private static SWTWorkbenchBot fBot;
    private static final Logger fLogger;

    static {
        fLogger = Logger.getRootLogger();
    }

    @BeforeClass
    public static void beforeClass() throws IOException {
        SWTBotUtils.initialize();
        fTmpFolder = File.createTempFile("testTraces", "");
        if (!fTmpFolder.isDirectory()) {
            fTmpFolder.delete();
            fTmpFolder.mkdir();
        }
        LttngTraceGenerator kernelGenerator = new LttngTraceGenerator(1000L, 1000L, 1);
        LttngTraceGenerator ustGenerator = new LttngTraceGenerator(1000L, 1000L, 1, false);
        fKernelPath = String.valueOf(fTmpFolder.getAbsolutePath()) + File.separator + "kernel";
        fUstPath = String.valueOf(fTmpFolder.getAbsolutePath()) + File.separator + "ust";
        kernelGenerator.writeTrace(new File(fKernelPath));
        ustGenerator.writeTrace(new File(fUstPath));
        SWTBotPreferences.TIMEOUT = 20000L;
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout(), "System.out"));
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.closeView((String)"Welcome", (SWTWorkbenchBot)fBot);
        WaitUtils.waitForJobs();
        SWTBotUtils.createProject((String)TRACE_PROJECT_NAME);
    }

    @AfterClass
    public static void afterClass() {
        SWTBotUtils.deleteProject((String)TRACE_PROJECT_NAME, (SWTWorkbenchBot)fBot);
        fLogger.removeAllAppenders();
    }

    @Before
    public void before() {
        SWTBotUtils.switchToPerspective((String)"org.eclipse.ui.resourcePerspective");
    }

    @After
    public void after() {
        fBot.closeAllEditors();
        SWTBotUtils.closeSecondaryShells((SWTWorkbenchBot)fBot);
    }

    @Test
    public void testPromptYes() {
        TmfPerspectiveManagerTest.setSwitchToPerspectivePreference("Prompt");
        SWTBotUtils.openTrace((String)TRACE_PROJECT_NAME, (String)fKernelPath, (String)KERNEL_TRACE_TYPE);
        TmfPerspectiveManagerTest.confirmPerspectiveSwitch(true, false);
        TmfPerspectiveManagerTest.assertActivePerspective("LTTng Kernel");
        TmfPerspectiveManagerTest.assertSwitchToPerspectivePreference("Prompt");
    }

    @Test
    public void testPromptNo() {
        TmfPerspectiveManagerTest.setSwitchToPerspectivePreference("Prompt");
        SWTBotUtils.openTrace((String)TRACE_PROJECT_NAME, (String)fKernelPath, (String)KERNEL_TRACE_TYPE);
        TmfPerspectiveManagerTest.confirmPerspectiveSwitch(false, false);
        TmfPerspectiveManagerTest.assertActivePerspective("Resource");
        TmfPerspectiveManagerTest.assertSwitchToPerspectivePreference("Prompt");
    }

    @Test
    public void testPromptYesRemember() {
        TmfPerspectiveManagerTest.setSwitchToPerspectivePreference("Prompt");
        SWTBotUtils.openTrace((String)TRACE_PROJECT_NAME, (String)fKernelPath, (String)KERNEL_TRACE_TYPE);
        TmfPerspectiveManagerTest.confirmPerspectiveSwitch(true, true);
        TmfPerspectiveManagerTest.assertActivePerspective("LTTng Kernel");
        TmfPerspectiveManagerTest.assertSwitchToPerspectivePreference("Always");
    }

    @Test
    public void testPromptNoRemember() {
        TmfPerspectiveManagerTest.setSwitchToPerspectivePreference("Prompt");
        SWTBotUtils.openTrace((String)TRACE_PROJECT_NAME, (String)fKernelPath, (String)KERNEL_TRACE_TYPE);
        TmfPerspectiveManagerTest.confirmPerspectiveSwitch(false, true);
        TmfPerspectiveManagerTest.assertActivePerspective("Resource");
        TmfPerspectiveManagerTest.assertSwitchToPerspectivePreference("Never");
    }

    @Test
    public void testAlways() {
        TmfPerspectiveManagerTest.setSwitchToPerspectivePreference("Always");
        SWTBotUtils.openTrace((String)TRACE_PROJECT_NAME, (String)fKernelPath, (String)KERNEL_TRACE_TYPE);
        TmfPerspectiveManagerTest.assertActivePerspective("LTTng Kernel");
    }

    @Test
    public void testNever() {
        TmfPerspectiveManagerTest.setSwitchToPerspectivePreference("Never");
        SWTBotUtils.openTrace((String)TRACE_PROJECT_NAME, (String)fKernelPath, (String)KERNEL_TRACE_TYPE);
        TmfPerspectiveManagerTest.assertActivePerspective("Resource");
    }

    @Test
    public void testNoAssociatedPerspective() {
        TmfPerspectiveManagerTest.setSwitchToPerspectivePreference("Always");
        SWTBotUtils.openTrace((String)TRACE_PROJECT_NAME, (String)fUstPath, (String)UST_TRACE_TYPE);
        TmfPerspectiveManagerTest.assertActivePerspective("Resource");
    }

    private static void setSwitchToPerspectivePreference(String value) {
        SWTBotUtils.openPreferences((SWTBot)fBot);
        SWTBot shellBot = fBot.shell("Preferences").bot();
        shellBot.tree().expandNode(new String[]{"Tracing", "Perspectives"}).select();
        shellBot.radioInGroup(value, "Open the associated perspective when a trace is opened").click();
        SWTBotUtils.pressOKishButtonInPreferences((SWTBot)fBot);
    }

    private static void assertSwitchToPerspectivePreference(String value) {
        SWTBotUtils.openPreferences((SWTBot)fBot);
        SWTBot shellBot = fBot.shell("Preferences").bot();
        shellBot.tree().expandNode(new String[]{"Tracing", "Perspectives"}).select();
        Assert.assertTrue((boolean)shellBot.radioInGroup(value, "Open the associated perspective when a trace is opened").isSelected());
        shellBot.button("Cancel").click();
    }

    private static void confirmPerspectiveSwitch(boolean confirm, boolean remember) {
        SWTBot shellBot = fBot.shell("Confirm Perspective Switch").bot();
        if (remember) {
            shellBot.checkBox("Remember my decision").click();
        }
        if (confirm) {
            shellBot.button("Yes").click();
        } else {
            shellBot.button("No").click();
        }
    }

    private static void assertActivePerspective(String perspective) {
        Assert.assertEquals((Object)perspective, (Object)new SWTWorkbenchBot().activePerspective().getLabel());
    }
}

